/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.blocks;

import com.hedera.hapi.block.stream.Block;
import com.hedera.hapi.block.stream.BlockItem;
import com.hedera.hapi.block.stream.output.MapChangeKey;
import com.hedera.hapi.block.stream.output.MapUpdateChange;
import com.hedera.hapi.block.stream.output.SingletonUpdateChange;
import com.hedera.hapi.block.stream.output.StateChange;
import com.hedera.pbj.runtime.ParseException;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.zip.GZIPInputStream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public enum BlockStreamAccess {
    BLOCK_STREAM_ACCESS;

    private static final Logger log;

    public List<Block> readBlocks(@NonNull Path path) {
        return BlockStreamAccess.readBlocks(path, true).toList();
    }

    public static Stream<Block> readBlocks(@NonNull Path path, boolean checkForMarkerFiles) {
        try {
            return BlockStreamAccess.orderedBlocksFrom(path, checkForMarkerFiles).stream().map(BlockStreamAccess::blockFrom);
        }
        catch (IOException e) {
            log.error("Failed to read blocks from path {}", (Object)path, (Object)e);
            throw new UncheckedIOException(e);
        }
    }

    public static Set<Long> getAllMarkerFileNumbers(@NonNull Path path) {
        Set set;
        block8: {
            Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);
            try {
                set = stream.map(BlockStreamAccess::extractMarkerFileNumber).filter(num -> num != -1L).sorted().collect(Collectors.toCollection(LinkedHashSet::new));
                if (stream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    log.error("Failed to read blocks from path {}", (Object)path, (Object)e);
                    throw new UncheckedIOException(e);
                }
            }
            stream.close();
        }
        return set;
    }

    @Nullable
    public static <V> V computeSingletonValueFromUpdates(@NonNull List<Block> blocks, @NonNull Function<SingletonUpdateChange, V> extractFn, int stateId) {
        AtomicReference lastValue = new AtomicReference();
        BlockStreamAccess.stateChangesForState(blocks, stateId).filter(StateChange::hasSingletonUpdate).map(StateChange::singletonUpdateOrThrow).forEach(update -> lastValue.set(extractFn.apply((SingletonUpdateChange)update)));
        return lastValue.get();
    }

    public static <K, V> Map<K, V> computeMapFromUpdates(@NonNull List<Block> blocks, @NonNull Function<MapChangeKey, K> deleteFn, @NonNull Function<MapUpdateChange, Map.Entry<K, V>> updateFn, int stateId) {
        HashMap upToDate = new HashMap();
        blocks.forEach(block -> block.items().stream().filter(BlockItem::hasStateChanges).flatMap(item -> item.stateChangesOrThrow().stateChanges().stream()).filter(change -> change.stateId() == stateId).forEach(change -> {
            if (change.hasMapDelete()) {
                Object removedKey = deleteFn.apply(change.mapDeleteOrThrow().keyOrThrow());
                upToDate.remove(removedKey);
            } else if (change.hasMapUpdate()) {
                MapUpdateChange mapUpdate = change.mapUpdateOrThrow();
                Map.Entry entry = (Map.Entry)updateFn.apply(mapUpdate);
                upToDate.put(entry.getKey(), entry.getValue());
            }
        }));
        return upToDate;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Block blockFrom(@NonNull Path path) {
        Block block;
        String fileName = path.getFileName().toString();
        if (!fileName.endsWith(".gz")) return (Block)Block.PROTOBUF.parse(Bytes.wrap((byte[])Files.readAllBytes(path)));
        GZIPInputStream in = new GZIPInputStream(Files.newInputStream(path, new OpenOption[0]));
        try {
            block = (Block)Block.PROTOBUF.parse(Bytes.wrap((byte[])in.readAllBytes()));
        }
        catch (Throwable throwable) {
            try {
                try {
                    in.close();
                    throw throwable;
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (ParseException | IOException e) {
                throw new RuntimeException("Failed reading block @ " + String.valueOf(path), e);
            }
        }
        in.close();
        return block;
    }

    private static Stream<StateChange> stateChangesForState(@NonNull List<Block> blocks, int stateId) {
        return blocks.stream().flatMap(block -> block.items().stream().filter(BlockItem::hasStateChanges).flatMap(item -> item.stateChangesOrThrow().stateChanges().stream()).filter(change -> change.stateId() == stateId));
    }

    private static List<Path> orderedBlocksFrom(@NonNull Path path, boolean checkForMarkerFiles) throws IOException {
        try (Stream<Path> stream = Files.walk(path, new FileVisitOption[0]);){
            List<Path> list = stream.filter(p -> BlockStreamAccess.isBlockFile(p, checkForMarkerFiles)).sorted(Comparator.comparing(BlockStreamAccess::extractBlockNumber)).toList();
            return list;
        }
    }

    public static boolean isBlockFile(@NonNull Path path, boolean checkForMarkerFiles) {
        if (!path.toFile().isFile() || BlockStreamAccess.extractBlockNumber(path) == -1L) {
            return false;
        }
        String name = path.getFileName().toString();
        if (name.endsWith(".pnd.json")) {
            return false;
        }
        if (name.endsWith(".pnd")) {
            return Files.exists(path.resolveSibling(name + ".json"), new LinkOption[0]);
        }
        if (name.endsWith(".pnd.gz")) {
            return Files.exists(path.resolveSibling(name.replace(".gz", ".json")), new LinkOption[0]);
        }
        return !checkForMarkerFiles || Files.exists(path.resolveSibling(name.replace(".blk.gz", ".mf").replace(".blk", ".mf")), new LinkOption[0]);
    }

    public static long extractBlockNumber(@NonNull Path path) {
        return BlockStreamAccess.extractBlockNumber(path.getFileName().toString());
    }

    public static boolean isBlockFile(@NonNull File file) {
        return file.isFile() && BlockStreamAccess.extractBlockNumber(file.getName()) != -1L;
    }

    public static long extractBlockNumber(@NonNull String fileName) {
        try {
            int i = fileName.indexOf(".blk");
            if (i == -1) {
                i = fileName.indexOf(".pnd");
            }
            return Long.parseLong(fileName.substring(0, i));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    private static long extractMarkerFileNumber(@NonNull Path path) {
        String fileName = path.getFileName().toString();
        if (!fileName.endsWith(".mf")) {
            return -1L;
        }
        try {
            int i = fileName.indexOf(".mf");
            return Long.parseLong(fileName.substring(0, i));
        }
        catch (Exception exception) {
            return -1L;
        }
    }

    public static boolean isBlockMarkerFile(@NonNull File file) {
        return file.isFile() && file.getName().endsWith(".mf") && !file.getName().contains("Z_");
    }

    static {
        log = LogManager.getLogger(BlockStreamAccess.class);
    }
}

