/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.networkadmin.impl.handlers;

import com.hedera.hapi.node.base.Timestamp;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.file.ReadableUpgradeFileStore;
import com.hedera.node.app.service.networkadmin.impl.WritableFreezeStore;
import com.hedera.node.app.service.networkadmin.impl.handlers.ReadableFreezeUpgradeActions;
import com.hedera.node.app.service.token.ReadableStakingInfoStore;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.concurrent.Executor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class FreezeUpgradeActions
extends ReadableFreezeUpgradeActions {
    private static final Logger log = LogManager.getLogger(FreezeUpgradeActions.class);
    private final WritableFreezeStore freezeStore;

    public FreezeUpgradeActions(@NonNull Configuration configuration, @NonNull WritableFreezeStore freezeStore, @NonNull Executor executor, @NonNull ReadableUpgradeFileStore upgradeFileStore, @NonNull ReadableNodeStore nodeStore, @NonNull ReadableStakingInfoStore stakingInfoStore, @NonNull EntityIdFactory entityIdFactory) {
        super(configuration, freezeStore, executor, upgradeFileStore, nodeStore, stakingInfoStore, entityIdFactory);
        this.freezeStore = freezeStore;
    }

    public void scheduleFreezeOnlyAt(@NonNull Timestamp freezeTime) {
        Objects.requireNonNull(freezeTime);
        Objects.requireNonNull(this.freezeStore, "Cannot schedule freeze without access to the dual state");
        this.freezeStore.freezeTime(freezeTime);
    }

    public void scheduleFreezeUpgradeAt(@NonNull Timestamp freezeTime) {
        Objects.requireNonNull(freezeTime);
        Objects.requireNonNull(this.freezeStore, "Cannot schedule freeze without access to the dual state");
        this.freezeStore.freezeTime(freezeTime);
        this.writeSecondMarker("freeze_scheduled.mf", freezeTime);
    }

    public void abortScheduledFreeze() {
        Objects.requireNonNull(this.freezeStore, "Cannot abort freeze without access to the dual state");
        this.freezeStore.freezeTime(Timestamp.DEFAULT);
        this.writeCheckMarker("freeze_aborted.mf");
    }
}

