/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SubType;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenDeleteTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.usage.EstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.SigUsage;
import com.hedera.node.app.hapi.fees.usage.SingletonEstimatorUtils;
import com.hedera.node.app.hapi.fees.usage.TxnUsageEstimator;
import com.hedera.node.app.hapi.fees.usage.crypto.CryptoOpsUsage;
import com.hedera.node.app.hapi.fees.usage.token.TokenDeleteUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.fee.SigValueObj;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.service.token.impl.WritableAccountStore;
import com.hedera.node.app.service.token.impl.WritableTokenStore;
import com.hedera.node.app.service.token.impl.util.TokenHandlerHelper;
import com.hedera.node.app.service.token.records.TokenBaseStreamBuilder;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.store.StoreFactory;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.PreHandleContext;
import com.hedera.node.app.spi.workflows.PureChecksContext;
import com.hedera.node.app.spi.workflows.TransactionHandler;
import com.hederahashgraph.api.proto.java.FeeData;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenDeleteHandler
implements TransactionHandler {
    @Inject
    public TokenDeleteHandler() {
    }

    public void preHandle(@NonNull PreHandleContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TokenDeleteTransactionBody op = context.body().tokenDeletionOrThrow();
        TokenID tokenId = op.tokenOrElse(TokenID.DEFAULT);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        ReadableTokenStore.TokenMetadata tokenMetadata = tokenStore.getTokenMeta(tokenId);
        if (tokenMetadata == null) {
            throw new PreCheckException(ResponseCodeEnum.INVALID_TOKEN_ID);
        }
        if (tokenMetadata.hasAdminKey()) {
            context.requireKey(tokenMetadata.adminKey());
        }
    }

    public void pureChecks(@NonNull PureChecksContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        TransactionBody txn = context.body();
        TokenDeleteTransactionBody op = txn.tokenDeletionOrThrow();
        PreCheckException.validateTruePreCheck((boolean)op.hasToken(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
    }

    public void handle(@NonNull HandleContext context) throws HandleException {
        StoreFactory storeFactory = context.storeFactory();
        WritableTokenStore tokenStore = (WritableTokenStore)storeFactory.writableStore(WritableTokenStore.class);
        WritableAccountStore accountStore = (WritableAccountStore)storeFactory.writableStore(WritableAccountStore.class);
        TransactionBody txn = context.body();
        TokenDeleteTransactionBody op = txn.tokenDeletionOrThrow();
        TokenID tokenId = op.tokenOrThrow();
        Token token = this.validateSemantics(tokenId, tokenStore);
        Token updatedToken = token.copyBuilder().deleted(true).build();
        tokenStore.put(updatedToken);
        Account account = accountStore.get(token.treasuryAccountId());
        Account updatedAccount = account.copyBuilder().numberTreasuryTitles(account.numberTreasuryTitles() - 1).build();
        accountStore.put(updatedAccount);
        TokenBaseStreamBuilder tokenBaseStreamBuilder = (TokenBaseStreamBuilder)context.savepointStack().getBaseBuilder(TokenBaseStreamBuilder.class);
        tokenBaseStreamBuilder.tokenType(updatedToken.tokenType());
    }

    @NonNull
    public Token validateSemantics(@NonNull TokenID tokenId, @NonNull ReadableTokenStore tokenStore) {
        Token token = TokenHandlerHelper.getIfUsable(tokenId, tokenStore);
        HandleException.validateTrue((token.adminKey() != null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.TOKEN_IS_IMMUTABLE);
        return token;
    }

    @NonNull
    public Fees calculateFees(@NonNull FeeContext feeContext) {
        Objects.requireNonNull(feeContext);
        TransactionBody op = feeContext.body();
        return feeContext.feeCalculatorFactory().feeCalculator(SubType.DEFAULT).legacyCalculate(sigValueObj -> this.usageGiven(CommonPbjConverters.fromPbj((TransactionBody)op), (SigValueObj)sigValueObj));
    }

    private FeeData usageGiven(com.hederahashgraph.api.proto.java.TransactionBody txn, SigValueObj svo) {
        SigUsage sigUsage = new SigUsage(svo.getTotalSigCount(), svo.getSignatureSize(), svo.getPayerAcctSigCount());
        TokenDeleteUsage estimate = TokenDeleteUsage.newEstimate((com.hederahashgraph.api.proto.java.TransactionBody)txn, (TxnUsageEstimator)CryptoOpsUsage.txnEstimateFactory.get(sigUsage, txn, (EstimatorUtils)SingletonEstimatorUtils.ESTIMATOR_UTILS));
        return estimate.get();
    }
}

