/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIJSON;
import com.esaulpaugh.headlong.abi.ABIObject;
import com.esaulpaugh.headlong.abi.Function;
import com.esaulpaugh.headlong.abi.Tuple;
import com.esaulpaugh.headlong.abi.TupleType;
import com.esaulpaugh.headlong.abi.TypeEnum;
import java.io.InputStream;
import java.util.Objects;

public final class ContractError<J extends Tuple>
implements ABIObject {
    private final String name;
    private final TupleType<J> inputs;

    public ContractError(String name, TupleType<J> inputs) {
        this.name = Objects.requireNonNull(name);
        this.inputs = Objects.requireNonNull(inputs);
    }

    @Override
    public TypeEnum getType() {
        return TypeEnum.ERROR;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TupleType<J> getInputs() {
        return this.inputs;
    }

    @Override
    public String getCanonicalSignature() {
        return this.name + this.inputs.canonicalType;
    }

    public Function function() {
        return Function.parse(this.getCanonicalSignature());
    }

    @Override
    public boolean isContractError() {
        return true;
    }

    public int hashCode() {
        return 31 * this.name.hashCode() + this.inputs.hashCode();
    }

    public boolean equals(Object o) {
        if (o instanceof ContractError) {
            ContractError that = (ContractError)o;
            return this.name.equals(that.name) && this.inputs.equals(that.inputs);
        }
        return false;
    }

    public String toString() {
        return this.toJson(true);
    }

    public static <X extends Tuple> ContractError<X> fromJson(String errorJson) {
        return ContractError.fromJson(0, errorJson);
    }

    public static <X extends Tuple> ContractError<X> fromJson(int flags, String errorJson) {
        return (ContractError)ABIJSON.parseABIObject(errorJson, ABIJSON.ERRORS, null, flags);
    }

    public static <X extends Tuple> ContractError<X> fromJson(int flags, InputStream jsonStream) {
        return (ContractError)ABIJSON.parseABIObject(jsonStream, ABIJSON.ERRORS, null, flags);
    }
}

