/*
 * Decompiled with CFR 0.152.
 */
package com.esaulpaugh.headlong.abi;

import com.esaulpaugh.headlong.abi.ABIType;
import com.esaulpaugh.headlong.abi.AddressType;
import com.esaulpaugh.headlong.abi.ArrayType;
import com.esaulpaugh.headlong.abi.BigDecimalType;
import com.esaulpaugh.headlong.abi.BigIntegerType;
import com.esaulpaugh.headlong.abi.BooleanType;
import com.esaulpaugh.headlong.abi.ByteType;
import com.esaulpaugh.headlong.abi.CharSequenceView;
import com.esaulpaugh.headlong.abi.IntType;
import com.esaulpaugh.headlong.abi.LongType;
import com.esaulpaugh.headlong.util.Integers;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;

public abstract class UnitType<J>
extends ABIType<J> {
    private static final long INSTANCE_LIMIT = 69L;
    private static final AtomicLong INSTANCE_COUNT = new AtomicLong(0L);
    static final int UNIT_LENGTH_BITS = 256;
    public static final int UNIT_LENGTH_BYTES = 32;
    private final long minLong;
    private final long maxLong;
    private final BigInteger min;
    private final BigInteger max;
    final int bitLength;
    final boolean unsigned;
    private static final Map<CharSequenceView, ABIType<?>> BASE_TYPE_MAP = new HashMap(256);
    private static final Map<CharSequenceView, ABIType<?>> LEGACY_BASE_TYPE_MAP = new HashMap(256);
    private static final AtomicBoolean MAP_INITIALIZED = new AtomicBoolean(false);

    UnitType(String canonicalType, Class<J> clazz, int bitLength, boolean unsigned) {
        super(canonicalType, clazz, false);
        if (!(this instanceof BigDecimalType)) {
            if (INSTANCE_COUNT.incrementAndGet() > 69L) {
                INSTANCE_COUNT.decrementAndGet();
                throw new IllegalStateException("instance not permitted");
            }
        } else if (bitLength > 256) {
            bitLength = 256;
        } else if (bitLength < 8 || Integers.mod(bitLength, 8) != 0) {
            throw new IllegalStateException("bit length not permitted");
        }
        this.bitLength = bitLength;
        this.unsigned = unsigned;
        this.min = this.minValue();
        this.max = this.maxValue();
        this.minLong = this.min.longValue();
        this.maxLong = this.max.longValue();
    }

    public final int getBitLength() {
        return this.bitLength;
    }

    public final boolean isUnsigned() {
        return this.unsigned;
    }

    public final BigInteger minValue() {
        return this.unsigned ? BigInteger.ZERO : BigInteger.ONE.shiftLeft(this.bitLength - 1).negate();
    }

    public final BigInteger maxValue() {
        return BigInteger.ONE.shiftLeft(this.unsigned ? this.bitLength : this.bitLength - 1).subtract(BigInteger.ONE);
    }

    @Override
    int headLength() {
        return 32;
    }

    @Override
    int byteLength(J value) {
        return 32;
    }

    @Override
    int byteLengthPacked(J value) {
        return this.bitLength / 8;
    }

    @Override
    public final int validate(J value) {
        this.validateClass(value);
        return this.validateInternal(value);
    }

    int validateInternal(J value) {
        return this.validatePrimitive(UnitType.toLong(value));
    }

    @Override
    void encodeTail(J value, ByteBuffer dest) {
        UnitType.insertInt(UnitType.toLong(value), dest);
    }

    @Override
    void encodePackedUnchecked(J value, ByteBuffer dest) {
        LongType.encodeLong(UnitType.toLong(value), this.byteLengthPacked(null), dest);
    }

    private static long toLong(Object value) {
        return ((Number)value).longValue();
    }

    final long decodeUnsignedLong(ByteBuffer bb) {
        long d;
        long c;
        long b;
        long a = bb.getLong();
        if ((a | (b = bb.getLong()) | (c = bb.getLong()) | (d = bb.getLong()) & -1L << this.bitLength) == 0L) {
            return d;
        }
        throw this.err(bb);
    }

    final long decodeSignedLong(ByteBuffer bb) {
        long a = bb.getLong();
        long b = bb.getLong();
        long c = bb.getLong();
        long d = bb.getLong();
        if ((a | b | c) == 0L ? Long.numberOfLeadingZeros(d) - (64 - this.bitLength) > 0 : (a & b & c) == -1L && Long.numberOfLeadingZeros(d ^ 0xFFFFFFFFFFFFFFFFL) - (64 - this.bitLength) > 0) {
            return d;
        }
        throw this.err(bb);
    }

    final IllegalArgumentException err(ByteBuffer bb) {
        bb.position(bb.position() - 32);
        this.decodeValid(bb, ABIType.newUnitBuffer());
        throw new AssertionError();
    }

    final int validatePrimitive(long longVal) {
        if (longVal < this.minLong) {
            throw this.negative(Integers.bitLen(longVal ^ 0xFFFFFFFFFFFFFFFFL));
        }
        if (longVal > this.maxLong) {
            throw this.nonNegative(Integers.bitLen(longVal));
        }
        return 32;
    }

    final int validateBigInt(BigInteger bigIntVal) {
        if (bigIntVal.compareTo(this.min) < 0) {
            throw this.negative(bigIntVal.bitLength());
        }
        if (bigIntVal.compareTo(this.max) > 0) {
            throw this.nonNegative(bigIntVal.bitLength());
        }
        return 32;
    }

    private IllegalArgumentException negative(int actual) {
        if (this.unsigned) {
            return new IllegalArgumentException("signed value given for unsigned type");
        }
        if (actual >= this.bitLength) {
            return new IllegalArgumentException("signed val exceeds bit limit: " + actual + " >= " + this.bitLength);
        }
        throw new AssertionError();
    }

    private IllegalArgumentException nonNegative(int actual) {
        if (this.unsigned) {
            if (actual > this.bitLength) {
                return new IllegalArgumentException("unsigned val exceeds bit limit: " + actual + " > " + this.bitLength);
            }
        } else if (actual >= this.bitLength) {
            return new IllegalArgumentException("signed val exceeds bit limit: " + actual + " >= " + this.bitLength);
        }
        throw new AssertionError();
    }

    final BigInteger decodeValid(ByteBuffer bb, byte[] unitBuffer) {
        bb.get(unitBuffer, 0, 32);
        BigInteger bi = this.unsigned ? new BigInteger(1, unitBuffer) : new BigInteger(unitBuffer);
        this.validateBigInt(bi);
        return bi;
    }

    static ABIType<?> get(String rawType) {
        return UnitType.get(new CharSequenceView(rawType));
    }

    static ABIType<?> getLegacy(String rawType) {
        return UnitType.getLegacy(new CharSequenceView(rawType));
    }

    static ABIType<?> get(CharSequenceView view) {
        return BASE_TYPE_MAP.get(view);
    }

    static ABIType<?> getLegacy(CharSequenceView slice) {
        return LEGACY_BASE_TYPE_MAP.get(slice);
    }

    static void initInstances() {
        if (MAP_INITIALIZED.compareAndSet(false, true)) {
            int n;
            UnitType.map("bool", BooleanType.INSTANCE);
            UnitType.map("string", new ArrayType("string", ArrayType.STRING_CLASS, ByteType.INSTANCE, -1, ArrayType.STRING_ARRAY_CLASS, 0));
            for (n = 1; n <= 32; ++n) {
                UnitType.mapByteArray("bytes" + n, n);
            }
            UnitType.mapByteArray("function", 24);
            UnitType.mapByteArray("bytes", -1);
            for (n = 8; n <= 24; n += 8) {
                UnitType.mapInt("uint" + n, n, true);
            }
            for (n = 32; n <= 56; n += 8) {
                UnitType.mapLong("uint" + n, n, true);
            }
            for (n = 64; n <= 256; n += 8) {
                UnitType.mapBigInteger("uint" + n, n, true);
            }
            UnitType.map("uint", UnitType.get("uint256"));
            UnitType.mapBigInteger("int256", 256, false);
            UnitType.map("int", UnitType.get("int256"));
            for (n = 8; n <= 32; n += 8) {
                UnitType.mapInt("int" + n, n, false);
            }
            for (n = 40; n <= 64; n += 8) {
                UnitType.mapLong("int" + n, n, false);
            }
            for (n = 72; n < 256; n += 8) {
                UnitType.mapBigInteger("int" + n, n, false);
            }
            UnitType.map("address", AddressType.INSTANCE);
            UnitType.map("fixed128x18", new BigDecimalType("fixed128x18", 128, 18, false));
            UnitType.map("ufixed128x18", new BigDecimalType("ufixed128x18", 128, 18, true));
            UnitType.map("decimal", UnitType.get("int168"));
            UnitType.map("fixed", UnitType.get("fixed128x18"));
            UnitType.map("ufixed", UnitType.get("ufixed128x18"));
            for (Map.Entry<CharSequenceView, ABIType<?>> e : BASE_TYPE_MAP.entrySet()) {
                ABIType<?> value = e.getValue();
                if (value instanceof ArrayType) {
                    ArrayType at = value.asArrayType();
                    value = new ArrayType(at.canonicalType, at.clazz, ByteType.INSTANCE, at.getLength(), at.arrayClass(), 1);
                }
                LEGACY_BASE_TYPE_MAP.put(e.getKey(), value);
            }
        }
    }

    private static void map(String key, ABIType<?> value) {
        BASE_TYPE_MAP.put(new CharSequenceView(key), value);
    }

    private static void mapInt(String type, int bitLen, boolean unsigned) {
        UnitType.map(type, new IntType(type, bitLen, unsigned));
    }

    private static void mapLong(String type, int bitLen, boolean unsigned) {
        UnitType.map(type, new LongType(type, bitLen, unsigned));
    }

    private static void mapBigInteger(String type, int bitLen, boolean unsigned) {
        UnitType.map(type, new BigIntegerType(type, bitLen, unsigned));
    }

    private static void mapByteArray(String type, int arrayLen) {
        UnitType.map(type, new ArrayType(type, byte[].class, ByteType.INSTANCE, arrayLen, byte[][].class, 0));
    }
}

