/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.addressbook.impl;

import com.hedera.hapi.node.base.ServiceEndpoint;
import com.hedera.hapi.node.state.addressbook.Node;
import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.roster.Roster;
import com.hedera.hapi.node.state.roster.RosterEntry;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.addressbook.ReadableNodeStore;
import com.hedera.node.app.service.addressbook.impl.schemas.V053AddressBookSchema;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.swirlds.state.spi.ReadableKVState;
import com.swirlds.state.spi.ReadableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.LongUnaryOperator;

public class ReadableNodeStoreImpl
implements ReadableNodeStore {
    private final ReadableKVState<EntityNumber, Node> nodesState;
    private final ReadableEntityCounters entityCounters;

    public ReadableNodeStoreImpl(@NonNull ReadableStates states, @NonNull ReadableEntityCounters entityCounters) {
        Objects.requireNonNull(states);
        this.entityCounters = Objects.requireNonNull(entityCounters);
        this.nodesState = states.get(V053AddressBookSchema.NODES_STATE_ID);
    }

    public Roster snapshotOfFutureRoster(@NonNull LongUnaryOperator weightFunction) {
        Objects.requireNonNull(weightFunction);
        return this.constructFromNodesStateWithStakingInfoWeight(this, weightFunction);
    }

    @Nullable
    public Node get(long nodeId) {
        return (Node)this.nodesState.get((Object)EntityNumber.newBuilder().number(nodeId).build());
    }

    public long sizeOfState() {
        return this.entityCounters.getCounterFor(EntityType.NODE);
    }

    protected <T extends ReadableKVState<EntityNumber, Node>> T nodesState() {
        return (T)this.nodesState;
    }

    @NonNull
    public List<EntityNumber> keys() {
        long size = this.sizeOfState();
        ArrayList<EntityNumber> keys = new ArrayList<EntityNumber>();
        int i = 0;
        while ((long)i < size) {
            EntityNumber key = new EntityNumber((long)i);
            Node node = (Node)this.nodesState.get((Object)key);
            if (node != null) {
                keys.add(key);
            }
            ++i;
        }
        return keys;
    }

    private Roster constructFromNodesStateWithStakingInfoWeight(@NonNull ReadableNodeStoreImpl nodeStore, @NonNull LongUnaryOperator weightFunction) {
        ArrayList<RosterEntry> rosterEntries = new ArrayList<RosterEntry>();
        for (EntityNumber nodeNumber : nodeStore.keys()) {
            Node node = Objects.requireNonNull(nodeStore.get(nodeNumber.number()));
            List<ServiceEndpoint> nodeEndpoints = node.gossipEndpoint();
            if (nodeEndpoints.size() > 1) {
                nodeEndpoints = List.of((ServiceEndpoint)nodeEndpoints.getLast(), (ServiceEndpoint)nodeEndpoints.getFirst());
            }
            if (node.deleted()) continue;
            RosterEntry entry = RosterEntry.newBuilder().nodeId(node.nodeId()).weight(weightFunction.applyAsLong(node.nodeId())).gossipCaCertificate(node.gossipCaCertificate()).gossipEndpoint(nodeEndpoints).build();
            rosterEntries.add(entry);
        }
        rosterEntries.sort(Comparator.comparingLong(RosterEntry::nodeId));
        return Roster.newBuilder().rosterEntries(rosterEntries).build();
    }
}

