/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.operations.AbstractCustomCreateOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomizedOpcodes;
import com.hedera.node.app.service.contract.impl.state.ProxyWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.code.CodeV0;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.operation.CreateOperation;

public class CustomCreateOperation
extends AbstractCustomCreateOperation {
    public CustomCreateOperation(@NonNull GasCalculator gasCalculator, @NonNull CodeFactory codeFactory) {
        super(CustomizedOpcodes.CREATE.opcode(), "\u0127CREATE", 3, 1, gasCalculator, codeFactory);
    }

    @Override
    protected boolean isEnabled(@NonNull MessageFrame frame) {
        return true;
    }

    @Override
    protected void onSuccess(@NonNull MessageFrame frame, @NonNull Address createdAddress) {
    }

    @Override
    protected long cost(@NonNull MessageFrame frame) {
        return new CreateOperation(this.gasCalculator()).cost(frame, () -> CodeV0.EMPTY_CODE);
    }

    @Override
    @NonNull
    protected Address setupPendingCreation(@NonNull MessageFrame frame) {
        ProxyWorldUpdater updater = (ProxyWorldUpdater)frame.getWorldUpdater();
        Address origin = this.getSenderAddress(frame);
        long originNonce = Objects.requireNonNull(updater.getAccount(origin)).getNonce();
        Address address = Address.contractAddress((Address)origin, (long)(originNonce - 1L));
        updater.setupInternalAliasedCreate(origin, address);
        frame.warmUpAddress(address);
        return address;
    }
}

