/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.history.impl;

import com.hedera.hapi.block.stream.ChainOfTrustProof;
import com.hedera.hapi.block.stream.NodeSignature;
import com.hedera.hapi.block.stream.NodeSignatures;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.state.history.History;
import com.hedera.hapi.node.state.history.HistoryProof;
import com.hedera.hapi.node.state.history.HistoryProofConstruction;
import com.hedera.hapi.node.state.history.HistoryProofVote;
import com.hedera.hapi.node.state.history.HistorySignature;
import com.hedera.hapi.node.state.history.ProofKey;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.node.app.history.HistoryLibrary;
import com.hedera.node.app.history.HistoryService;
import com.hedera.node.app.history.ReadableHistoryStore;
import com.hedera.node.app.history.WritableHistoryStore;
import com.hedera.node.app.history.impl.HistorySubmissions;
import com.hedera.node.app.history.impl.ProofController;
import com.hedera.node.app.history.impl.ProofKeysAccessorImpl;
import com.hedera.node.app.service.roster.impl.RosterTransitionWeights;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ProofControllerImpl
implements ProofController {
    private static final Logger log = LogManager.getLogger(ProofControllerImpl.class);
    private static final Comparator<ProofKey> PROOF_KEY_COMPARATOR = Comparator.comparingLong(ProofKey::nodeId);
    private static final int INSUFFICIENT_SIGNATURES_CHECK_RETRY_SECS = 10;
    private static final String INSUFFICIENT_SIGNATURES_FAILURE_REASON = "insufficient signatures";
    public static final Bytes EMPTY_PUBLIC_KEY = Bytes.wrap((byte[])new byte[32]);
    @Nullable
    private static CompletableFuture<Void> RUNNING_PROOF_FUTURE = null;
    public static final String PROOF_COMPLETE_MSG = "History proof constructed";
    private final long selfId;
    @Nullable
    private final Bytes ledgerId;
    private final boolean wrapsEnabled;
    private final Executor executor;
    private final ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair;
    private final HistoryLibrary library;
    private final HistoryService historyService;
    private final HistorySubmissions submissions;
    private final RosterTransitionWeights weights;
    private final Map<Long, HistoryProofVote> votes = new TreeMap<Long, HistoryProofVote>();
    private final Map<Long, Bytes> targetProofKeys = new TreeMap<Long, Bytes>();
    private final Set<Long> signingNodeIds = new HashSet<Long>();
    private final NavigableMap<Instant, CompletableFuture<Verification>> verificationFutures = new TreeMap<Instant, CompletableFuture<Verification>>();
    @Nullable
    private Bytes targetMetadata;
    private HistoryProofConstruction construction;
    @Nullable
    private CompletableFuture<Void> publicationFuture;
    @Nullable
    private CompletableFuture<Void> signingFuture;
    @Nullable
    private CompletableFuture<Void> proofFuture;

    public ProofControllerImpl(long selfId, boolean wrapsEnabled, @NonNull ProofKeysAccessorImpl.SchnorrKeyPair schnorrKeyPair, @Nullable Bytes ledgerId, @NonNull HistoryProofConstruction construction, @NonNull RosterTransitionWeights weights, @NonNull Executor executor, @NonNull HistoryLibrary library, @NonNull HistorySubmissions submissions, @NonNull List<ReadableHistoryStore.ProofKeyPublication> keyPublications, @NonNull List<ReadableHistoryStore.HistorySignaturePublication> signaturePublications, @NonNull Map<Long, HistoryProofVote> votes, @NonNull HistoryService historyService) {
        this.selfId = selfId;
        this.wrapsEnabled = wrapsEnabled;
        this.ledgerId = ledgerId;
        this.executor = Objects.requireNonNull(executor);
        this.library = Objects.requireNonNull(library);
        this.submissions = Objects.requireNonNull(submissions);
        this.weights = Objects.requireNonNull(weights);
        this.construction = Objects.requireNonNull(construction);
        this.historyService = Objects.requireNonNull(historyService);
        this.schnorrKeyPair = Objects.requireNonNull(schnorrKeyPair);
        this.votes.putAll(Objects.requireNonNull(votes));
        if (!construction.hasTargetProof()) {
            Instant cutoffTime = construction.hasGracePeriodEndTime() ? HapiUtils.asInstant((Timestamp)construction.gracePeriodEndTimeOrThrow()) : Instant.MAX;
            keyPublications.forEach(publication -> {
                if (!publication.adoptionTime().isAfter(cutoffTime)) {
                    this.maybeUpdateForProofKey((ReadableHistoryStore.ProofKeyPublication)publication);
                }
            });
            signaturePublications.forEach(this::addSignaturePublication);
        }
    }

    @Override
    public long constructionId() {
        return this.construction.constructionId();
    }

    @Override
    public boolean isStillInProgress() {
        return !this.construction.hasTargetProof() && !this.construction.hasFailureReason();
    }

    @Override
    public void advanceConstruction(@NonNull Instant now, @Nullable Bytes metadata, @NonNull WritableHistoryStore historyStore, boolean isActive) {
        if (this.construction.hasTargetProof() || this.construction.hasFailureReason()) {
            return;
        }
        this.targetMetadata = metadata;
        if (this.targetMetadata == null) {
            if (isActive) {
                this.ensureProofKeyPublished();
            }
        } else if (this.construction.hasAssemblyStartTime()) {
            boolean stillCollectingSignatures = true;
            long elapsedSeconds = Math.max(1L, now.getEpochSecond() - this.construction.assemblyStartTimeOrThrow().seconds());
            if (elapsedSeconds % 10L == 0L) {
                stillCollectingSignatures = this.couldStillGetSufficientSignatures();
            }
            if (stillCollectingSignatures && isActive) {
                if (!this.votes.containsKey(this.selfId) && this.proofFuture == null) {
                    if (this.hasSufficientSignatures()) {
                        Signatures choice = Objects.requireNonNull(this.firstSufficientSignatures());
                        TreeMap signatures = this.verificationFutures.headMap(choice.cutoff(), true).values().stream().map(CompletableFuture::join).filter(v -> choice.history().equals((Object)v.history()) && v.isValid()).collect(Collectors.toMap(Verification::nodeId, v -> v.historySignature().signature(), (a, b) -> a, TreeMap::new));
                        if (this.ledgerId != null && this.wrapsEnabled) {
                            if (RUNNING_PROOF_FUTURE != null && !RUNNING_PROOF_FUTURE.isDone()) {
                                log.warn("Proof future for construction #{} must wait until previous finished", (Object)this.construction.constructionId());
                            }
                            this.proofFuture = Optional.ofNullable(RUNNING_PROOF_FUTURE).orElse(CompletableFuture.completedFuture(null)).thenCompose(ignore -> this.startRecursiveProofFuture(signatures));
                            log.info("Created proof future for construction #{}", (Object)this.construction.constructionId());
                        } else {
                            ChainOfTrustProof chainOfTrustProof = ChainOfTrustProof.newBuilder().nodeSignatures(new NodeSignatures(signatures.entrySet().stream().map(e -> new NodeSignature(((Long)e.getKey()).longValue(), (Bytes)e.getValue())).toList())).build();
                            Bytes targetHash = HistoryLibrary.computeHash(this.library, this.weights.targetNodeIds(), arg_0 -> ((RosterTransitionWeights)this.weights).targetWeightOf(arg_0), id -> this.targetProofKeys.getOrDefault(id, EMPTY_PUBLIC_KEY));
                            HistoryProof proof = HistoryProof.newBuilder().targetProofKeys(ProofControllerImpl.proofKeyListFrom(this.targetProofKeys)).targetHistory(new History(targetHash, Objects.requireNonNull(this.targetMetadata))).chainOfTrustProof(chainOfTrustProof).build();
                            this.finishProof(historyStore, proof);
                        }
                    } else if (!this.signingNodeIds.contains(this.selfId) && this.signingFuture == null) {
                        this.signingFuture = this.startSigningFuture();
                        log.info("Started signing future for construction #{}", (Object)this.construction.constructionId());
                    }
                }
            } else if (!stillCollectingSignatures) {
                log.info("Failed construction #{} due to {}", (Object)this.construction.constructionId(), (Object)INSUFFICIENT_SIGNATURES_FAILURE_REASON);
                this.construction = historyStore.failForReason(this.construction.constructionId(), INSUFFICIENT_SIGNATURES_FAILURE_REASON);
            }
        } else if (this.shouldAssemble(now)) {
            log.info("Assembly start time for construction #{} is {}", (Object)this.construction.constructionId(), (Object)now);
            this.construction = historyStore.setAssemblyTime(this.construction.constructionId(), now);
            if (isActive) {
                this.signingFuture = this.startSigningFuture();
            }
        } else if (isActive) {
            this.ensureProofKeyPublished();
        }
    }

    @Override
    public void addProofKeyPublication(@NonNull ReadableHistoryStore.ProofKeyPublication publication) {
        Objects.requireNonNull(publication);
        if (!this.construction.hasGracePeriodEndTime()) {
            return;
        }
        this.maybeUpdateForProofKey(publication);
    }

    @Override
    public boolean addSignaturePublication(@NonNull ReadableHistoryStore.HistorySignaturePublication publication) {
        Objects.requireNonNull(publication);
        long nodeId = publication.nodeId();
        if (!this.construction.hasTargetProof() && this.targetProofKeys.containsKey(nodeId) && !this.signingNodeIds.contains(nodeId)) {
            this.verificationFutures.put(publication.at(), this.verificationFuture(publication.nodeId(), publication.signature()));
            this.signingNodeIds.add(publication.nodeId());
            return true;
        }
        return false;
    }

    @Override
    public void addProofVote(long nodeId, @NonNull HistoryProofVote vote, @NonNull WritableHistoryStore historyStore) {
        HistoryProofVote congruentVote;
        Objects.requireNonNull(vote);
        Objects.requireNonNull(historyStore);
        if (this.construction.hasTargetProof() || this.votes.containsKey(nodeId)) {
            return;
        }
        if (vote.hasProof()) {
            this.votes.put(nodeId, vote);
        } else if (vote.hasCongruentNodeId() && (congruentVote = this.votes.get(vote.congruentNodeIdOrThrow())) != null && congruentVote.hasProof()) {
            this.votes.put(nodeId, congruentVote);
        }
        historyStore.addProofVote(nodeId, this.construction.constructionId(), vote);
        Map<HistoryProof, Long> proofWeights = this.votes.entrySet().stream().collect(Collectors.groupingBy(entry -> ((HistoryProofVote)entry.getValue()).proofOrThrow(), Collectors.summingLong(entry -> this.weights.sourceWeightOf(((Long)entry.getKey()).longValue()))));
        Optional<HistoryProof> maybeWinningProof = proofWeights.entrySet().stream().filter(entry -> (Long)entry.getValue() >= this.weights.sourceWeightThreshold()).map(Map.Entry::getKey).findFirst();
        maybeWinningProof.ifPresent(proof -> this.finishProof(historyStore, (HistoryProof)proof));
    }

    @Override
    public void cancelPendingWork() {
        StringBuilder sb = new StringBuilder("Canceled work on proof construction #").append(this.construction.constructionId());
        boolean canceledSomething = false;
        if (this.publicationFuture != null && !this.publicationFuture.isDone()) {
            sb.append("\n  * In-flight publication");
            this.publicationFuture.cancel(true);
            canceledSomething = true;
        }
        if (this.signingFuture != null && !this.signingFuture.isDone()) {
            sb.append("\n  * In-flight signing");
            this.signingFuture.cancel(true);
            canceledSomething = true;
        }
        if (this.proofFuture != null && !this.proofFuture.isDone()) {
            sb.append("\n  * In-flight proof");
            this.proofFuture.cancel(true);
            canceledSomething = true;
        }
        AtomicInteger numCancelledVerifications = new AtomicInteger();
        this.verificationFutures.values().forEach(future -> {
            if (!future.isDone()) {
                numCancelledVerifications.incrementAndGet();
                future.cancel(true);
            }
        });
        if (numCancelledVerifications.get() > 0) {
            sb.append("\n  * ").append(numCancelledVerifications.get()).append(" in-flight verifications");
            canceledSomething = true;
        }
        if (canceledSomething) {
            log.info(sb.toString());
        }
    }

    public static Map<Long, Bytes> proofKeyMapFrom(@NonNull HistoryProof proof) {
        Objects.requireNonNull(proof);
        return proof.targetProofKeys().stream().collect(Collectors.toMap(ProofKey::nodeId, ProofKey::key));
    }

    private void finishProof(@NonNull WritableHistoryStore historyStore, @NonNull HistoryProof proof) {
        this.construction = historyStore.completeProof(this.construction.constructionId(), proof);
        log.info("{} (#{})", (Object)PROOF_COMPLETE_MSG, (Object)this.construction.constructionId());
        this.historyService.onFinished(historyStore, this.construction);
    }

    private boolean shouldAssemble(@NonNull Instant now) {
        if (this.targetProofKeys.size() == this.weights.numTargetNodesInSource()) {
            log.info("All target nodes have published proof keys for construction #{}", (Object)this.construction.constructionId());
            return true;
        }
        if (now.isBefore(HapiUtils.asInstant((Timestamp)this.construction.gracePeriodEndTimeOrThrow()))) {
            return false;
        }
        return this.publishedWeight() >= this.weights.targetWeightThreshold();
    }

    private void ensureProofKeyPublished() {
        if (this.publicationFuture == null && this.weights.targetIncludes(this.selfId) && !this.targetProofKeys.containsKey(this.selfId)) {
            log.info("Publishing Schnorr key for construction #{}", (Object)this.construction.constructionId());
            this.publicationFuture = CompletableFuture.runAsync(() -> this.submissions.submitProofKeyPublication(this.schnorrKeyPair.publicKey()).join(), this.executor).exceptionally(e -> {
                log.error("Error publishing proof key", e);
                return null;
            });
        }
    }

    private void maybeUpdateForProofKey(@NonNull ReadableHistoryStore.ProofKeyPublication publication) {
        long nodeId = publication.nodeId();
        if (!this.weights.targetIncludes(nodeId)) {
            return;
        }
        this.targetProofKeys.put(nodeId, publication.proofKey());
    }

    private CompletableFuture<Void> startSigningFuture() {
        Objects.requireNonNull(this.targetMetadata);
        Map<Long, Bytes> proofKeys = Map.copyOf(this.targetProofKeys);
        return CompletableFuture.runAsync(() -> {
            Bytes targetHash = HistoryLibrary.computeHash(this.library, this.weights.targetNodeWeights().keySet(), arg_0 -> ((RosterTransitionWeights)this.weights).targetWeightOf(arg_0), id -> proofKeys.getOrDefault(id, EMPTY_PUBLIC_KEY));
            History history = new History(targetHash, this.targetMetadata);
            Bytes message = this.encodeHistoryForSigning(history);
            Bytes signature = this.library.signSchnorr(message, this.schnorrKeyPair.privateKey());
            HistorySignature historySignature = new HistorySignature(history, signature);
            this.submissions.submitAssemblySignature(this.construction.constructionId(), historySignature).join();
        }, this.executor).exceptionally(e -> {
            log.error("Error submitting signature", e);
            return null;
        });
    }

    private CompletableFuture<Void> startRecursiveProofFuture(@NonNull TreeMap<Long, Bytes> signatures) {
        Bytes ledgerId = Objects.requireNonNull(this.ledgerId);
        Bytes targetMetadata = Objects.requireNonNull(this.targetMetadata);
        Bytes sourceProof = this.construction.sourceProofOrThrow().chainOfTrustProofOrThrow().wrapsProofOrThrow();
        Map<Long, Bytes> sourceProofKeys = ProofControllerImpl.proofKeyMapFrom(this.construction.sourceProofOrThrow());
        long[] sourceNodeIds = this.weights.sourceNodeWeights().keySet().stream().mapToLong(Long::longValue).toArray();
        long[] targetNodeIds = this.weights.targetNodeWeights().keySet().stream().mapToLong(Long::longValue).toArray();
        long[] sourceWeights = Arrays.stream(sourceNodeIds).map(arg_0 -> ((RosterTransitionWeights)this.weights).sourceWeightOf(arg_0)).toArray();
        long[] targetWeights = Arrays.stream(targetNodeIds).map(arg_0 -> ((RosterTransitionWeights)this.weights).targetWeightOf(arg_0)).toArray();
        byte[][] sourceProofKeysArray = (byte[][])Arrays.stream(sourceNodeIds).mapToObj(id -> sourceProofKeys.getOrDefault(id, EMPTY_PUBLIC_KEY).toByteArray()).toArray(x$0 -> new byte[x$0][]);
        byte[][] targetProofKeysArray = (byte[][])Arrays.stream(targetNodeIds).mapToObj(id -> this.targetProofKeys.getOrDefault(id, EMPTY_PUBLIC_KEY).toByteArray()).toArray(x$0 -> new byte[x$0][]);
        long inProgressId = this.construction.constructionId();
        List<ProofKey> proofKeyList = ProofControllerImpl.proofKeyListFrom(this.targetProofKeys);
        RUNNING_PROOF_FUTURE = CompletableFuture.runAsync(() -> {
            Bytes targetHash = this.library.hashAddressBook(targetWeights, targetProofKeysArray);
            byte[][] verifyingSignatures = (byte[][])this.weights.sourceNodeWeights().keySet().stream().map(i -> Optional.ofNullable((Bytes)signatures.get(i)).map(Bytes::toByteArray).orElse(null)).toArray(x$0 -> new byte[x$0][]);
            log.info("Starting recursive chain-of-trust proof for construction #{}", (Object)inProgressId);
            Bytes targetMetadataHash = this.library.hashHintsVerificationKey(targetMetadata);
            Bytes proof = this.library.proveChainOfTrust(ledgerId, sourceProof, sourceWeights, sourceProofKeysArray, targetWeights, targetProofKeysArray, verifyingSignatures, targetMetadataHash);
            log.info("Finished recursive chain-of-trust proof for construction #{}", (Object)inProgressId);
            ChainOfTrustProof chainOfTrustProof = ChainOfTrustProof.newBuilder().wrapsProof(proof).build();
            HistoryProof metadataProof = HistoryProof.newBuilder().targetProofKeys(proofKeyList).targetHistory(new History(targetHash, targetMetadata)).chainOfTrustProof(chainOfTrustProof).build();
            this.submissions.submitProofVote(inProgressId, metadataProof).join();
        }, this.executor).exceptionally(e -> {
            log.error("Error submitting proof vote", e);
            return null;
        });
        return RUNNING_PROOF_FUTURE;
    }

    private boolean hasSufficientSignatures() {
        return this.firstSufficientSignatures() != null;
    }

    private boolean couldStillGetSufficientSignatures() {
        HashMap<History, Long> historyWeights = new HashMap<History, Long>();
        long invalidWeight = 0L;
        long maxValidWeight = 0L;
        for (Map.Entry entry : this.verificationFutures.entrySet()) {
            Verification verification = (Verification)((CompletableFuture)entry.getValue()).join();
            if (verification.isValid()) {
                maxValidWeight = Math.max(maxValidWeight, historyWeights.merge(verification.history(), this.weights.sourceWeightOf(verification.nodeId()), Long::sum));
                continue;
            }
            invalidWeight += this.weights.sourceWeightOf(verification.nodeId());
        }
        long unassignedWeight = this.weights.totalSourceWeight() - invalidWeight - historyWeights.values().stream().mapToLong(Long::longValue).sum();
        return maxValidWeight + unassignedWeight >= this.weights.sourceWeightThreshold();
    }

    @Nullable
    private Signatures firstSufficientSignatures() {
        HashMap<History, Long> historyWeights = new HashMap<History, Long>();
        for (Map.Entry entry : this.verificationFutures.entrySet()) {
            long weight;
            Verification verification = (Verification)((CompletableFuture)entry.getValue()).join();
            if (!verification.isValid() || (weight = historyWeights.merge(verification.history(), this.weights.sourceWeightOf(verification.nodeId()), Long::sum).longValue()) < this.weights.sourceWeightThreshold()) continue;
            return new Signatures(verification.history(), (Instant)entry.getKey());
        }
        return null;
    }

    private long publishedWeight() {
        return this.targetProofKeys.keySet().stream().mapToLong(arg_0 -> ((RosterTransitionWeights)this.weights).targetWeightOf(arg_0)).sum();
    }

    private static List<ProofKey> proofKeyListFrom(@NonNull Map<Long, Bytes> proofKeys) {
        return proofKeys.entrySet().stream().map(entry -> new ProofKey(((Long)entry.getKey()).longValue(), (Bytes)entry.getValue())).sorted(PROOF_KEY_COMPARATOR).toList();
    }

    private CompletableFuture<Verification> verificationFuture(long nodeId, @NonNull HistorySignature historySignature) {
        return CompletableFuture.supplyAsync(() -> {
            Bytes message = this.encodeHistoryForSigning(historySignature.historyOrThrow());
            Bytes proofKey = Objects.requireNonNull(this.targetProofKeys.get(nodeId));
            boolean isValid = this.library.verifySchnorr(historySignature.signature(), message, proofKey);
            return new Verification(nodeId, historySignature, isValid);
        }, this.executor).exceptionally(e -> {
            log.error("Error verifying signature", e);
            return new Verification(nodeId, historySignature, false);
        });
    }

    @NonNull
    private Bytes encodeHistoryForSigning(@NonNull History history) {
        Objects.requireNonNull(history);
        return this.concat(history.addressBookHash(), this.library.hashHintsVerificationKey(history.metadata()));
    }

    @NonNull
    private Bytes concat(@NonNull Bytes a, @NonNull Bytes b) {
        ByteBuffer c = ByteBuffer.wrap(new byte[(int)a.length() + (int)b.length()]);
        a.writeTo(c);
        b.writeTo(c);
        return Bytes.wrap((byte[])c.array());
    }

    private record Signatures(@NonNull History history, @NonNull Instant cutoff) {
    }

    private record Verification(long nodeId, @NonNull HistorySignature historySignature, boolean isValid) {
        @NonNull
        public History history() {
            return this.historySignature.historyOrThrow();
        }
    }
}

