/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.quiescence;

import com.hedera.node.app.quiescence.QuiescenceUtils;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.model.transaction.Transaction;

@Singleton
public class TxPipelineTracker {
    private final AtomicInteger preFlightCount = new AtomicInteger();
    private final AtomicInteger inFlightCount = new AtomicInteger();

    @Inject
    public TxPipelineTracker() {
    }

    public int estimateTxPipelineCount() {
        return this.preFlightCount.get() + this.inFlightCount.get();
    }

    public void incrementPreFlight() {
        this.preFlightCount.incrementAndGet();
    }

    public void decrementPreFlight() {
        this.preFlightCount.decrementAndGet();
    }

    public void incrementInFlight() {
        this.inFlightCount.incrementAndGet();
    }

    public void countLanded(@NonNull Iterator<Transaction> iter) {
        Objects.requireNonNull(iter);
        while (iter.hasNext()) {
            PreHandleResult preHandleResult;
            TransactionInfo txInfo;
            Transaction tx = iter.next();
            Object object = tx.getMetadata();
            if (!(object instanceof PreHandleResult) || (txInfo = (preHandleResult = (PreHandleResult)object).txInfo()) == null || !QuiescenceUtils.isRelevantTransaction(txInfo.txBody())) continue;
            this.inFlightCount.accumulateAndGet(-1, (prev, next) -> Math.max(0, prev + next));
        }
    }
}

