/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.services;

import com.hedera.hapi.block.stream.output.StateChanges;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.node.app.config.ConfigProviderImpl;
import com.hedera.node.app.metrics.StoreMetricsServiceImpl;
import com.hedera.node.app.services.MigrationStateChanges;
import com.hedera.node.app.services.ServiceMigrator;
import com.hedera.node.app.services.ServicesRegistry;
import com.hedera.node.app.spi.migrate.StartupNetworks;
import com.hedera.node.app.state.merkle.MerkleSchemaRegistry;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.MerkleNodeState;
import com.swirlds.state.State;
import com.swirlds.state.lifecycle.Service;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrderedServiceMigrator
implements ServiceMigrator {
    private static final Logger logger = LogManager.getLogger(OrderedServiceMigrator.class);

    @Override
    public List<StateChanges.Builder> doMigrations(@NonNull MerkleNodeState state, @NonNull ServicesRegistry servicesRegistry, @Nullable SemanticVersion previousVersion, @NonNull SemanticVersion currentVersion, @NonNull Configuration appConfig, @NonNull Configuration platformConfig, @NonNull StartupNetworks startupNetworks, @NonNull StoreMetricsServiceImpl storeMetricsService, @NonNull ConfigProviderImpl configProvider) {
        Objects.requireNonNull(state);
        Objects.requireNonNull(currentVersion);
        Objects.requireNonNull(appConfig);
        Objects.requireNonNull(platformConfig);
        HashMap sharedValues = new HashMap();
        MigrationStateChanges migrationStateChanges = new MigrationStateChanges((State)state, appConfig, storeMetricsService);
        servicesRegistry.registrations().forEach(registration -> {
            Service service = registration.service();
            String serviceName = service.getServiceName();
            logger.info("Migrating Service {}", (Object)serviceName);
            MerkleSchemaRegistry registry = (MerkleSchemaRegistry)registration.registry();
            registry.migrate(state, previousVersion, currentVersion, appConfig, platformConfig, sharedValues, migrationStateChanges, startupNetworks);
        });
        return migrationStateChanges.getStateChanges();
    }
}

