/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshot;
import com.hedera.hapi.node.state.throttles.ThrottleUsageSnapshots;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.ThrottleDefinitions;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.spi.throttle.ScheduleThrottle;
import com.hedera.node.app.throttle.ThrottleAccumulator;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.time.Instant;
import java.util.List;
import java.util.Objects;
import java.util.function.IntSupplier;
import java.util.function.Supplier;

public class AppThrottleFactory
implements ScheduleThrottle.Factory {
    private final Supplier<State> stateSupplier;
    private final Supplier<Configuration> configSupplier;
    private final Supplier<ThrottleDefinitions> definitionsSupplier;
    private final ThrottleAccumulatorFactory throttleAccumulatorFactory;

    public AppThrottleFactory(@NonNull Supplier<Configuration> configSupplier, @NonNull Supplier<State> stateSupplier, @NonNull Supplier<ThrottleDefinitions> definitionsSupplier, @NonNull ThrottleAccumulatorFactory throttleAccumulatorFactory) {
        this.configSupplier = Objects.requireNonNull(configSupplier);
        this.stateSupplier = Objects.requireNonNull(stateSupplier);
        this.definitionsSupplier = Objects.requireNonNull(definitionsSupplier);
        this.throttleAccumulatorFactory = Objects.requireNonNull(throttleAccumulatorFactory);
    }

    public ScheduleThrottle newScheduleThrottle(int capacitySplit, @Nullable ThrottleUsageSnapshots initialUsageSnapshots) {
        final ThrottleAccumulator throttleAccumulator = this.throttleAccumulatorFactory.newThrottleAccumulator(this.configSupplier, () -> capacitySplit, ThrottleAccumulator.ThrottleType.BACKEND_THROTTLE);
        throttleAccumulator.applyGasConfig();
        throttleAccumulator.applyBytesConfig();
        throttleAccumulator.applyDurationConfig();
        throttleAccumulator.rebuildFor(this.definitionsSupplier.get());
        if (initialUsageSnapshots != null) {
            List<DeterministicThrottle> tpsThrottles = throttleAccumulator.allActiveThrottles();
            List tpsUsageSnapshots = initialUsageSnapshots.tpsThrottles();
            int n = tpsThrottles.size();
            for (int i = 0; i < n; ++i) {
                tpsThrottles.get(i).resetUsageTo((ThrottleUsageSnapshot)tpsUsageSnapshots.get(i));
            }
            throttleAccumulator.gasLimitThrottle().resetUsageTo(initialUsageSnapshots.gasThrottleOrThrow());
        }
        return new ScheduleThrottle(){

            public boolean allow(@NonNull AccountID payerId, @NonNull TransactionBody body, @NonNull HederaFunctionality function, @NonNull Instant now) {
                return !throttleAccumulator.checkAndEnforceThrottle(new TransactionInfo(SignedTransaction.DEFAULT, body, TransactionID.DEFAULT, payerId, SignatureMap.DEFAULT, Bytes.EMPTY, function, null), now, AppThrottleFactory.this.stateSupplier.get(), null, true);
            }

            public ThrottleUsageSnapshots usageSnapshots() {
                return new ThrottleUsageSnapshots(throttleAccumulator.allActiveThrottles().stream().map(DeterministicThrottle::usageSnapshot).toList(), throttleAccumulator.gasLimitThrottle().usageSnapshot(), throttleAccumulator.opsDurationThrottle().usageSnapshot());
            }
        };
    }

    public static interface ThrottleAccumulatorFactory {
        public ThrottleAccumulator newThrottleAccumulator(@NonNull Supplier<Configuration> var1, @NonNull IntSupplier var2, @NonNull ThrottleAccumulator.ThrottleType var3);
    }
}

