/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.media.type.spi;

import io.helidon.common.media.type.MediaType;
import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.util.Optional;

public interface MediaTypeDetector {
    default public Optional<MediaType> detectType(URL url) {
        return this.detectType(url.getPath());
    }

    default public Optional<MediaType> detectType(URI uri) {
        return this.detectType(uri.getPath());
    }

    default public Optional<MediaType> detectType(Path file) {
        Path fileName = file.getFileName();
        if (null == fileName) {
            return Optional.empty();
        }
        return this.detectType(fileName.toString());
    }

    default public Optional<MediaType> detectType(String fileString) {
        int index = fileString.lastIndexOf(46);
        String inProgress = fileString;
        if (index <= -1) {
            return Optional.empty();
        }
        inProgress = inProgress.substring(index + 1);
        return this.detectExtensionType(inProgress);
    }

    public Optional<MediaType> detectExtensionType(String var1);
}

