/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.configurable;

import io.helidon.builder.api.Prototype;
import io.helidon.common.Generated;
import io.helidon.common.config.Config;
import io.helidon.common.configurable.AllowList;
import io.helidon.common.configurable.AllowListConfigBlueprint;
import io.helidon.config.ConfigBuilderSupport;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Pattern;

@Generated(value="io.helidon.builder.codegen.BuilderCodegen", trigger="io.helidon.common.configurable.AllowListConfigBlueprint")
public interface AllowListConfig
extends AllowListConfigBlueprint,
Prototype.Api {
    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(AllowListConfig instance) {
        return (Builder)AllowListConfig.builder().from(instance);
    }

    public static AllowListConfig create(io.helidon.config.Config config) {
        return ((Builder)AllowListConfig.builder().config(config)).buildPrototype();
    }

    @Deprecated
    public static AllowListConfig create(Config config) {
        return AllowListConfig.create(io.helidon.config.Config.config((Config)config));
    }

    public static AllowListConfig create() {
        return AllowListConfig.builder().buildPrototype();
    }

    @Override
    public boolean allowAll();

    @Override
    public List<String> allowed();

    @Override
    public List<String> allowedPrefixes();

    @Override
    public List<String> allowedSuffixes();

    @Override
    public List<Pattern> allowedPatterns();

    @Override
    public List<String> denied();

    @Override
    public List<String> deniedPrefixes();

    @Override
    public List<String> deniedSuffixes();

    @Override
    public List<Pattern> deniedPatterns();

    @Override
    public List<Predicate<String>> allowedPredicates();

    @Override
    public List<Predicate<String>> deniedPredicates();

    public static class Builder
    extends BuilderBase<Builder, AllowListConfig>
    implements io.helidon.common.Builder<Builder, AllowList> {
        private Builder() {
        }

        public AllowListConfig buildPrototype() {
            this.preBuildPrototype();
            this.validatePrototype();
            return new BuilderBase.AllowListConfigImpl(this);
        }

        public AllowList build() {
            return AllowList.create(this.buildPrototype());
        }
    }

    public static abstract class BuilderBase<BUILDER extends BuilderBase<BUILDER, PROTOTYPE>, PROTOTYPE extends AllowListConfig>
    implements ConfigBuilderSupport.ConfiguredBuilder<BUILDER, PROTOTYPE> {
        private final List<String> allowed = new ArrayList<String>();
        private final List<String> allowedPrefixes = new ArrayList<String>();
        private final List<String> allowedSuffixes = new ArrayList<String>();
        private final List<String> denied = new ArrayList<String>();
        private final List<String> deniedPrefixes = new ArrayList<String>();
        private final List<String> deniedSuffixes = new ArrayList<String>();
        private final List<Predicate<String>> allowedPredicates = new ArrayList<Predicate<String>>();
        private final List<Predicate<String>> deniedPredicates = new ArrayList<Predicate<String>>();
        private final List<Pattern> allowedPatterns = new ArrayList<Pattern>();
        private final List<Pattern> deniedPatterns = new ArrayList<Pattern>();
        private boolean allowAll = false;
        private boolean isAllowedMutated;
        private boolean isAllowedPatternsMutated;
        private boolean isAllowedPredicatesMutated;
        private boolean isAllowedPrefixesMutated;
        private boolean isAllowedSuffixesMutated;
        private boolean isDeniedMutated;
        private boolean isDeniedPatternsMutated;
        private boolean isDeniedPredicatesMutated;
        private boolean isDeniedPrefixesMutated;
        private boolean isDeniedSuffixesMutated;
        private io.helidon.config.Config config;

        protected BuilderBase() {
        }

        public BUILDER from(AllowListConfig prototype) {
            this.allowAll(prototype.allowAll());
            if (!this.isAllowedMutated) {
                this.allowed.clear();
            }
            this.addAllowed(prototype.allowed());
            if (!this.isAllowedPrefixesMutated) {
                this.allowedPrefixes.clear();
            }
            this.addAllowedPrefixes(prototype.allowedPrefixes());
            if (!this.isAllowedSuffixesMutated) {
                this.allowedSuffixes.clear();
            }
            this.addAllowedSuffixes(prototype.allowedSuffixes());
            if (!this.isAllowedPatternsMutated) {
                this.allowedPatterns.clear();
            }
            this.addAllowedPatterns(prototype.allowedPatterns());
            if (!this.isDeniedMutated) {
                this.denied.clear();
            }
            this.addDenied(prototype.denied());
            if (!this.isDeniedPrefixesMutated) {
                this.deniedPrefixes.clear();
            }
            this.addDeniedPrefixes(prototype.deniedPrefixes());
            if (!this.isDeniedSuffixesMutated) {
                this.deniedSuffixes.clear();
            }
            this.addDeniedSuffixes(prototype.deniedSuffixes());
            if (!this.isDeniedPatternsMutated) {
                this.deniedPatterns.clear();
            }
            this.addDeniedPatterns(prototype.deniedPatterns());
            if (!this.isAllowedPredicatesMutated) {
                this.allowedPredicates.clear();
            }
            this.addAllowedPredicates(prototype.allowedPredicates());
            if (!this.isDeniedPredicatesMutated) {
                this.deniedPredicates.clear();
            }
            this.addDeniedPredicates(prototype.deniedPredicates());
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER from(BuilderBase<?, ?> builder) {
            this.allowAll(builder.allowAll());
            if (this.isAllowedMutated) {
                if (builder.isAllowedMutated) {
                    this.addAllowed(builder.allowed);
                }
            } else {
                this.allowed.clear();
                this.addAllowed(builder.allowed);
            }
            if (this.isAllowedPrefixesMutated) {
                if (builder.isAllowedPrefixesMutated) {
                    this.addAllowedPrefixes(builder.allowedPrefixes);
                }
            } else {
                this.allowedPrefixes.clear();
                this.addAllowedPrefixes(builder.allowedPrefixes);
            }
            if (this.isAllowedSuffixesMutated) {
                if (builder.isAllowedSuffixesMutated) {
                    this.addAllowedSuffixes(builder.allowedSuffixes);
                }
            } else {
                this.allowedSuffixes.clear();
                this.addAllowedSuffixes(builder.allowedSuffixes);
            }
            if (this.isAllowedPatternsMutated) {
                if (builder.isAllowedPatternsMutated) {
                    this.addAllowedPatterns(builder.allowedPatterns);
                }
            } else {
                this.allowedPatterns.clear();
                this.addAllowedPatterns(builder.allowedPatterns);
            }
            if (this.isDeniedMutated) {
                if (builder.isDeniedMutated) {
                    this.addDenied(builder.denied);
                }
            } else {
                this.denied.clear();
                this.addDenied(builder.denied);
            }
            if (this.isDeniedPrefixesMutated) {
                if (builder.isDeniedPrefixesMutated) {
                    this.addDeniedPrefixes(builder.deniedPrefixes);
                }
            } else {
                this.deniedPrefixes.clear();
                this.addDeniedPrefixes(builder.deniedPrefixes);
            }
            if (this.isDeniedSuffixesMutated) {
                if (builder.isDeniedSuffixesMutated) {
                    this.addDeniedSuffixes(builder.deniedSuffixes);
                }
            } else {
                this.deniedSuffixes.clear();
                this.addDeniedSuffixes(builder.deniedSuffixes);
            }
            if (this.isDeniedPatternsMutated) {
                if (builder.isDeniedPatternsMutated) {
                    this.addDeniedPatterns(builder.deniedPatterns);
                }
            } else {
                this.deniedPatterns.clear();
                this.addDeniedPatterns(builder.deniedPatterns);
            }
            if (this.isAllowedPredicatesMutated) {
                if (builder.isAllowedPredicatesMutated) {
                    this.addAllowedPredicates(builder.allowedPredicates);
                }
            } else {
                this.allowedPredicates.clear();
                this.addAllowedPredicates(builder.allowedPredicates);
            }
            if (this.isDeniedPredicatesMutated) {
                if (builder.isDeniedPredicatesMutated) {
                    this.addDeniedPredicates(builder.deniedPredicates);
                }
            } else {
                this.deniedPredicates.clear();
                this.addDeniedPredicates(builder.deniedPredicates);
            }
            return (BUILDER)((BuilderBase)this.self());
        }

        @Deprecated
        public BUILDER config(Config config) {
            return (BUILDER)this.config(io.helidon.config.Config.config((Config)config));
        }

        public BUILDER config(io.helidon.config.Config config) {
            Objects.requireNonNull(config);
            this.config = config;
            config.get("allow.all").as(Boolean.class).ifPresent(this::allowAll);
            config.get("allow.exact").asList(String.class).ifPresent(this::allowed);
            config.get("allow.prefix").asList(String.class).ifPresent(this::allowedPrefixes);
            config.get("allow.suffix").asList(String.class).ifPresent(this::allowedSuffixes);
            config.get("allow.pattern").asList(Pattern.class).ifPresent(this::allowedPatterns);
            config.get("deny.exact").asList(String.class).ifPresent(this::denied);
            config.get("deny.prefix").asList(String.class).ifPresent(this::deniedPrefixes);
            config.get("deny.suffix").asList(String.class).ifPresent(this::deniedSuffixes);
            config.get("deny.pattern").asList(Pattern.class).ifPresent(this::deniedPatterns);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowAll(boolean allowAll) {
            this.allowAll = allowAll;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowed(List<String> allowed) {
            Objects.requireNonNull(allowed);
            this.isAllowedMutated = true;
            this.allowed.clear();
            this.allowed.addAll(allowed);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowed(List<String> allowed) {
            Objects.requireNonNull(allowed);
            this.isAllowedMutated = true;
            this.allowed.addAll(allowed);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowed(String allowed) {
            Objects.requireNonNull(allowed);
            this.allowed.add(allowed);
            this.isAllowedMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowedPrefixes(List<String> allowedPrefixes) {
            Objects.requireNonNull(allowedPrefixes);
            this.isAllowedPrefixesMutated = true;
            this.allowedPrefixes.clear();
            this.allowedPrefixes.addAll(allowedPrefixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedPrefixes(List<String> allowedPrefixes) {
            Objects.requireNonNull(allowedPrefixes);
            this.isAllowedPrefixesMutated = true;
            this.allowedPrefixes.addAll(allowedPrefixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedPrefix(String allowedPrefix) {
            Objects.requireNonNull(allowedPrefix);
            this.allowedPrefixes.add(allowedPrefix);
            this.isAllowedPrefixesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowedSuffixes(List<String> allowedSuffixes) {
            Objects.requireNonNull(allowedSuffixes);
            this.isAllowedSuffixesMutated = true;
            this.allowedSuffixes.clear();
            this.allowedSuffixes.addAll(allowedSuffixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedSuffixes(List<String> allowedSuffixes) {
            Objects.requireNonNull(allowedSuffixes);
            this.isAllowedSuffixesMutated = true;
            this.allowedSuffixes.addAll(allowedSuffixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedSuffix(String allowedSuffix) {
            Objects.requireNonNull(allowedSuffix);
            this.allowedSuffixes.add(allowedSuffix);
            this.isAllowedSuffixesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowedPatterns(List<? extends Pattern> allowedPatterns) {
            Objects.requireNonNull(allowedPatterns);
            this.isAllowedPatternsMutated = true;
            this.allowedPatterns.clear();
            this.allowedPatterns.addAll(allowedPatterns);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedPatterns(List<? extends Pattern> allowedPatterns) {
            Objects.requireNonNull(allowedPatterns);
            this.isAllowedPatternsMutated = true;
            this.allowedPatterns.addAll(allowedPatterns);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedPattern(Pattern allowedPattern) {
            Objects.requireNonNull(allowedPattern);
            this.allowedPatterns.add(allowedPattern);
            this.isAllowedPatternsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER denied(List<String> denied) {
            Objects.requireNonNull(denied);
            this.isDeniedMutated = true;
            this.denied.clear();
            this.denied.addAll(denied);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDenied(List<String> denied) {
            Objects.requireNonNull(denied);
            this.isDeniedMutated = true;
            this.denied.addAll(denied);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDenied(String denied) {
            Objects.requireNonNull(denied);
            this.denied.add(denied);
            this.isDeniedMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deniedPrefixes(List<String> deniedPrefixes) {
            Objects.requireNonNull(deniedPrefixes);
            this.isDeniedPrefixesMutated = true;
            this.deniedPrefixes.clear();
            this.deniedPrefixes.addAll(deniedPrefixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedPrefixes(List<String> deniedPrefixes) {
            Objects.requireNonNull(deniedPrefixes);
            this.isDeniedPrefixesMutated = true;
            this.deniedPrefixes.addAll(deniedPrefixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedPrefix(String deniedPrefix) {
            Objects.requireNonNull(deniedPrefix);
            this.deniedPrefixes.add(deniedPrefix);
            this.isDeniedPrefixesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deniedSuffixes(List<String> deniedSuffixes) {
            Objects.requireNonNull(deniedSuffixes);
            this.isDeniedSuffixesMutated = true;
            this.deniedSuffixes.clear();
            this.deniedSuffixes.addAll(deniedSuffixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedSuffixes(List<String> deniedSuffixes) {
            Objects.requireNonNull(deniedSuffixes);
            this.isDeniedSuffixesMutated = true;
            this.deniedSuffixes.addAll(deniedSuffixes);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedSuffix(String deniedSuffix) {
            Objects.requireNonNull(deniedSuffix);
            this.deniedSuffixes.add(deniedSuffix);
            this.isDeniedSuffixesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deniedPatterns(List<? extends Pattern> deniedPatterns) {
            Objects.requireNonNull(deniedPatterns);
            this.isDeniedPatternsMutated = true;
            this.deniedPatterns.clear();
            this.deniedPatterns.addAll(deniedPatterns);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedPatterns(List<? extends Pattern> deniedPatterns) {
            Objects.requireNonNull(deniedPatterns);
            this.isDeniedPatternsMutated = true;
            this.deniedPatterns.addAll(deniedPatterns);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedPattern(Pattern deniedPattern) {
            Objects.requireNonNull(deniedPattern);
            this.deniedPatterns.add(deniedPattern);
            this.isDeniedPatternsMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER allowedPredicates(List<Predicate<String>> allowedPredicates) {
            Objects.requireNonNull(allowedPredicates);
            this.isAllowedPredicatesMutated = true;
            this.allowedPredicates.clear();
            this.allowedPredicates.addAll(allowedPredicates);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowedPredicates(List<Predicate<String>> allowedPredicates) {
            Objects.requireNonNull(allowedPredicates);
            this.isAllowedPredicatesMutated = true;
            this.allowedPredicates.addAll(allowedPredicates);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addAllowed(Predicate<String> allowed) {
            Objects.requireNonNull(allowed);
            this.allowedPredicates.add(allowed);
            this.isAllowedPredicatesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER deniedPredicates(List<Predicate<String>> deniedPredicates) {
            Objects.requireNonNull(deniedPredicates);
            this.isDeniedPredicatesMutated = true;
            this.deniedPredicates.clear();
            this.deniedPredicates.addAll(deniedPredicates);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDeniedPredicates(List<Predicate<String>> deniedPredicates) {
            Objects.requireNonNull(deniedPredicates);
            this.isDeniedPredicatesMutated = true;
            this.deniedPredicates.addAll(deniedPredicates);
            return (BUILDER)((BuilderBase)this.self());
        }

        public BUILDER addDenied(Predicate<String> denied) {
            Objects.requireNonNull(denied);
            this.deniedPredicates.add(denied);
            this.isDeniedPredicatesMutated = true;
            return (BUILDER)((BuilderBase)this.self());
        }

        public boolean allowAll() {
            return this.allowAll;
        }

        public List<String> allowed() {
            return this.allowed;
        }

        public List<String> allowedPrefixes() {
            return this.allowedPrefixes;
        }

        public List<String> allowedSuffixes() {
            return this.allowedSuffixes;
        }

        public List<Pattern> allowedPatterns() {
            return this.allowedPatterns;
        }

        public List<String> denied() {
            return this.denied;
        }

        public List<String> deniedPrefixes() {
            return this.deniedPrefixes;
        }

        public List<String> deniedSuffixes() {
            return this.deniedSuffixes;
        }

        public List<Pattern> deniedPatterns() {
            return this.deniedPatterns;
        }

        public List<Predicate<String>> allowedPredicates() {
            return this.allowedPredicates;
        }

        public List<Predicate<String>> deniedPredicates() {
            return this.deniedPredicates;
        }

        public Optional<Config> config() {
            return Optional.ofNullable(this.config);
        }

        public String toString() {
            return "AllowListConfigBuilder{allowAll=" + this.allowAll + ",allowed=" + String.valueOf(this.allowed) + ",allowedPrefixes=" + String.valueOf(this.allowedPrefixes) + ",allowedSuffixes=" + String.valueOf(this.allowedSuffixes) + ",allowedPatterns=" + String.valueOf(this.allowedPatterns) + ",denied=" + String.valueOf(this.denied) + ",deniedPrefixes=" + String.valueOf(this.deniedPrefixes) + ",deniedSuffixes=" + String.valueOf(this.deniedSuffixes) + ",deniedPatterns=" + String.valueOf(this.deniedPatterns) + ",allowedPredicates=" + String.valueOf(this.allowedPredicates) + ",deniedPredicates=" + String.valueOf(this.deniedPredicates) + "}";
        }

        protected void preBuildPrototype() {
        }

        protected void validatePrototype() {
        }

        protected static class AllowListConfigImpl
        implements AllowListConfig,
        Supplier<AllowList> {
            private final boolean allowAll;
            private final List<String> allowed;
            private final List<String> allowedPrefixes;
            private final List<String> allowedSuffixes;
            private final List<String> denied;
            private final List<String> deniedPrefixes;
            private final List<String> deniedSuffixes;
            private final List<Predicate<String>> allowedPredicates;
            private final List<Predicate<String>> deniedPredicates;
            private final List<Pattern> allowedPatterns;
            private final List<Pattern> deniedPatterns;

            protected AllowListConfigImpl(BuilderBase<?, ?> builder) {
                this.allowAll = builder.allowAll();
                this.allowed = List.copyOf(builder.allowed());
                this.allowedPrefixes = List.copyOf(builder.allowedPrefixes());
                this.allowedSuffixes = List.copyOf(builder.allowedSuffixes());
                this.allowedPatterns = List.copyOf(builder.allowedPatterns());
                this.denied = List.copyOf(builder.denied());
                this.deniedPrefixes = List.copyOf(builder.deniedPrefixes());
                this.deniedSuffixes = List.copyOf(builder.deniedSuffixes());
                this.deniedPatterns = List.copyOf(builder.deniedPatterns());
                this.allowedPredicates = List.copyOf(builder.allowedPredicates());
                this.deniedPredicates = List.copyOf(builder.deniedPredicates());
            }

            public AllowList build() {
                return AllowList.create(this);
            }

            @Override
            public AllowList get() {
                return this.build();
            }

            @Override
            public boolean allowAll() {
                return this.allowAll;
            }

            @Override
            public List<String> allowed() {
                return this.allowed;
            }

            @Override
            public List<String> allowedPrefixes() {
                return this.allowedPrefixes;
            }

            @Override
            public List<String> allowedSuffixes() {
                return this.allowedSuffixes;
            }

            @Override
            public List<Pattern> allowedPatterns() {
                return this.allowedPatterns;
            }

            @Override
            public List<String> denied() {
                return this.denied;
            }

            @Override
            public List<String> deniedPrefixes() {
                return this.deniedPrefixes;
            }

            @Override
            public List<String> deniedSuffixes() {
                return this.deniedSuffixes;
            }

            @Override
            public List<Pattern> deniedPatterns() {
                return this.deniedPatterns;
            }

            @Override
            public List<Predicate<String>> allowedPredicates() {
                return this.allowedPredicates;
            }

            @Override
            public List<Predicate<String>> deniedPredicates() {
                return this.deniedPredicates;
            }

            public String toString() {
                return "AllowListConfig{allowAll=" + this.allowAll + ",allowed=" + String.valueOf(this.allowed) + ",allowedPrefixes=" + String.valueOf(this.allowedPrefixes) + ",allowedSuffixes=" + String.valueOf(this.allowedSuffixes) + ",allowedPatterns=" + String.valueOf(this.allowedPatterns) + ",denied=" + String.valueOf(this.denied) + ",deniedPrefixes=" + String.valueOf(this.deniedPrefixes) + ",deniedSuffixes=" + String.valueOf(this.deniedSuffixes) + ",deniedPatterns=" + String.valueOf(this.deniedPatterns) + ",allowedPredicates=" + String.valueOf(this.allowedPredicates) + ",deniedPredicates=" + String.valueOf(this.deniedPredicates) + "}";
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof AllowListConfig)) {
                    return false;
                }
                AllowListConfig other = (AllowListConfig)o;
                return this.allowAll == other.allowAll() && Objects.equals(this.allowed, other.allowed()) && Objects.equals(this.allowedPrefixes, other.allowedPrefixes()) && Objects.equals(this.allowedSuffixes, other.allowedSuffixes()) && Objects.equals(this.allowedPatterns, other.allowedPatterns()) && Objects.equals(this.denied, other.denied()) && Objects.equals(this.deniedPrefixes, other.deniedPrefixes()) && Objects.equals(this.deniedSuffixes, other.deniedSuffixes()) && Objects.equals(this.deniedPatterns, other.deniedPatterns()) && Objects.equals(this.allowedPredicates, other.allowedPredicates()) && Objects.equals(this.deniedPredicates, other.deniedPredicates());
            }

            public int hashCode() {
                return Objects.hash(this.allowAll, this.allowed, this.allowedPrefixes, this.allowedSuffixes, this.allowedPatterns, this.denied, this.deniedPrefixes, this.deniedSuffixes, this.deniedPatterns, this.allowedPredicates, this.deniedPredicates);
            }
        }
    }
}

