/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.component.framework.schedulers.builders.internal;

import com.swirlds.base.time.Time;
import com.swirlds.component.framework.model.StandardWiringModel;
import com.swirlds.component.framework.schedulers.TaskScheduler;
import com.swirlds.component.framework.schedulers.builders.TaskSchedulerType;
import com.swirlds.component.framework.schedulers.builders.internal.AbstractTaskSchedulerBuilder;
import com.swirlds.component.framework.schedulers.internal.ConcurrentTaskScheduler;
import com.swirlds.component.framework.schedulers.internal.DirectTaskScheduler;
import com.swirlds.component.framework.schedulers.internal.NoOpTaskScheduler;
import com.swirlds.component.framework.schedulers.internal.SequentialTaskScheduler;
import com.swirlds.component.framework.schedulers.internal.SequentialThreadTaskScheduler;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.concurrent.ForkJoinPool;
import java.util.function.Supplier;
import org.hiero.consensus.metrics.FunctionGauge;
import org.hiero.consensus.metrics.extensions.FractionalTimer;
import org.hiero.consensus.metrics.extensions.NoOpFractionalTimer;
import org.hiero.consensus.metrics.extensions.StandardFractionalTimer;

public class StandardTaskSchedulerBuilder<OUT>
extends AbstractTaskSchedulerBuilder<OUT> {
    protected final Time time;

    public StandardTaskSchedulerBuilder(@NonNull Time time, @NonNull Metrics metrics, @NonNull StandardWiringModel model, @NonNull String name, @NonNull ForkJoinPool defaultPool) {
        super(metrics, model, name, defaultPool);
        this.time = time;
    }

    @NonNull
    private FractionalTimer buildBusyTimer() {
        if (!this.busyFractionMetricEnabled || this.type == TaskSchedulerType.NO_OP) {
            return NoOpFractionalTimer.getInstance();
        }
        if (this.type == TaskSchedulerType.CONCURRENT) {
            throw new IllegalStateException("Busy fraction metric is not compatible with concurrent schedulers");
        }
        return new StandardFractionalTimer(this.time);
    }

    private void registerMetrics(@Nullable Supplier<Long> longSupplier, @NonNull FractionalTimer busyFractionTimer) {
        if (this.type == TaskSchedulerType.NO_OP) {
            return;
        }
        if (this.unhandledTaskMetricEnabled) {
            Objects.requireNonNull(longSupplier);
            FunctionGauge.Config config = new FunctionGauge.Config("platform", this.name + "_unhandled_task_count", Long.class, longSupplier).withDescription("The number of scheduled tasks that have not been fully handled for the scheduler " + this.name);
            this.metrics.getOrCreate((MetricConfig)config);
        }
        if (this.busyFractionMetricEnabled) {
            busyFractionTimer.registerMetric(this.metrics, "platform", this.name + "_busy_fraction", "Fraction (out of 1.0) of time spent processing tasks for the task scheduler " + this.name);
        }
    }

    @Override
    @NonNull
    public TaskScheduler<OUT> build() {
        TaskScheduler scheduler;
        AbstractTaskSchedulerBuilder.Counters counters = this.buildCounters();
        FractionalTimer busyFractionTimer = this.buildBusyTimer();
        boolean insertionIsBlocking = (this.unhandledTaskCapacity != -1L || this.externalBackPressure) && this.type != TaskSchedulerType.NO_OP;
        switch (this.type) {
            default: {
                throw new MatchException(null, null);
            }
            case CONCURRENT: {
                TaskScheduler taskScheduler = new ConcurrentTaskScheduler(this.model, this.name, this.pool, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), this.unhandledTaskCapacity, this.flushingEnabled, this.squelchingEnabled, insertionIsBlocking);
                break;
            }
            case SEQUENTIAL: {
                TaskScheduler taskScheduler = new SequentialTaskScheduler(this.model, this.name, this.pool, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), busyFractionTimer, this.unhandledTaskCapacity, this.flushingEnabled, this.squelchingEnabled, insertionIsBlocking);
                break;
            }
            case SEQUENTIAL_THREAD: {
                TaskScheduler taskScheduler = new SequentialThreadTaskScheduler(this.model, this.name, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), this.dataCounter, busyFractionTimer, this.unhandledTaskCapacity, this.flushingEnabled, this.squelchingEnabled, insertionIsBlocking);
                break;
            }
            case DIRECT: 
            case DIRECT_THREADSAFE: {
                TaskScheduler taskScheduler = new DirectTaskScheduler(this.model, this.name, this.buildUncaughtExceptionHandler(), counters.onRamp(), counters.offRamp(), this.squelchingEnabled, busyFractionTimer, this.type == TaskSchedulerType.DIRECT_THREADSAFE);
                break;
            }
            case NO_OP: {
                TaskScheduler taskScheduler = scheduler = new NoOpTaskScheduler(this.model, this.name, this.type, this.flushingEnabled, this.squelchingEnabled);
            }
        }
        if (this.type != TaskSchedulerType.NO_OP) {
            this.model.registerScheduler(scheduler, this.hyperlink);
        }
        this.registerMetrics(scheduler::getUnprocessedTaskCount, busyFractionTimer);
        return scheduler;
    }
}

