/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.workflows.standalone.impl;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.SignatureMap;
import com.hedera.hapi.node.transaction.SignedTransaction;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.blocks.impl.BoundaryStateChangeListener;
import com.hedera.node.app.blocks.impl.ImmediateStateChangeListener;
import com.hedera.node.app.fees.AppFeeCharging;
import com.hedera.node.app.fees.ExchangeRateManager;
import com.hedera.node.app.fees.FeeAccumulator;
import com.hedera.node.app.fees.FeeManager;
import com.hedera.node.app.fees.ResourcePriceCalculatorImpl;
import com.hedera.node.app.info.NodeInfoImpl;
import com.hedera.node.app.records.impl.BlockRecordInfoImpl;
import com.hedera.node.app.service.entityid.EntityNumGenerator;
import com.hedera.node.app.service.entityid.WritableEntityCounters;
import com.hedera.node.app.service.entityid.WritableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.EntityNumGeneratorImpl;
import com.hedera.node.app.service.entityid.impl.WritableEntityIdStoreImpl;
import com.hedera.node.app.service.schedule.ScheduleServiceApi;
import com.hedera.node.app.service.schedule.impl.ScheduleServiceImpl;
import com.hedera.node.app.service.token.api.FeeStreamBuilder;
import com.hedera.node.app.service.token.api.TokenServiceApi;
import com.hedera.node.app.service.token.impl.api.TokenServiceApiProvider;
import com.hedera.node.app.services.ServiceScopeLookup;
import com.hedera.node.app.spi.api.ServiceApiProvider;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.NodeFeeAccumulator;
import com.hedera.node.app.spi.info.NetworkInfo;
import com.hedera.node.app.spi.info.NodeInfo;
import com.hedera.node.app.spi.metrics.StoreMetricsService;
import com.hedera.node.app.spi.workflows.HandleContext;
import com.hedera.node.app.spi.workflows.record.StreamBuilder;
import com.hedera.node.app.store.ReadableStoreFactory;
import com.hedera.node.app.store.ServiceApiFactory;
import com.hedera.node.app.store.StoreFactoryImpl;
import com.hedera.node.app.store.WritableStoreFactory;
import com.hedera.node.app.throttle.AppThrottleAdviser;
import com.hedera.node.app.throttle.NetworkUtilizationManager;
import com.hedera.node.app.workflows.TransactionChecker;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.app.workflows.dispatcher.TransactionDispatcher;
import com.hedera.node.app.workflows.handle.Dispatch;
import com.hedera.node.app.workflows.handle.DispatchHandleContext;
import com.hedera.node.app.workflows.handle.DispatchProcessor;
import com.hedera.node.app.workflows.handle.HandleWorkflow;
import com.hedera.node.app.workflows.handle.RecordDispatch;
import com.hedera.node.app.workflows.handle.dispatch.ChildDispatchFactory;
import com.hedera.node.app.workflows.handle.record.TokenContextImpl;
import com.hedera.node.app.workflows.handle.stack.SavepointStackImpl;
import com.hedera.node.app.workflows.handle.steps.ParentTxnFactory;
import com.hedera.node.app.workflows.prehandle.PreHandleResult;
import com.hedera.node.app.workflows.prehandle.PreHandleWorkflow;
import com.hedera.node.config.ConfigProvider;
import com.hedera.node.config.VersionedConfiguration;
import com.hedera.node.config.data.BlockStreamConfig;
import com.hedera.node.config.data.ConsensusConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hiero.consensus.model.transaction.ConsensusTransaction;
import org.hiero.consensus.model.transaction.TransactionWrapper;

@Singleton
public class StandaloneDispatchFactory {
    private final FeeManager feeManager;
    private final AppFeeCharging appFeeCharging;
    private final Authorizer authorizer;
    private final NetworkInfo networkInfo;
    private final ConfigProvider configProvider;
    private final DispatchProcessor dispatchProcessor;
    private final PreHandleWorkflow preHandleWorkflow;
    private final ServiceScopeLookup serviceScopeLookup;
    private final ExchangeRateManager exchangeRateManager;
    private final StoreMetricsService storeMetricsService;
    private final ChildDispatchFactory childDispatchFactory;
    private final TransactionDispatcher transactionDispatcher;
    private final NetworkUtilizationManager networkUtilizationManager;
    private final TransactionChecker transactionChecker;
    private final Map<Class<?>, ServiceApiProvider<?>> apiProviders;

    @Inject
    public StandaloneDispatchFactory(@NonNull FeeManager feeManager, @NonNull AppFeeCharging appFeeCharging, @NonNull Authorizer authorizer, @NonNull NetworkInfo networkInfo, @NonNull ConfigProvider configProvider, @NonNull DispatchProcessor dispatchProcessor, @NonNull PreHandleWorkflow preHandleWorkflow, @NonNull ServiceScopeLookup serviceScopeLookup, @NonNull ExchangeRateManager exchangeRateManager, @NonNull StoreMetricsService storeMetricsService, @NonNull ChildDispatchFactory childDispatchFactory, @NonNull TransactionDispatcher transactionDispatcher, @NonNull NetworkUtilizationManager networkUtilizationManager, @NonNull TransactionChecker transactionChecker, @NonNull ScheduleServiceImpl scheduleService) {
        this.feeManager = Objects.requireNonNull(feeManager);
        this.appFeeCharging = Objects.requireNonNull(appFeeCharging);
        this.authorizer = Objects.requireNonNull(authorizer);
        this.networkInfo = Objects.requireNonNull(networkInfo);
        this.configProvider = Objects.requireNonNull(configProvider);
        this.dispatchProcessor = Objects.requireNonNull(dispatchProcessor);
        this.preHandleWorkflow = Objects.requireNonNull(preHandleWorkflow);
        this.childDispatchFactory = Objects.requireNonNull(childDispatchFactory);
        this.transactionDispatcher = Objects.requireNonNull(transactionDispatcher);
        this.serviceScopeLookup = Objects.requireNonNull(serviceScopeLookup);
        this.exchangeRateManager = Objects.requireNonNull(exchangeRateManager);
        this.storeMetricsService = Objects.requireNonNull(storeMetricsService);
        this.networkUtilizationManager = Objects.requireNonNull(networkUtilizationManager);
        this.transactionChecker = Objects.requireNonNull(transactionChecker);
        Objects.requireNonNull(scheduleService);
        this.apiProviders = Map.of(TokenServiceApi.class, TokenServiceApiProvider.TOKEN_SERVICE_API_PROVIDER, ScheduleServiceApi.class, scheduleService.apiProvider());
    }

    public Dispatch newDispatch(@NonNull State state, @NonNull TransactionBody transactionBody, @NonNull Instant consensusNow) {
        VersionedConfiguration config = this.configProvider.getConfiguration();
        ConsensusConfig consensusConfig = (ConsensusConfig)config.getConfigData(ConsensusConfig.class);
        BlockStreamConfig blockStreamConfig = (BlockStreamConfig)config.getConfigData(BlockStreamConfig.class);
        SavepointStackImpl stack = SavepointStackImpl.newRootStack(state, consensusConfig.handleMaxPrecedingRecords(), consensusConfig.handleMaxFollowingRecords(), new BoundaryStateChangeListener(this.storeMetricsService, () -> config), new ImmediateStateChangeListener(), blockStreamConfig.streamMode());
        ReadableStoreFactory readableStoreFactory = new ReadableStoreFactory(stack);
        WritableEntityIdStoreImpl entityIdStore = new WritableEntityIdStoreImpl(stack.getWritableStates("EntityIdService"));
        ConsensusTransaction consensusTransaction = this.consensusTransactionFor(transactionBody);
        NodeInfo creatorInfo = this.creatorInfoFor(transactionBody);
        PreHandleResult preHandleResult = this.preHandleWorkflow.getCurrentPreHandleResult(creatorInfo, consensusTransaction, readableStoreFactory, (ignore, ignored) -> {});
        TokenContextImpl tokenContext = new TokenContextImpl((Configuration)config, stack, consensusNow, (WritableEntityCounters)entityIdStore);
        TransactionInfo txnInfo = Objects.requireNonNull(preHandleResult.txInfo());
        WritableStoreFactory writableStoreFactory = new WritableStoreFactory(stack, this.serviceScopeLookup.getServiceName(txnInfo.txBody()), (WritableEntityCounters)entityIdStore);
        ServiceApiFactory serviceApiFactory = new ServiceApiFactory(stack, (Configuration)config, this.apiProviders, NodeFeeAccumulator.NOOP);
        ResourcePriceCalculatorImpl priceCalculator = new ResourcePriceCalculatorImpl(consensusNow, txnInfo, this.feeManager, readableStoreFactory);
        StoreFactoryImpl storeFactory = new StoreFactoryImpl(readableStoreFactory, writableStoreFactory, serviceApiFactory);
        EntityNumGeneratorImpl entityNumGenerator = new EntityNumGeneratorImpl((WritableEntityIdStore)entityIdStore);
        AppThrottleAdviser throttleAdvisor = new AppThrottleAdviser(this.networkUtilizationManager, consensusNow);
        StreamBuilder baseBuilder = HandleWorkflow.initializeBuilderInfo(stack.getBaseBuilder(StreamBuilder.class), txnInfo, this.exchangeRateManager.exchangeRates());
        FeeAccumulator feeAccumulator = new FeeAccumulator(serviceApiFactory.getApi(TokenServiceApi.class), (FeeStreamBuilder)baseBuilder, stack);
        BlockRecordInfoImpl blockRecordInfo = BlockRecordInfoImpl.from(state);
        DispatchHandleContext dispatchHandleContext = new DispatchHandleContext(consensusNow, creatorInfo, txnInfo, (Configuration)config, this.authorizer, blockRecordInfo, priceCalculator, this.feeManager, this.appFeeCharging, storeFactory, Objects.requireNonNull(txnInfo.payerID()), ChildDispatchFactory.NO_OP_KEY_VERIFIER, txnInfo.functionality(), preHandleResult.payerKey() == null ? Key.DEFAULT : preHandleResult.payerKey(), this.exchangeRateManager, stack, (EntityNumGenerator)entityNumGenerator, this.transactionDispatcher, this.networkInfo, this.childDispatchFactory, this.dispatchProcessor, throttleAdvisor, feeAccumulator, HandleContext.DispatchMetadata.EMPTY_METADATA, this.transactionChecker, preHandleResult.innerResults(), this.preHandleWorkflow, HandleContext.TransactionCategory.USER);
        Fees fees = this.transactionDispatcher.dispatchComputeFees(dispatchHandleContext);
        return new RecordDispatch(baseBuilder, (Configuration)config, fees, txnInfo, Objects.requireNonNull(txnInfo.payerID()), readableStoreFactory, feeAccumulator, ChildDispatchFactory.NO_OP_KEY_VERIFIER, creatorInfo, consensusNow, preHandleResult.getRequiredKeys(), preHandleResult.getHollowAccounts(), dispatchHandleContext, stack, ParentTxnFactory.getTxnCategory(preHandleResult), tokenContext, preHandleResult, HandleContext.ConsensusThrottling.ON, null);
    }

    private ConsensusTransaction consensusTransactionFor(@NonNull TransactionBody transactionBody) {
        SignedTransaction signedTx = new SignedTransaction(TransactionBody.PROTOBUF.toBytes((Object)transactionBody), SignatureMap.DEFAULT, false);
        Bytes serializedSignedTx = SignedTransaction.PROTOBUF.toBytes((Object)signedTx);
        TransactionWrapper consensusTransaction = new TransactionWrapper(serializedSignedTx);
        consensusTransaction.setMetadata((Object)this.temporaryPreHandleResult());
        return consensusTransaction;
    }

    private NodeInfo creatorInfoFor(@NonNull TransactionBody transactionBody) {
        return new NodeInfoImpl(0L, transactionBody.nodeAccountIDOrThrow(), 0L, List.of(), Bytes.EMPTY, List.of(), false, null);
    }

    private PreHandleResult temporaryPreHandleResult() {
        return new PreHandleResult(null, null, PreHandleResult.Status.UNKNOWN_FAILURE, ResponseCodeEnum.OK, null, null, null, null, null, null, -1L);
    }
}

