/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.token.impl.handlers;

import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.QueryHeader;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ResponseHeader;
import com.hedera.hapi.node.base.ResponseType;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.token.TokenGetNftInfoQuery;
import com.hedera.hapi.node.token.TokenGetNftInfoResponse;
import com.hedera.hapi.node.token.TokenNftInfo;
import com.hedera.hapi.node.transaction.Response;
import com.hedera.node.app.hapi.fees.usage.token.TokenGetNftInfoUsage;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.workflows.PaidQueryHandler;
import com.hedera.node.app.spi.workflows.PreCheckException;
import com.hedera.node.app.spi.workflows.QueryContext;
import com.hedera.node.config.data.LedgerConfig;
import com.hederahashgraph.api.proto.java.FeeData;
import com.hederahashgraph.api.proto.java.Query;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class TokenGetNftInfoHandler
extends PaidQueryHandler {
    @Inject
    public TokenGetNftInfoHandler() {
    }

    public QueryHeader extractHeader(@NonNull com.hedera.hapi.node.transaction.Query query) {
        Objects.requireNonNull(query);
        return query.tokenGetNftInfoOrThrow().header();
    }

    public Response createEmptyResponse(@NonNull ResponseHeader header) {
        Objects.requireNonNull(header);
        TokenGetNftInfoResponse.Builder response = TokenGetNftInfoResponse.newBuilder().header(Objects.requireNonNull(header));
        return Response.newBuilder().tokenGetNftInfo(response).build();
    }

    public void validate(@NonNull QueryContext context) throws PreCheckException {
        Objects.requireNonNull(context);
        com.hedera.hapi.node.transaction.Query query = context.query();
        ReadableNftStore nftStore = (ReadableNftStore)context.createStore(ReadableNftStore.class);
        TokenGetNftInfoQuery op = query.tokenGetNftInfoOrThrow();
        NftID nftId = op.nftIDOrThrow();
        PreCheckException.validateTruePreCheck((boolean)nftId.hasTokenId(), (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_ID);
        PreCheckException.validateTruePreCheck((nftId.serialNumber() > 0L ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_TOKEN_NFT_SERIAL_NUMBER);
        Nft nft = nftStore.get(nftId.tokenIdOrThrow(), nftId.serialNumber());
        PreCheckException.validateFalsePreCheck((nft == null ? 1 : 0) != 0, (ResponseCodeEnum)ResponseCodeEnum.INVALID_NFT_ID);
    }

    public Response findResponse(@NonNull QueryContext context, @NonNull ResponseHeader header) {
        Objects.requireNonNull(context);
        Objects.requireNonNull(header);
        com.hedera.hapi.node.transaction.Query query = context.query();
        LedgerConfig config = (LedgerConfig)context.configuration().getConfigData(LedgerConfig.class);
        ReadableNftStore nftStore = (ReadableNftStore)context.createStore(ReadableNftStore.class);
        ReadableTokenStore tokenStore = (ReadableTokenStore)context.createStore(ReadableTokenStore.class);
        TokenGetNftInfoQuery op = query.tokenGetNftInfoOrThrow();
        TokenGetNftInfoResponse.Builder response = TokenGetNftInfoResponse.newBuilder();
        NftID nftId = op.nftIDOrElse(NftID.DEFAULT);
        ResponseType responseType = op.headerOrElse(QueryHeader.DEFAULT).responseType();
        response.header(header);
        if (header.nodeTransactionPrecheckCode() == ResponseCodeEnum.OK && responseType != ResponseType.COST_ANSWER) {
            Optional<TokenNftInfo> optionalInfo = this.infoForNft(nftId, nftStore, tokenStore, config);
            if (optionalInfo.isPresent()) {
                response.nft(optionalInfo.get());
            } else {
                response.header(ResponseHeader.newBuilder().nodeTransactionPrecheckCode(ResponseCodeEnum.INVALID_NFT_ID).cost(0L));
            }
        }
        return Response.newBuilder().tokenGetNftInfo(response).build();
    }

    private Optional<TokenNftInfo> infoForNft(@NonNull NftID nftId, @NonNull ReadableNftStore readableNftStore, @NonNull ReadableTokenStore readableTokenStore, @NonNull LedgerConfig config) {
        Objects.requireNonNull(nftId);
        Objects.requireNonNull(readableNftStore);
        Objects.requireNonNull(readableTokenStore);
        Objects.requireNonNull(config);
        Nft nft = readableNftStore.get(nftId.tokenIdOrThrow(), nftId.serialNumber());
        Token token = Objects.requireNonNull(readableTokenStore.get(nftId.tokenIdOrThrow()));
        if (nft == null) {
            return Optional.empty();
        }
        TokenNftInfo info = TokenNftInfo.newBuilder().ledgerId(config.id()).nftID(nftId).accountID(nft.ownerIdOrElse(token.treasuryAccountIdOrThrow())).creationTime(nft.mintTime()).metadata(nft.metadata()).spenderId(nft.spenderId()).build();
        return Optional.of(info);
    }

    @NonNull
    public Fees computeFees(@NonNull QueryContext queryContext) {
        com.hedera.hapi.node.transaction.Query query = queryContext.query();
        ReadableNftStore nftStore = (ReadableNftStore)queryContext.createStore(ReadableNftStore.class);
        TokenGetNftInfoQuery op = query.tokenGetNftInfoOrThrow();
        NftID nftId = op.nftIDOrThrow();
        Nft nft = nftStore.get(nftId);
        return queryContext.feeCalculator().legacyCalculate(sigValueObj -> this.usageGiven(query, nft));
    }

    private FeeData usageGiven(com.hedera.hapi.node.transaction.Query query, Nft nft) {
        if (nft != null) {
            TokenGetNftInfoUsage estimate = TokenGetNftInfoUsage.newEstimate((Query)CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.Query)query)).givenMetadata(nft.metadata().toString());
            return estimate.get();
        }
        return Fees.CONSTANT_FEE_DATA;
    }
}

