/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pces;

import com.swirlds.common.config.StateCommonConfig;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Objects;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.pces.PcesConfig;
import org.hiero.consensus.pces.PcesFile;
import org.hiero.consensus.pces.PcesFileIterator;
import org.hiero.consensus.pces.PcesFileTracker;

public final class PcesUtilities {
    private static final Logger logger = LogManager.getLogger(PcesUtilities.class);

    private PcesUtilities() {
    }

    @NonNull
    public static PcesFile compactPreconsensusEventFile(@NonNull PcesFile originalFile, long previousUpperBound) {
        long newUpperBound = originalFile.getLowerBound();
        try (PcesFileIterator iterator = new PcesFileIterator(originalFile, 0L);){
            while (iterator.hasNext()) {
                PlatformEvent next = (PlatformEvent)iterator.next();
                newUpperBound = Math.max(newUpperBound, next.getBirthRound());
            }
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to read file {}", (Object)originalFile.getPath(), (Object)e);
            return originalFile;
        }
        newUpperBound = Math.max(newUpperBound, previousUpperBound);
        if (newUpperBound == originalFile.getUpperBound()) {
            logger.info(LogMarker.STARTUP.getMarker(), "No span compaction necessary for {}", (Object)originalFile.getPath());
            return originalFile;
        }
        PcesFile newFile = originalFile.buildFileWithCompressedSpan(newUpperBound);
        try {
            Files.move(originalFile.getPath(), newFile.getPath(), StandardCopyOption.ATOMIC_MOVE);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to compact span of file {}", (Object)originalFile.getPath(), (Object)e);
            return originalFile;
        }
        logger.info(LogMarker.STARTUP.getMarker(), "Span compaction completed for {}, new upper bound is {}", (Object)originalFile.getPath(), (Object)newUpperBound);
        return newFile;
    }

    @Nullable
    public static PcesFile parseFile(@NonNull Path path) {
        try {
            return PcesFile.of(path);
        }
        catch (IOException exception) {
            logger.warn(LogMarker.EXCEPTION.getMarker(), "Failed to parse file: {}", (Object)path, (Object)exception);
            return null;
        }
    }

    public static void compactPreconsensusEventFiles(@NonNull Path rootPath) {
        ArrayList files = new ArrayList();
        try (Stream<Path> fileStream = Files.walk(rootPath, new FileVisitOption[0]);){
            fileStream.filter(f -> !Files.isDirectory(f, new LinkOption[0])).filter(f -> f.toString().endsWith(".pces")).map(PcesUtilities::parseFile).filter(Objects::nonNull).sorted().forEachOrdered(files::add);
        }
        catch (IOException e) {
            logger.error(LogMarker.EXCEPTION.getMarker(), "Failed to walk directory tree {}", (Object)rootPath, (Object)e);
        }
        long previousUpperBound = 0L;
        for (PcesFile file : files) {
            PcesFile compactedFile = PcesUtilities.compactPreconsensusEventFile(file, previousUpperBound);
            previousUpperBound = compactedFile.getUpperBound();
        }
    }

    public static void fileSanityChecks(boolean permitGaps, long previousSequenceNumber, long previousLowerBound, long previousUpperBound, long previousOrigin, @NonNull Instant previousTimestamp, @NonNull PcesFile descriptor) {
        if (!permitGaps && previousSequenceNumber + 1L != descriptor.getSequenceNumber()) {
            throw new IllegalStateException("Gap in preconsensus event files detected! Previous sequence number was " + previousSequenceNumber + ", next sequence number is " + descriptor.getSequenceNumber());
        }
        if (descriptor.getLowerBound() < previousLowerBound) {
            throw new IllegalStateException("Lower bound must never decrease, file " + String.valueOf(descriptor.getPath()) + " has a lower bound that is less than the previous lower bound of " + previousLowerBound);
        }
        if (descriptor.getUpperBound() < previousUpperBound) {
            throw new IllegalStateException("Upper bound must never decrease, file " + String.valueOf(descriptor.getPath()) + " has an upper bound that is less than the previous upper bound of " + previousUpperBound);
        }
        if (descriptor.getTimestamp().isBefore(previousTimestamp)) {
            throw new IllegalStateException("Timestamp must never decrease, file " + String.valueOf(descriptor.getPath()) + " has a timestamp that is less than the previous timestamp of " + String.valueOf(previousTimestamp));
        }
        if (descriptor.getOrigin() < previousOrigin) {
            throw new IllegalStateException("Origin round must never decrease, file " + String.valueOf(descriptor.getPath()) + " has an origin round that is less than the previous origin round of " + previousOrigin);
        }
    }

    @NonNull
    public static Path getDatabaseDirectory(@NonNull Configuration configuration, @NonNull NodeId selfId) throws IOException {
        StateCommonConfig stateConfig = (StateCommonConfig)configuration.getConfigData(StateCommonConfig.class);
        PcesConfig preconsensusEventStreamConfig = (PcesConfig)configuration.getConfigData(PcesConfig.class);
        Path savedStateDirectory = stateConfig.savedStateDirectory();
        Path databaseDirectory = savedStateDirectory.resolve(preconsensusEventStreamConfig.databaseDirectory()).resolve(Long.toString(selfId.id()));
        if (!Files.exists(databaseDirectory, new LinkOption[0])) {
            Files.createDirectories(databaseDirectory, new FileAttribute[0]);
        }
        return databaseDirectory;
    }

    public static long getInitialOrigin(@NonNull PcesFileTracker files, long startingRound) {
        if (startingRound == -1L) {
            return files.getFirstFile().getOrigin();
        }
        int firstRelevantFileIndex = files.getFirstRelevantFileIndex(startingRound);
        if (firstRelevantFileIndex >= 0) {
            return files.getFile(firstRelevantFileIndex).getOrigin();
        }
        return startingRound;
    }
}

