/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.QueryFeeCalculator;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.workflows.QueryContext;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.ExtraFeeReference;
import org.hiero.hapi.support.fees.FeeSchedule;

public class SimpleFeeCalculatorImpl
implements SimpleFeeCalculator {
    protected final FeeSchedule feeSchedule;
    private final Map<TransactionBody.DataOneOfType, ServiceFeeCalculator> serviceFeeCalculators;
    private final Map<Query.QueryOneOfType, QueryFeeCalculator> queryFeeCalculators;

    public SimpleFeeCalculatorImpl(FeeSchedule feeSchedule, Set<ServiceFeeCalculator> serviceFeeCalculators) {
        this(feeSchedule, serviceFeeCalculators, Set.of());
    }

    public SimpleFeeCalculatorImpl(FeeSchedule feeSchedule, Set<ServiceFeeCalculator> serviceFeeCalculators, Set<QueryFeeCalculator> queryFeeCalculators) {
        this.feeSchedule = feeSchedule;
        this.serviceFeeCalculators = serviceFeeCalculators.stream().collect(Collectors.toMap(ServiceFeeCalculator::getTransactionType, Function.identity()));
        this.queryFeeCalculators = queryFeeCalculators.stream().collect(Collectors.toMap(QueryFeeCalculator::getQueryType, Function.identity()));
    }

    private void addNodeExtras(@NonNull FeeResult result, @NonNull Iterable<ExtraFeeReference> extras, long signatures, long bytes) {
        for (ExtraFeeReference ref : extras) {
            long used = switch (ref.name()) {
                case Extra.SIGNATURES -> signatures;
                case Extra.BYTES -> bytes;
                default -> 0L;
            };
            long unitFee = this.getExtraFee(ref.name());
            result.addNodeExtraFeeTinycents(ref.name().name(), unitFee, used, (long)ref.includedCount());
        }
    }

    @Override
    @NonNull
    public FeeResult calculateTxFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext) {
        long signatures = feeContext != null ? (long)feeContext.numTxnSignatures() : 0L;
        long bytes = feeContext != null ? (long)feeContext.numTxnBytes() : 0L;
        FeeResult result = new FeeResult();
        result.setNodeBaseFeeTinycents(this.feeSchedule.node().baseFee());
        this.addNodeExtras(result, this.feeSchedule.node().extras(), signatures, bytes);
        int multiplier = this.feeSchedule.network().multiplier();
        result.setNetworkMultiplier(multiplier);
        ServiceFeeCalculator serviceFeeCalculator = this.serviceFeeCalculators.get(txnBody.data().kind());
        serviceFeeCalculator.accumulateServiceFee(txnBody, feeContext, result, this.feeSchedule);
        return result;
    }

    @Override
    public long getExtraFee(Extra extra) {
        return this.feeSchedule.extras().stream().filter(feeDefinition -> feeDefinition.name() == extra).findFirst().orElseThrow(() -> new IllegalArgumentException("Extra fee not found: " + String.valueOf(extra))).fee();
    }

    public static long countKeys(@NonNull Key key) {
        return switch ((Key.KeyOneOfType)key.key().kind()) {
            case Key.KeyOneOfType.ED25519, Key.KeyOneOfType.ECDSA_SECP256K1, Key.KeyOneOfType.ECDSA_384 -> 1L;
            case Key.KeyOneOfType.THRESHOLD_KEY -> key.thresholdKeyOrThrow().keys().keys().stream().mapToLong(SimpleFeeCalculatorImpl::countKeys).sum();
            case Key.KeyOneOfType.KEY_LIST -> key.keyListOrThrow().keys().stream().mapToLong(SimpleFeeCalculatorImpl::countKeys).sum();
            default -> 0L;
        };
    }

    @Override
    public long calculateQueryFee(@NonNull Query query, @NonNull QueryContext queryContext) {
        FeeResult result = new FeeResult();
        QueryFeeCalculator queryFeeCalculator = this.queryFeeCalculators.get(query.query().kind());
        queryFeeCalculator.accumulateNodePayment(query, queryContext, result, this.feeSchedule);
        return result.totalTinycents();
    }
}

