/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.state.service;

import com.hedera.hapi.platform.state.ConsensusSnapshot;
import com.hedera.hapi.platform.state.PlatformState;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.state.PlatformStateAccessor;
import com.swirlds.platform.state.service.PlatformStateValueAccumulator;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.Objects;
import java.util.Optional;
import org.hiero.base.crypto.Hash;
import org.hiero.consensus.model.PbjConverters;

public final class PbjConverter {
    @NonNull
    public static PlatformState toPbjPlatformState(@NonNull PlatformStateAccessor accessor) {
        Objects.requireNonNull(accessor);
        return new PlatformState(accessor.getCreationSoftwareVersion(), accessor.getRoundsNonAncient(), accessor.getSnapshot(), PbjConverters.toPbjTimestamp((Instant)accessor.getFreezeTime()), PbjConverters.toPbjTimestamp((Instant)accessor.getLastFrozenTime()), accessor.getLatestFreezeRound(), (Bytes)Optional.ofNullable(accessor.getLegacyRunningEventHash()).map(Hash::getBytes).orElse(null));
    }

    @NonNull
    public static PlatformState toPbjPlatformState(@NonNull PlatformState previousState, @NonNull PlatformStateValueAccumulator accumulator) {
        Objects.requireNonNull(accumulator);
        PlatformState.Builder builder = previousState.copyBuilder();
        if (accumulator.isCreationSoftwareVersionUpdated()) {
            builder.creationSoftwareVersion(accumulator.getCreationSoftwareVersion());
        }
        if (accumulator.isRoundsNonAncientUpdated()) {
            builder.roundsNonAncient(accumulator.getRoundsNonAncient());
        }
        ConsensusSnapshot.Builder consensusSnapshotBuilder = accumulator.isSnapshotUpdated() ? accumulator.getSnapshot().copyBuilder() : previousState.consensusSnapshotOrElse(ConsensusSnapshot.DEFAULT).copyBuilder();
        if (accumulator.isRoundUpdated()) {
            consensusSnapshotBuilder.round(accumulator.getRound());
        }
        if (accumulator.isConsensusTimestampUpdated()) {
            consensusSnapshotBuilder.consensusTimestamp(PbjConverters.toPbjTimestamp((Instant)accumulator.getConsensusTimestamp()));
        }
        builder.consensusSnapshot(consensusSnapshotBuilder);
        if (accumulator.isFreezeTimeUpdated()) {
            builder.freezeTime(PbjConverters.toPbjTimestamp((Instant)accumulator.getFreezeTime()));
        }
        if (accumulator.isLastFrozenTimeUpdated()) {
            builder.lastFrozenTime(PbjConverters.toPbjTimestamp((Instant)accumulator.getLastFrozenTime()));
        }
        if (accumulator.isLatestFreezeRoundUpdated()) {
            builder.latestFreezeRound(accumulator.getLatestFreezeRound());
        }
        if (accumulator.isLegacyRunningEventHashUpdated()) {
            if (accumulator.getLegacyRunningEventHash() == null) {
                builder.legacyRunningEventHash(Bytes.EMPTY);
            } else {
                builder.legacyRunningEventHash(accumulator.getLegacyRunningEventHash().getBytes());
            }
        }
        return builder.build();
    }

    private PbjConverter() {
    }
}

