/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

import java.util.Objects;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes48;
import org.hyperledger.besu.ethereum.rlp.RLPInput;
import org.hyperledger.besu.ethereum.rlp.RLPOutput;

public class KZGProof {
    final Bytes48 data;

    public KZGProof(Bytes48 data) {
        this.data = data;
    }

    public static KZGProof readFrom(RLPInput input) {
        Bytes48 bytes = input.readBytes48();
        return new KZGProof(bytes);
    }

    public void writeTo(RLPOutput out) {
        out.writeBytes((Bytes)this.data);
    }

    public Bytes48 getData() {
        return this.data;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KZGProof kzgProof = (KZGProof)o;
        return Objects.equals(this.getData(), kzgProof.getData());
    }

    public int hashCode() {
        return Objects.hash(this.getData());
    }
}

