/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.state;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.node.app.service.contract.impl.state.AbstractMutableEvmAccount;
import com.hedera.node.app.service.contract.impl.state.DispatchingEvmFrameState;
import com.hedera.node.app.service.contract.impl.state.EvmFrameState;
import edu.umd.cs.findbugs.annotations.NonNull;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.units.bigints.UInt256;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;

public abstract class AbstractProxyEvmAccount
extends AbstractMutableEvmAccount {
    protected final AccountID accountID;
    protected final EvmFrameState state;

    protected AbstractProxyEvmAccount(AccountID accountID, @NonNull EvmFrameState state) {
        this.accountID = accountID;
        this.state = state;
    }

    public Address getAddress() {
        return this.state.getAddress(this.accountID);
    }

    @Override
    public Account toNativeAccount() {
        return this.state.getNativeAccount(this.accountID);
    }

    public long getNonce() {
        return this.state.getNonce(this.accountID);
    }

    public Wei getBalance() {
        return this.state.getBalance(this.accountID);
    }

    @NonNull
    public UInt256 getStorageValue(@NonNull UInt256 key) {
        return this.state.getStorageValue(this.hederaContractId(), key);
    }

    @NonNull
    public UInt256 getOriginalStorageValue(@NonNull UInt256 key) {
        return this.state.getOriginalStorageValue(this.hederaContractId(), key);
    }

    public void setNonce(long value) {
        this.state.setNonce(this.accountID.accountNumOrThrow(), value);
    }

    public void setCode(@NonNull Bytes code) {
        this.state.setCode(this.hederaContractId(), code);
    }

    public void setStorageValue(@NonNull UInt256 key, @NonNull UInt256 value) {
        this.state.setStorageValue(this.hederaContractId(), key, value);
    }

    @Override
    public boolean isTokenFacade() {
        return false;
    }

    @Override
    public boolean isRegularAccount() {
        return !this.isContract();
    }

    @Override
    public boolean isScheduleTxnFacade() {
        return false;
    }

    @Override
    @NonNull
    public AccountID hederaId() {
        return this.accountID;
    }

    @Override
    @NonNull
    public ContractID hederaContractId() {
        return ContractID.newBuilder().shardNum(this.accountID.shardNum()).realmNum(this.accountID.realmNum()).contractNum(this.accountID.accountNumOrThrow().longValue()).build();
    }

    public void becomeImmutable() {
        throw new UnsupportedOperationException("Not Implemented Yet");
    }

    public boolean isStorageEmpty() {
        com.hedera.pbj.runtime.io.buffer.Bytes key = this.state.getNativeAccount(this.accountID).firstContractStorageKey();
        return key.length() == 0L;
    }

    public int numTreasuryTitles() {
        return this.state.getNumTreasuryTitles(this.accountID);
    }

    public int numPositiveTokenBalances() {
        return this.state.getNumPositiveTokenBalances(this.accountID);
    }

    public boolean isContract() {
        return this.state.isContract(this.accountID);
    }

    public boolean isHollow() {
        return DispatchingEvmFrameState.HOLLOW_ACCOUNT_KEY.equals((Object)this.toNativeAccount().key());
    }
}

