/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.calculator;

import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.contract.ContractUpdateTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.spi.fees.FeeContext;
import com.hedera.node.app.spi.fees.ServiceFeeCalculator;
import com.hedera.node.app.spi.fees.SimpleFeeCalculatorImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.hapi.fees.FeeResult;
import org.hiero.hapi.fees.FeeScheduleUtils;
import org.hiero.hapi.support.fees.Extra;
import org.hiero.hapi.support.fees.FeeSchedule;
import org.hiero.hapi.support.fees.ServiceFeeDefinition;

public class ContractUpdateFeeCalculator
implements ServiceFeeCalculator {
    public void accumulateServiceFee(@NonNull TransactionBody txnBody, @Nullable FeeContext feeContext, @NonNull FeeResult feeResult, @NonNull FeeSchedule feeSchedule) {
        ContractUpdateTransactionBody op = txnBody.contractUpdateInstanceOrThrow();
        Key adminKey = op.adminKey();
        long keys = adminKey != null ? SimpleFeeCalculatorImpl.countKeys((Key)adminKey) : 0L;
        ServiceFeeDefinition serviceDef = FeeScheduleUtils.lookupServiceFee((FeeSchedule)feeSchedule, (HederaFunctionality)HederaFunctionality.CONTRACT_UPDATE);
        feeResult.setServiceBaseFeeTinycents(serviceDef.baseFee());
        this.addExtraFee(feeResult, serviceDef, Extra.KEYS, feeSchedule, keys);
        if (!op.hookCreationDetails().isEmpty()) {
            this.addExtraFee(feeResult, serviceDef, Extra.HOOK_UPDATES, feeSchedule, op.hookCreationDetails().size());
        }
        if (!op.hookIdsToDelete().isEmpty()) {
            this.addExtraFee(feeResult, serviceDef, Extra.HOOK_UPDATES, feeSchedule, op.hookIdsToDelete().size());
        }
    }

    public TransactionBody.DataOneOfType getTransactionType() {
        return TransactionBody.DataOneOfType.CONTRACT_UPDATE_INSTANCE;
    }
}

