/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.consensus;

import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.platform.consensus.LocalConsensusGeneration;
import com.swirlds.platform.internal.EventImpl;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Instant;
import java.util.List;
import org.hiero.base.utility.ArrayUtils;

public class ConsensusSorter {
    private final byte[] whitening;

    private ConsensusSorter(@NonNull byte[] whitening) {
        this.whitening = whitening;
    }

    public static void sort(@NonNull List<EventImpl> events, @NonNull byte[] whitening) {
        LocalConsensusGeneration.assignCGen(events);
        events.sort(new ConsensusSorter(whitening)::compare);
        LocalConsensusGeneration.clearCGen(events);
    }

    private int compare(@NonNull EventImpl e1, @NonNull EventImpl e2) {
        int c = e1.getPreliminaryConsensusTimestamp().compareTo(e2.getPreliminaryConsensusTimestamp());
        if (c != 0) {
            return c;
        }
        List<Instant> recTimes1 = e1.getRecTimes();
        List<Instant> recTimes2 = e2.getRecTimes();
        int m1 = recTimes1.size() / 2;
        int m2 = recTimes2.size() / 2;
        int d = -1;
        while (m1 + d >= 0 && m2 + d >= 0 && m1 + d < recTimes1.size() && m2 + d < recTimes2.size()) {
            c = recTimes1.get(m1 + d).compareTo(recTimes2.get(m2 + d));
            if (c != 0) {
                return c;
            }
            d = d < 0 ? -d : -d - 1;
        }
        c = Long.compare(e1.getCGen(), e2.getCGen());
        if (c != 0) {
            return c;
        }
        return ArrayUtils.arrayCompare((Bytes)e1.getBaseHash().getBytes(), (Bytes)e2.getBaseHash().getBytes(), (byte[])this.whitening);
    }
}

