/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.event.creator.impl.tipset;

import com.hedera.hapi.node.state.roster.Roster;
import com.swirlds.base.time.Time;
import com.swirlds.base.utility.Pair;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.security.SecureRandom;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.util.Supplier;
import org.hiero.base.crypto.BytesSigner;
import org.hiero.consensus.concurrent.utility.throttle.RateLimitedLogger;
import org.hiero.consensus.crypto.PbjStreamHasher;
import org.hiero.consensus.event.creator.config.EventCreationConfig;
import org.hiero.consensus.event.creator.impl.EventCreator;
import org.hiero.consensus.event.creator.impl.tipset.ChildlessEventTracker;
import org.hiero.consensus.event.creator.impl.tipset.Tipset;
import org.hiero.consensus.event.creator.impl.tipset.TipsetAdvancementWeight;
import org.hiero.consensus.event.creator.impl.tipset.TipsetMetrics;
import org.hiero.consensus.event.creator.impl.tipset.TipsetTracker;
import org.hiero.consensus.event.creator.impl.tipset.TipsetWeightCalculator;
import org.hiero.consensus.model.event.EventDescriptorWrapper;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.event.UnsignedEvent;
import org.hiero.consensus.model.hashgraph.EventWindow;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.quiescence.QuiescenceCommand;
import org.hiero.consensus.model.transaction.EventTransactionSupplier;
import org.hiero.consensus.model.transaction.TimestampedTransaction;
import org.hiero.consensus.roster.RosterUtils;

public class TipsetEventCreator
implements EventCreator {
    private static final Logger logger = LogManager.getLogger(TipsetEventCreator.class);
    private final Time time;
    private final SecureRandom random;
    private final BytesSigner signer;
    private final NodeId selfId;
    private final TipsetTracker tipsetTracker;
    private final TipsetWeightCalculator tipsetWeightCalculator;
    private final ChildlessEventTracker childlessOtherEventTracker;
    private final EventTransactionSupplier transactionSupplier;
    private final int maxOtherParents;
    private EventWindow eventWindow;
    private Instant lastReceivedEventWindow;
    private final Roster roster;
    private final int networkSize;
    private final double antiSelfishnessFactor;
    private final TipsetMetrics tipsetMetrics;
    private PlatformEvent lastSelfEvent;
    private final RateLimitedLogger zeroAdvancementWeightLogger;
    private final RateLimitedLogger noParentFoundLogger;
    private final PbjStreamHasher eventHasher;
    private QuiescenceCommand quiescenceCommand = QuiescenceCommand.DONT_QUIESCE;
    private boolean breakQuiescenceEventCreated;

    public TipsetEventCreator(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull SecureRandom random, @NonNull BytesSigner signer, @NonNull Roster roster, @NonNull NodeId selfId, @NonNull EventTransactionSupplier transactionSupplier) {
        this.time = Objects.requireNonNull(time);
        this.random = Objects.requireNonNull(random);
        this.signer = Objects.requireNonNull(signer);
        this.selfId = Objects.requireNonNull(selfId);
        this.transactionSupplier = Objects.requireNonNull(transactionSupplier);
        this.roster = Objects.requireNonNull(roster);
        EventCreationConfig eventCreationConfig = (EventCreationConfig)configuration.getConfigData(EventCreationConfig.class);
        this.antiSelfishnessFactor = Math.max(1.0, eventCreationConfig.antiSelfishnessFactor());
        this.tipsetMetrics = new TipsetMetrics(metrics, roster);
        this.tipsetTracker = new TipsetTracker(time, selfId, roster);
        this.childlessOtherEventTracker = new ChildlessEventTracker();
        this.tipsetWeightCalculator = new TipsetWeightCalculator(configuration, time, roster, selfId, this.tipsetTracker, this.childlessOtherEventTracker);
        this.networkSize = roster.rosterEntries().size();
        this.zeroAdvancementWeightLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.noParentFoundLogger = new RateLimitedLogger(logger, time, Duration.ofMinutes(1L));
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.lastReceivedEventWindow = time.now();
        this.eventHasher = new PbjStreamHasher();
        this.maxOtherParents = eventCreationConfig.maxOtherParents();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void registerEvent(@NonNull PlatformEvent event) {
        if (this.eventWindow.isAncient(event)) {
            return;
        }
        NodeId eventCreator = event.getCreatorId();
        if (RosterUtils.getIndex((Roster)this.roster, (long)eventCreator.id()) == -1) {
            return;
        }
        boolean selfEvent = eventCreator.equals((Object)this.selfId);
        if (selfEvent) {
            if (this.lastSelfEvent != null && (!this.lastSelfEvent.hasNGen() || this.lastSelfEvent.getNGen() >= event.getNGen())) return;
            this.lastSelfEvent = event;
            this.childlessOtherEventTracker.registerSelfEventParents(event.getOtherParents());
            this.tipsetTracker.addSelfEvent(event.getDescriptor(), event.getAllParents());
            return;
        } else {
            this.tipsetTracker.addPeerEvent(event);
            this.childlessOtherEventTracker.addEvent(event);
        }
    }

    @Override
    public void setEventWindow(@NonNull EventWindow eventWindow) {
        this.eventWindow = Objects.requireNonNull(eventWindow);
        this.lastReceivedEventWindow = this.time.now();
        this.tipsetTracker.setEventWindow(eventWindow);
        this.childlessOtherEventTracker.pruneOldEvents(eventWindow);
    }

    @Override
    public void quiescenceCommand(@NonNull QuiescenceCommand quiescenceCommand) {
        this.quiescenceCommand = Objects.requireNonNull(quiescenceCommand);
    }

    @Override
    @Nullable
    public PlatformEvent maybeCreateEvent() {
        if (this.quiescenceCommand == QuiescenceCommand.QUIESCE) {
            return null;
        }
        UnsignedEvent event = this.maybeCreateUnsignedEvent();
        if (event != null) {
            this.breakQuiescenceEventCreated = false;
        } else if (this.quiescenceCommand == QuiescenceCommand.BREAK_QUIESCENCE && !this.breakQuiescenceEventCreated) {
            event = this.createQuiescenceBreakEvent();
            this.breakQuiescenceEventCreated = true;
            Supplier[] supplierArray = new Supplier[1];
            supplierArray[0] = () -> ((EventDescriptorWrapper)event.getDescriptor()).shortString();
            logger.info(LogMarker.STARTUP.getMarker(), "Created quiescence breaking event ({})", supplierArray);
        }
        if (event != null) {
            this.lastSelfEvent = this.signEvent(event);
            return this.lastSelfEvent;
        }
        return null;
    }

    private UnsignedEvent createQuiescenceBreakEvent() {
        return this.buildAndProcessEvent(new PlatformEvent[0]);
    }

    @Nullable
    private UnsignedEvent maybeCreateUnsignedEvent() {
        if (this.networkSize == 1) {
            return this.buildAndProcessEvent(new PlatformEvent[0]);
        }
        return this.createEventCombinedAlgorithm();
    }

    private PlatformEvent signEvent(UnsignedEvent event) {
        return new PlatformEvent(event, this.signer.sign(event.getHash().getBytes()));
    }

    @Nullable
    private UnsignedEvent createEventCombinedAlgorithm() {
        PlatformEvent selflessParent;
        ArrayList<PlatformEvent> possibleOtherParents = new ArrayList<PlatformEvent>(this.childlessOtherEventTracker.getChildlessEvents());
        Collections.shuffle(possibleOtherParents, this.random);
        List<PlatformEvent> bestParents = possibleOtherParents.stream().map(op -> {
            ArrayList<EventDescriptorWrapper> parents = new ArrayList<EventDescriptorWrapper>(2);
            parents.add(op.getDescriptor());
            if (this.lastSelfEvent != null) {
                parents.add(this.lastSelfEvent.getDescriptor());
            }
            return new Pair(op, (Object)this.tipsetWeightCalculator.getTheoreticalAdvancementWeight(parents));
        }).filter(p -> ((TipsetAdvancementWeight)p.right()).isNonZero()).sorted(Comparator.comparing(Pair::right)).map(Pair::left).toList();
        PlatformEvent[] chosenBestParents = bestParents.size() > this.maxOtherParents ? bestParents.subList(bestParents.size() - this.maxOtherParents, bestParents.size()).toArray(new PlatformEvent[0]) : bestParents.toArray(new PlatformEvent[0]);
        if (chosenBestParents.length == 0) {
            if (!this.eventWindow.isGenesis() || this.lastSelfEvent != null) {
                return null;
            }
            return this.buildAndProcessEvent(new PlatformEvent[0]);
        }
        long selfishness = this.tipsetWeightCalculator.getMaxSelfishnessScore();
        this.tipsetMetrics.getSelfishnessMetric().update((double)selfishness);
        double beNiceChance = (double)(selfishness - 1L) / this.antiSelfishnessFactor;
        boolean replacedBestParentForSelfishness = false;
        if (beNiceChance > 0.0 && this.random.nextDouble() < beNiceChance && !TipsetEventCreator.contains(chosenBestParents, selflessParent = this.selectParentToReduceSelfishness())) {
            chosenBestParents[chosenBestParents.length - 1] = selflessParent;
            replacedBestParentForSelfishness = true;
        }
        for (int i = 0; i < chosenBestParents.length; ++i) {
            if (replacedBestParentForSelfishness && i == chosenBestParents.length - 1) {
                this.tipsetMetrics.getPityParentMetric(chosenBestParents[i].getCreatorId()).cycle();
                continue;
            }
            this.tipsetMetrics.getTipsetParentMetric(chosenBestParents[i].getCreatorId()).cycle();
        }
        return this.buildAndProcessEvent(chosenBestParents);
    }

    private static <T> boolean contains(@NonNull T[] array, @NonNull T element) {
        for (T entry : array) {
            if (!element.equals(entry)) continue;
            return true;
        }
        return false;
    }

    @NonNull
    private PlatformEvent selectParentToReduceSelfishness() {
        Collection<PlatformEvent> possibleOtherParents = this.childlessOtherEventTracker.getChildlessEvents();
        ArrayList<PlatformEvent> ignoredNodes = new ArrayList<PlatformEvent>(possibleOtherParents.size());
        int selfishnessSum = 0;
        ArrayList<Integer> selfishnessScores = new ArrayList<Integer>(possibleOtherParents.size());
        for (PlatformEvent possibleIgnoredNode : possibleOtherParents) {
            int selfishness = this.tipsetWeightCalculator.getSelfishnessScoreForNode(possibleIgnoredNode.getCreatorId());
            ArrayList<EventDescriptorWrapper> theoreticalParents = new ArrayList<EventDescriptorWrapper>(2);
            theoreticalParents.add(possibleIgnoredNode.getDescriptor());
            if (this.lastSelfEvent == null) {
                throw new IllegalStateException("lastSelfEvent is null");
            }
            theoreticalParents.add(this.lastSelfEvent.getDescriptor());
            TipsetAdvancementWeight advancementWeight = this.tipsetWeightCalculator.getTheoreticalAdvancementWeight(theoreticalParents);
            if (selfishness <= 1) continue;
            if (advancementWeight.isNonZero()) {
                ignoredNodes.add(possibleIgnoredNode);
                selfishnessScores.add(selfishness);
                selfishnessSum += selfishness;
                continue;
            }
            this.zeroAdvancementWeightLogger.error(LogMarker.EXCEPTION.getMarker(), "selfishness score is {} but advancement score is zero for {}.\n{}", new Object[]{selfishness, possibleIgnoredNode, this});
        }
        if (ignoredNodes.isEmpty()) {
            this.noParentFoundLogger.error(LogMarker.EXCEPTION.getMarker(), "failed to locate eligible ignored node to use as a parent", new Object[0]);
            return null;
        }
        int choice = this.random.nextInt(selfishnessSum);
        int runningSum = 0;
        for (int i = 0; i < ignoredNodes.size(); ++i) {
            if (choice >= (runningSum += ((Integer)selfishnessScores.get(i)).intValue())) continue;
            PlatformEvent ignoredNode = (PlatformEvent)ignoredNodes.get(i);
            return ignoredNode;
        }
        throw new IllegalStateException("Failed to find an other parent");
    }

    private UnsignedEvent buildAndProcessEvent(PlatformEvent ... otherParents) {
        List<Object> otherParentDescriptors = otherParents.length == 0 ? List.of() : Arrays.stream(otherParents).map(PlatformEvent::getDescriptor).toList();
        UnsignedEvent event = this.assembleEventObject(otherParents);
        this.tipsetTracker.addSelfEvent(event.getDescriptor(), event.getMetadata().getAllParents());
        TipsetAdvancementWeight advancementWeight = this.tipsetWeightCalculator.addEventAndGetAdvancementWeight(event.getDescriptor());
        double weightRatio = (double)advancementWeight.advancementWeight() / (double)this.tipsetWeightCalculator.getMaximumPossibleAdvancementWeight();
        this.tipsetMetrics.getTipsetAdvancementMetric().update(weightRatio);
        this.childlessOtherEventTracker.registerSelfEventParents(otherParentDescriptors);
        return event;
    }

    @NonNull
    private UnsignedEvent assembleEventObject(PlatformEvent ... otherParents) {
        List transactions = this.transactionSupplier.getTransactionsForEvent();
        List<PlatformEvent> allParents = Stream.concat(Stream.of(this.lastSelfEvent), Stream.of(otherParents)).filter(Objects::nonNull).toList();
        List<EventDescriptorWrapper> allParentDescriptors = allParents.stream().map(PlatformEvent::getDescriptor).toList();
        UnsignedEvent event = new UnsignedEvent(this.selfId, allParentDescriptors, this.eventWindow.newEventBirthRound(), this.calculateNewEventCreationTime(this.lastSelfEvent, allParents, transactions), transactions.stream().map(TimestampedTransaction::transaction).toList(), this.random.nextLong(0L, this.roster.rosterEntries().size() + 1));
        this.eventHasher.hashUnsignedEvent(event);
        return event;
    }

    @Override
    public void clear() {
        this.tipsetTracker.clear();
        this.childlessOtherEventTracker.clear();
        this.tipsetWeightCalculator.clear();
        this.eventWindow = EventWindow.getGenesisEventWindow();
        this.lastSelfEvent = null;
    }

    @NonNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Event window: ").append(this.tipsetTracker.getEventWindow()).append("\n");
        sb.append("Latest self event: ").append(this.lastSelfEvent).append("\n");
        sb.append(this.tipsetWeightCalculator);
        sb.append("Childless events:");
        Collection<PlatformEvent> childlessEvents = this.childlessOtherEventTracker.getChildlessEvents();
        if (childlessEvents.isEmpty()) {
            sb.append(" none\n");
        } else {
            sb.append("\n");
            for (PlatformEvent event : childlessEvents) {
                Tipset tipset = this.tipsetTracker.getTipset(event.getDescriptor());
                sb.append("  - ").append(event).append(" ").append(tipset).append("\n");
            }
        }
        return sb.toString();
    }

    @NonNull
    private Instant calculateNewEventCreationTime(@Nullable PlatformEvent selfParent, @NonNull List<PlatformEvent> allParents, @NonNull List<TimestampedTransaction> transactions) {
        Instant maxReceivedTime = Stream.of(allParents.stream().map(PlatformEvent::getTimeReceived), transactions.stream().map(TimestampedTransaction::receivedTime), Stream.of(this.lastReceivedEventWindow)).flatMap(Function.identity()).max(Instant::compareTo).orElse(this.time.now());
        if (selfParent != null && !maxReceivedTime.isAfter(selfParent.getTimeCreated())) {
            return selfParent.getTimeCreated().plus(Duration.ofNanos(1L));
        }
        return maxReceivedTime;
    }
}

