/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.entityid.impl;

import com.hedera.hapi.node.state.common.EntityNumber;
import com.hedera.hapi.node.state.entity.EntityCounts;
import com.hedera.node.app.hapi.utils.EntityType;
import com.hedera.node.app.service.entityid.WritableEntityIdStore;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.entityid.impl.schemas.V0490EntityIdSchema;
import com.hedera.node.app.service.entityid.impl.schemas.V0590EntityIdSchema;
import com.swirlds.state.spi.ReadableStates;
import com.swirlds.state.spi.WritableSingletonState;
import com.swirlds.state.spi.WritableStates;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class WritableEntityIdStoreImpl
extends ReadableEntityIdStoreImpl
implements WritableEntityIdStore {
    private final WritableSingletonState<EntityNumber> entityIdState;
    private final WritableSingletonState<EntityCounts> entityCountsState;

    public WritableEntityIdStoreImpl(@NonNull WritableStates states) {
        super((ReadableStates)states);
        Objects.requireNonNull(states);
        this.entityIdState = states.getSingleton(V0490EntityIdSchema.ENTITY_ID_STATE_ID);
        this.entityCountsState = states.getSingleton(V0590EntityIdSchema.ENTITY_COUNTS_STATE_ID);
    }

    @Override
    public long peekAtNextNumber() {
        EntityNumber oldEntityNum = (EntityNumber)this.entityIdState.get();
        return oldEntityNum == null ? 1L : oldEntityNum.number() + 1L;
    }

    public long incrementAndGet() {
        long newEntityNum = this.peekAtNextNumber();
        this.entityIdState.put((Object)new EntityNumber(newEntityNum));
        return newEntityNum;
    }

    public void incrementEntityTypeCount(EntityType entityType) {
        this.adjustEntityCount(entityType, 1L);
    }

    public void adjustEntityCount(EntityType entityType, long delta) {
        EntityCounts entityCounts = Objects.requireNonNull((EntityCounts)this.entityCountsState.get());
        EntityCounts.Builder newEntityCounts = entityCounts.copyBuilder();
        switch (entityType) {
            case ACCOUNT: {
                newEntityCounts.numAccounts(entityCounts.numAccounts() + delta);
                break;
            }
            case ALIAS: {
                newEntityCounts.numAliases(entityCounts.numAliases() + delta);
                break;
            }
            case TOKEN: {
                newEntityCounts.numTokens(entityCounts.numTokens() + delta);
                break;
            }
            case TOKEN_ASSOCIATION: {
                newEntityCounts.numTokenRelations(entityCounts.numTokenRelations() + delta);
                break;
            }
            case TOPIC: {
                newEntityCounts.numTopics(entityCounts.numTopics() + delta);
                break;
            }
            case FILE: {
                newEntityCounts.numFiles(entityCounts.numFiles() + delta);
                break;
            }
            case CONTRACT_BYTECODE: {
                newEntityCounts.numContractBytecodes(entityCounts.numContractBytecodes() + delta);
                break;
            }
            case CONTRACT_STORAGE: {
                newEntityCounts.numContractStorageSlots(entityCounts.numContractStorageSlots() + delta);
                break;
            }
            case NFT: {
                newEntityCounts.numNfts(entityCounts.numNfts() + delta);
                break;
            }
            case SCHEDULE: {
                newEntityCounts.numSchedules(entityCounts.numSchedules() + delta);
                break;
            }
            case AIRDROP: {
                newEntityCounts.numAirdrops(entityCounts.numAirdrops() + delta);
                break;
            }
            case NODE: {
                newEntityCounts.numNodes(entityCounts.numNodes() + delta);
                break;
            }
            case STAKING_INFO: {
                newEntityCounts.numStakingInfos(entityCounts.numStakingInfos() + delta);
                break;
            }
            case HOOK: {
                newEntityCounts.numHooks(entityCounts.numHooks() + delta);
                break;
            }
            case LAMBDA_STORAGE: {
                newEntityCounts.numLambdaStorageSlots(entityCounts.numLambdaStorageSlots() + delta);
            }
        }
        this.entityCountsState.put((Object)newEntityCounts.build());
    }

    public void decrementEntityTypeCounter(EntityType entityType) {
        this.adjustEntityCount(entityType, -1L);
    }
}

