/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.atomic.AtomicReference;
import javax.annotation.Nullable;
import org.apache.tuweni.bytes.Bytes;
import org.hyperledger.besu.evm.code.CodeSection;
import org.hyperledger.besu.evm.code.OpcodeInfo;

public record EOFLayout(Bytes container, int version, CodeSection[] codeSections, EOFLayout[] subContainers, int dataLength, Bytes data, String invalidReason, AtomicReference<EOFContainerMode> containerMode) {
    public static final byte EOF_PREFIX_BYTE = -17;
    static final int SECTION_TERMINATOR = 0;
    static final int SECTION_TYPES = 1;
    static final int SECTION_CODE = 2;
    static final int SECTION_CONTAINER = 3;
    static final int SECTION_DATA = 4;
    static final int MAX_SUPPORTED_VERSION = 1;

    private EOFLayout(Bytes container, int version, CodeSection[] codeSections, EOFLayout[] containers, int dataSize, Bytes data) {
        this(container, version, codeSections, containers, dataSize, data, null, new AtomicReference<Object>(null));
    }

    private EOFLayout(Bytes container, int version, String invalidReason) {
        this(container, version, new CodeSection[0], new EOFLayout[0], 0, Bytes.EMPTY, invalidReason, new AtomicReference<Object>(null));
    }

    private static EOFLayout invalidLayout(Bytes container, int version, String invalidReason) {
        return new EOFLayout(container, version, invalidReason);
    }

    private static String readKind(ByteArrayInputStream inputStream, int expectedKind) {
        int kind = inputStream.read();
        if (kind == -1) {
            return "missing_headers_terminator Improper section headers";
        }
        if (kind != expectedKind) {
            return "unexpected_header_kind expected " + expectedKind + " actual " + kind;
        }
        return null;
    }

    private static int peekKind(ByteArrayInputStream inputStream) {
        inputStream.mark(1);
        int kind = inputStream.read();
        inputStream.reset();
        return kind;
    }

    public static EOFLayout parseEOF(Bytes container) {
        return EOFLayout.parseEOF(container, true);
    }

    public static EOFLayout parseEOF(Bytes container, boolean strictSize) {
        ArrayDeque<EOFParseStep> parseQueue = new ArrayDeque<EOFParseStep>();
        parseQueue.add(new EOFParseStep(container, strictSize, -1, null, null));
        EOFLayout result = null;
        do {
            EOFParseStep step = (EOFParseStep)parseQueue.remove();
            EOFLayout parsedContainer = EOFLayout.parseEOF(step, parseQueue);
            if (result == null) {
                result = parsedContainer;
            }
            if (!parsedContainer.isValid()) {
                return EOFLayout.invalidLayout(container, result.version, (String)(step.index == -1 ? parsedContainer.invalidReason : "Invalid subcontainer " + step.subcontainerIndex() + " - " + parsedContainer.invalidReason));
            }
            if ((strictSize || result != parsedContainer) && step.container.size() != parsedContainer.container.size()) {
                return EOFLayout.invalidLayout(container, parsedContainer.version, "invalid_section_bodies_size subcontainer size mismatch");
            }
            if (step.index < 0) continue;
            step.parentSubcontainers[step.index] = parsedContainer;
        } while (!parseQueue.isEmpty());
        return result;
    }

    private static EOFLayout parseEOF(EOFParseStep step, Queue<EOFParseStep> queue) {
        Bytes completeContainer;
        int[] containerSectionSizes;
        int containerSectionCount;
        ByteArrayInputStream inputStream = new ByteArrayInputStream(step.container.toArrayUnsafe());
        if (inputStream.available() < 3) {
            return EOFLayout.invalidLayout(step.container, -1, "invalid_magic EOF Container too small");
        }
        if (inputStream.read() != 239) {
            return EOFLayout.invalidLayout(step.container, -1, "invalid_magic EOF header byte 0 incorrect");
        }
        if (inputStream.read() != 0) {
            return EOFLayout.invalidLayout(step.container, -1, "invalid_magic EOF header byte 1 incorrect");
        }
        int version = inputStream.read();
        if (version > 1 || version < 1) {
            return EOFLayout.invalidLayout(step.container, version, "invalid_version " + version);
        }
        String error = EOFLayout.readKind(inputStream, 1);
        if (error != null) {
            return EOFLayout.invalidLayout(step.container, version, error);
        }
        int typesLength = EOFLayout.readUnsignedShort(inputStream);
        if (typesLength % 4 != 0) {
            return EOFLayout.invalidLayout(step.container, version, "invalid_type_section_size Invalid Types section size (mod 4 != 0)");
        }
        error = EOFLayout.readKind(inputStream, 2);
        if (error != null) {
            return EOFLayout.invalidLayout(step.container, version, error);
        }
        int codeSectionCount = EOFLayout.readUnsignedShort(inputStream);
        if (codeSectionCount <= 0) {
            return EOFLayout.invalidLayout(step.container, version, "incomplete_section_number Too few code sections");
        }
        if (codeSectionCount > 1024) {
            return EOFLayout.invalidLayout(step.container, version, "too_many_code_sections - 0x" + Integer.toHexString(codeSectionCount));
        }
        if (codeSectionCount * 4 != typesLength) {
            return EOFLayout.invalidLayout(step.container, version, "invalid_section_bodies_size Type section - 0x" + Integer.toHexString(codeSectionCount) + " * 4 != 0x" + Integer.toHexString(typesLength));
        }
        int[] codeSectionSizes = new int[codeSectionCount];
        for (int i = 0; i < codeSectionCount; ++i) {
            int size = EOFLayout.readUnsignedShort(inputStream);
            if (size <= 0) {
                return EOFLayout.invalidLayout(step.container, version, "zero_section_size code " + i);
            }
            codeSectionSizes[i] = size;
        }
        if (EOFLayout.peekKind(inputStream) == 3) {
            error = EOFLayout.readKind(inputStream, 3);
            if (error != null) {
                return EOFLayout.invalidLayout(step.container, version, error);
            }
            containerSectionCount = EOFLayout.readUnsignedShort(inputStream);
            if (containerSectionCount <= 0) {
                return EOFLayout.invalidLayout(step.container, version, "Invalid container section count");
            }
            if (containerSectionCount > 256) {
                return EOFLayout.invalidLayout(step.container, version, "too_many_containers sections - 0x" + Integer.toHexString(containerSectionCount));
            }
            containerSectionSizes = new int[containerSectionCount];
            for (int i = 0; i < containerSectionCount; ++i) {
                int size = EOFLayout.readUnsignedShort(inputStream);
                if (size <= 0) {
                    return EOFLayout.invalidLayout(step.container, version, "Invalid container section size for section " + i);
                }
                containerSectionSizes[i] = size;
            }
        } else {
            containerSectionCount = 0;
            containerSectionSizes = new int[]{};
        }
        if ((error = EOFLayout.readKind(inputStream, 4)) != null) {
            return EOFLayout.invalidLayout(step.container, version, error);
        }
        int dataSize = EOFLayout.readUnsignedShort(inputStream);
        if (dataSize < 0) {
            return EOFLayout.invalidLayout(step.container, version, "incomplete_data_header");
        }
        error = EOFLayout.readKind(inputStream, 0);
        if (error != null) {
            return EOFLayout.invalidLayout(step.container, version, error);
        }
        int[][] typeData = new int[codeSectionCount][3];
        for (int i = 0; i < codeSectionCount; ++i) {
            typeData[i][0] = inputStream.read();
            typeData[i][1] = inputStream.read();
            typeData[i][2] = EOFLayout.readUnsignedShort(inputStream);
        }
        if (typeData[codeSectionCount - 1][2] == -1) {
            return EOFLayout.invalidLayout(step.container, version, "invalid_section_bodies_size Incomplete type section");
        }
        if (typeData[0][0] != 0 || (typeData[0][1] & 0x7F) != 0) {
            return EOFLayout.invalidLayout(step.container, version, "invalid_first_section_type must be zero input non-returning");
        }
        CodeSection[] codeSections = new CodeSection[codeSectionCount];
        int pos = 9 + codeSectionCount * 2 + 3 + 1 + codeSectionCount * 4;
        if (containerSectionCount > 0) {
            pos += 3 + containerSectionCount * 2;
        }
        for (int i = 0; i < codeSectionCount; ++i) {
            int codeSectionSize = codeSectionSizes[i];
            if (inputStream.skip(codeSectionSize) != (long)codeSectionSize) {
                return EOFLayout.invalidLayout(step.container, version, "invalid_section_bodies_size code section " + i);
            }
            if (typeData[i][0] > 127) {
                return EOFLayout.invalidLayout(step.container, version, "inputs_outputs_num_above_limit Type data input stack too large - 0x" + Integer.toHexString(typeData[i][0]));
            }
            if (typeData[i][1] > 128) {
                return EOFLayout.invalidLayout(step.container, version, "inputs_outputs_num_above_limit - 0x" + Integer.toHexString(typeData[i][1]));
            }
            if (typeData[i][2] > 1023) {
                return EOFLayout.invalidLayout(step.container, version, "max_stack_height_above_limit Type data max stack too large - 0x" + Integer.toHexString(typeData[i][2]));
            }
            codeSections[i] = new CodeSection(codeSectionSize, typeData[i][0], typeData[i][1], typeData[i][2], pos);
            if (i == 0 && typeData[0][1] != 128) {
                return EOFLayout.invalidLayout(step.container, version, "invalid_first_section_type want 0x80 (non-returning flag) has " + typeData[0][1]);
            }
            pos += codeSectionSize;
        }
        EOFLayout[] subContainers = new EOFLayout[containerSectionCount];
        for (int i = 0; i < containerSectionCount; ++i) {
            int subcontainerSize = containerSectionSizes[i];
            if ((long)subcontainerSize != inputStream.skip(subcontainerSize)) {
                return EOFLayout.invalidLayout(step.container, version, "invalid_section_bodies_size");
            }
            Bytes subcontainer = step.container.slice(pos, subcontainerSize);
            pos += subcontainerSize;
            queue.add(new EOFParseStep(subcontainer, false, i, step, subContainers));
        }
        long loadedDataCount = inputStream.skip(dataSize);
        Bytes data = step.container.slice(pos, (int)loadedDataCount);
        if (inputStream.read() != -1) {
            if (step.strictSize) {
                return EOFLayout.invalidLayout(step.container, version, "invalid_section_bodies_size data after end of all sections");
            }
            completeContainer = step.container.slice(0, pos + dataSize);
        } else {
            completeContainer = step.container;
        }
        if (step.strictSize && dataSize != data.size()) {
            return EOFLayout.invalidLayout(step.container, version, "toplevel_container_truncated Truncated data section when a complete section was required");
        }
        return new EOFLayout(completeContainer, version, codeSections, subContainers, dataSize, data);
    }

    static int readUnsignedShort(ByteArrayInputStream inputStream) {
        if (inputStream.available() < 2) {
            return -1;
        }
        return inputStream.read() << 8 | inputStream.read();
    }

    public int getCodeSectionCount() {
        return this.codeSections == null ? 0 : this.codeSections.length;
    }

    public CodeSection getCodeSection(int i) {
        return this.codeSections[i];
    }

    public int getSubcontainerCount() {
        return this.subContainers == null ? 0 : this.subContainers.length;
    }

    public EOFLayout getSubcontainer(int i) {
        return this.subContainers[i];
    }

    public int indexOfSubcontainer(EOFLayout container) {
        return Arrays.asList(this.subContainers).indexOf(container);
    }

    public boolean isValid() {
        return this.invalidReason == null;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof EOFLayout)) {
            return false;
        }
        EOFLayout eofLayout = (EOFLayout)o;
        return this.version == eofLayout.version && this.container.equals((Object)eofLayout.container) && Arrays.equals(this.codeSections, eofLayout.codeSections) && Arrays.equals(this.subContainers, eofLayout.subContainers) && Objects.equals(this.invalidReason, eofLayout.invalidReason);
    }

    @Override
    public int hashCode() {
        int result = Objects.hash(this.container, this.version, this.invalidReason);
        result = 31 * result + Arrays.hashCode(this.codeSections);
        result = 31 * result + Arrays.hashCode(this.subContainers);
        return result;
    }

    @Override
    public String toString() {
        return "EOFLayout{container=" + String.valueOf(this.container) + ", version=" + this.version + ", codeSections=" + (this.codeSections == null ? "null" : Arrays.asList(this.codeSections).toString()) + ", containers=" + (this.subContainers == null ? "null" : Arrays.asList(this.subContainers).toString()) + ", invalidReason='" + this.invalidReason + "'}";
    }

    @Nullable
    public Bytes writeContainer(@Nullable Bytes auxData) {
        if (this.invalidReason != null) {
            return null;
        }
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(this.container.size() + this.dataLength - this.data.size());
            DataOutputStream out = new DataOutputStream(baos);
            out.writeByte(-17);
            out.writeByte(0);
            out.writeByte(this.version);
            out.writeByte(1);
            out.writeShort(this.codeSections.length * 4);
            out.writeByte(2);
            out.writeShort(this.codeSections.length);
            for (CodeSection codeSection : this.codeSections) {
                out.writeShort(codeSection.length);
            }
            if (this.subContainers != null && this.subContainers.length > 0) {
                out.writeByte(3);
                out.writeShort(this.subContainers.length);
                for (EOFLayout eOFLayout : this.subContainers) {
                    out.writeShort(eOFLayout.container.size());
                }
            }
            out.writeByte(4);
            if (auxData == null) {
                out.writeShort(this.dataLength);
            } else {
                int newSize = this.data.size() + auxData.size();
                if (newSize < this.dataLength) {
                    return null;
                }
                out.writeShort(newSize);
            }
            out.writeByte(0);
            for (CodeSection codeSection : this.codeSections) {
                out.writeByte(codeSection.inputs);
                if (codeSection.returning) {
                    out.writeByte(codeSection.outputs);
                } else {
                    out.writeByte(128);
                }
                out.writeShort(codeSection.maxStackHeight);
            }
            for (CodeSection codeSection : this.codeSections) {
                out.write(this.container.slice(codeSection.entryPoint, codeSection.length).toArray());
            }
            if (this.subContainers != null) {
                for (EOFLayout eOFLayout : this.subContainers) {
                    out.write(eOFLayout.container.toArrayUnsafe());
                }
            }
            out.write(this.data.toArrayUnsafe());
            if (auxData != null) {
                out.write(auxData.toArrayUnsafe());
            }
            return Bytes.wrap((byte[])baos.toByteArray());
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    public String prettyPrint() {
        StringWriter sw = new StringWriter();
        this.prettyPrint(new PrintWriter((Writer)sw, true), "", "");
        return sw.toString();
    }

    public void prettyPrint(PrintWriter out) {
        out.println("0x # EOF");
        this.prettyPrint(out, "", "");
    }

    public void prettyPrint(PrintWriter out, String prefix, String subcontainerPrefix) {
        CodeSection cs;
        int i;
        if (!this.isValid()) {
            out.print(prefix);
            out.println("# Invalid EOF");
            out.print(prefix);
            out.println("# " + this.invalidReason);
            out.println(this.container);
        }
        out.print(prefix);
        out.printf("ef00%02x # Magic and Version ( %1$d )%n", this.version);
        out.print(prefix);
        out.printf("01%04x # Types length ( %1$d )%n", this.codeSections.length * 4);
        out.print(prefix);
        out.printf("02%04x # Total code sections ( %1$d )%n", this.codeSections.length);
        for (i = 0; i < this.codeSections.length; ++i) {
            out.print(prefix);
            out.printf("  %04x # Code section %d , %1$d bytes%n", this.getCodeSection(i).getLength(), i);
        }
        if (this.subContainers.length > 0) {
            out.print(prefix);
            out.printf("03%04x # Total subcontainers ( %1$d )%n", this.subContainers.length);
            for (i = 0; i < this.subContainers.length; ++i) {
                out.print(prefix);
                out.printf("  %04x # Sub container %d, %1$d byte%n", this.subContainers[i].container.size(), i);
            }
        }
        out.print(prefix);
        out.printf("04%04x # Data section length(  %1$d )", this.dataLength);
        if (this.dataLength != this.data.size()) {
            out.printf(" (actual size %d)", this.data.size());
        }
        out.print(prefix);
        out.printf("%n", new Object[0]);
        out.print(prefix);
        out.printf("    00 # Terminator (end of header)%n", new Object[0]);
        for (i = 0; i < this.codeSections.length; ++i) {
            cs = this.getCodeSection(i);
            out.print(prefix);
            out.printf("       # Code section %d types%n", i);
            out.print(prefix);
            out.printf("    %02x # %1$d inputs %n", cs.getInputs());
            out.print(prefix);
            out.printf("    %02x # %d outputs %s%n", cs.isReturning() ? cs.getOutputs() : 128, cs.getOutputs(), cs.isReturning() ? "" : " (Non-returning function)");
            out.print(prefix);
            out.printf("  %04x # max stack:  %1$d%n", cs.getMaxStackHeight());
        }
        for (i = 0; i < this.codeSections.length; ++i) {
            cs = this.getCodeSection(i);
            out.print(prefix);
            out.printf("       # Code section %d - in=%d out=%s height=%d%n", i, cs.inputs, cs.isReturning() ? Integer.valueOf(cs.outputs) : "non-returning", cs.maxStackHeight);
            byte[] byteCode = this.container.slice(cs.getEntryPoint(), cs.getLength()).toArray();
            int pc = 0;
            while (pc < byteCode.length) {
                int j;
                out.print(prefix);
                OpcodeInfo ci = OpcodeInfo.V1_OPCODES[byteCode[pc] & 0xFF];
                if (ci.opcode() == 226) {
                    int j2;
                    if (byteCode.length <= pc + 1) {
                        out.printf("    %02x # [%d] %s(<truncated instruction>)%n", byteCode[pc], pc, ci.name());
                        ++pc;
                        continue;
                    }
                    int tableSize = byteCode[pc + 1] & 0xFF;
                    out.printf("%02x%02x", byteCode[pc], byteCode[pc + 1]);
                    int calculatedTableEnd = pc + tableSize * 2 + 4;
                    int lastTableEntry = Math.min(byteCode.length, calculatedTableEnd);
                    for (j2 = pc + 2; j2 < lastTableEntry; ++j2) {
                        out.printf("%02x", byteCode[j2]);
                    }
                    out.printf(" # [%d] %s(", pc, ci.name());
                    for (j2 = pc + 3; j2 < lastTableEntry; j2 += 2) {
                        if (j2 != pc + 3) {
                            out.print(',');
                        }
                        byte b0 = byteCode[j2 - 1];
                        int b1 = byteCode[j2] & 0xFF;
                        out.print(b0 << 8 | b1);
                    }
                    if (byteCode.length < calculatedTableEnd) {
                        out.print("<truncated immediate>");
                    }
                    pc += tableSize * 2 + 4;
                    out.print(")\n");
                    continue;
                }
                if (ci.opcode() == 224 || ci.opcode() == 225) {
                    if (pc + 1 >= byteCode.length) {
                        out.printf("    %02x # [%d] %s(<truncated immediate>)", byteCode[pc], pc, ci.name());
                    } else if (pc + 2 >= byteCode.length) {
                        out.printf("  %02x%02x # [%d] %s(<truncated immediate>)", byteCode[pc], byteCode[pc + 1], pc, ci.name());
                    } else {
                        int b0 = byteCode[pc + 1] & 0xFF;
                        int b1 = byteCode[pc + 2] & 0xFF;
                        short delta = (short)(b0 << 8 | b1);
                        out.printf("%02x%02x%02x # [%d] %s(%d)", byteCode[pc], b0, b1, pc, ci.name(), delta);
                    }
                    pc += 3;
                    out.printf("%n", new Object[0]);
                    continue;
                }
                if (ci.opcode() == 232) {
                    if (pc + 1 >= byteCode.length) {
                        out.printf("    %02x # [%d] %s(<truncated immediate>)", byteCode[pc], pc, ci.name());
                    } else {
                        int imm = byteCode[pc + 1] & 0xFF;
                        out.printf("  %02x%02x # [%d] %s(%d, %d)", byteCode[pc], imm, pc, ci.name(), imm >> 4, imm & 0xF);
                    }
                    pc += 2;
                    out.printf("%n", new Object[0]);
                    continue;
                }
                int advance = ci.pcAdvance();
                if (advance == 1) {
                    out.print("    ");
                } else if (advance == 2) {
                    out.print("  ");
                }
                out.printf("%02x", byteCode[pc]);
                for (j = 1; j < advance && pc + j < byteCode.length; ++j) {
                    out.printf("%02x", byteCode[pc + j]);
                }
                out.printf(" # [%d] %s", pc, ci.name());
                if (advance == 2) {
                    if (byteCode.length <= pc + 1) {
                        out.print("(<truncated immediate>)");
                    } else {
                        out.printf("(%d)", byteCode[pc + 1] & 0xFF);
                    }
                } else if (advance > 2) {
                    out.print("(0x");
                    for (j = 1; j < advance && pc + j < byteCode.length; ++j) {
                        out.printf("%02x", byteCode[pc + j]);
                    }
                    if (pc + advance >= byteCode.length) {
                        out.print(" <truncated immediate>");
                    }
                    out.print(")");
                }
                out.printf("%n", new Object[0]);
                pc += advance;
            }
        }
        for (i = 0; i < this.subContainers.length; ++i) {
            EOFLayout subContainer = this.subContainers[i];
            out.print(prefix);
            out.printf("           # Subcontainer %s%d starts here%n", subcontainerPrefix, i);
            subContainer.prettyPrint(out, prefix + "    ", subcontainerPrefix + i + ".");
            out.print(prefix);
            out.printf("           # Subcontainer %s%d ends%n", subcontainerPrefix, i);
        }
        out.print(prefix);
        if (this.data.isEmpty()) {
            out.print("       # Data section (empty)\n");
        } else {
            out.printf("  # Data section length ( %1$d )", this.dataLength);
            if (this.dataLength != this.data.size()) {
                out.printf(" actual length ( %d )", this.data.size());
            }
            out.printf("%n%s  %s%n", prefix, this.data.toUnprefixedHexString());
        }
        out.flush();
    }

    private record EOFParseStep(Bytes container, boolean strictSize, int index, EOFParseStep parent, EOFLayout[] parentSubcontainers) {
        String subcontainerIndex() {
            if (this.index < 0) {
                return "";
            }
            StringBuilder version = new StringBuilder();
            EOFParseStep current = this;
            while (current != null) {
                EOFParseStep prev = current.parent;
                if (prev == null) {
                    version.insert(0, this.index);
                    break;
                }
                version.insert(0, '.');
                version.insert(1, current.index);
                current = prev;
            }
            return version.toString();
        }
    }

    public static enum EOFContainerMode {
        UNKNOWN,
        INITCODE,
        RUNTIME;

    }
}

