/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform;

import com.swirlds.metrics.api.Counter;
import com.swirlds.metrics.api.LongAccumulator;
import com.swirlds.metrics.api.MetricConfig;
import com.swirlds.metrics.api.Metrics;
import org.hiero.consensus.metrics.RunningAverageMetric;
import org.hiero.consensus.metrics.SpeedometerMetric;

public final class CryptoMetrics {
    private static final String CATEGORY = "crypto";
    private static final RunningAverageMetric.Config AVG_DIGEST_QUEUE_DEPTH_CONFIG = new RunningAverageMetric.Config("crypto", "DigQuDepth").withDescription("average digest queue depth").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_QUEUE_DEPTH_CONFIG = new RunningAverageMetric.Config("crypto", "SigQuDepth").withDescription("average signature queue depth").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_DIGEST_BATCH_SIZE_CONFIG = new RunningAverageMetric.Config("crypto", "DigBatchSz").withDescription("average digest batch size").withFormat("%,11.3f");
    private static final LongAccumulator.Config MIN_DIGEST_BATCH_SIZE_CONFIG = new LongAccumulator.Config("crypto", "MinDigBatchSz").withAccumulator(Math::min).withDescription("minimum digest batch size").withInitialValue(Long.MAX_VALUE);
    private static final LongAccumulator.Config MAX_DIGEST_BATCH_SIZE_CONFIG = new LongAccumulator.Config("crypto", "MaxDigBatchSz").withDescription("maximum digest batch size").withInitialValue(Long.MIN_VALUE);
    private static final RunningAverageMetric.Config AVG_SIG_BATCH_SIZE_CONFIG = new RunningAverageMetric.Config("crypto", "SigBatchSz").withDescription("average signature batch size").withFormat("%,11.3f");
    private static final LongAccumulator.Config MIN_SIG_BATCH_SIZE_CONFIG = new LongAccumulator.Config("crypto", "MinSigBatchSz").withAccumulator(Math::min).withDescription("minimum signature batch size").withFormat("%,d").withInitialValue(Long.MAX_VALUE);
    private static final LongAccumulator.Config MAX_SIG_BATCH_SIZE_CONFIG = new LongAccumulator.Config("crypto", "MaxSigBatchSz").withDescription("maximum signature batch size").withFormat("%,d").withInitialValue(Long.MIN_VALUE);
    private static final SpeedometerMetric.Config DIG_WORK_PULSE_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "DigPulse_per_sec").withDescription("average digest worker pulses per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config DIG_LOCK_UPGRADES_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "DigLockUp_per_sec").withDescription("average digest lock upgrades per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config DIG_SPANS_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "DigSpans_per_sec").withDescription("average: digest batch spans per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config DIG_BATCHES_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "DigBatches_per_sec").withDescription("average: digest batches created per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config DIG_PER_SEC_CONFIG = new SpeedometerMetric.Config("crypto", "Dig_per_sec").withDescription("number of digests per second (complete)").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_WORK_PULSE_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "SigPulse_per_sec").withDescription("average Signature worker pulses per second").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_DIGEST_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "DigWrkTime").withDescription("average: time spent (in millis) in digest worker pulses").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "SigWrkTime").withDescription("average: time spent (in millis) in signature worker pulses").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_DIGEST_WORK_ITEM_SUBMIT_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "DigSubWrkItmTime").withDescription("average: time spent (in millis) in digest submission").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_WORK_ITEM_SUBMIT_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "SigSubWrkItmTime").withDescription("average: time spent (in millis) in signature verification submission").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_LOCK_UPGRADES_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "SigLockUp_per_sec").withDescription("average Signature lock upgrades per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_SPANS_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "SigSpans_per_sec").withDescription("average: signature verification batch spans per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_BATCHES_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "SigBatches_per_sec").withDescription("average: signature verification batches created per second").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_DIGEST_SLICE_SIZE_CONFIG = new RunningAverageMetric.Config("crypto", "DigSliceSz").withDescription("average digest slice size").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_SLICE_SIZE_CONFIG = new RunningAverageMetric.Config("crypto", "SigSliceSz").withDescription("average signature slice size").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_PER_SEC_CONFIG = new SpeedometerMetric.Config("crypto", "Sig_per_sec").withDescription("number of signature verifications per second (complete)").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_VALID_PER_SEC_CONFIG = new SpeedometerMetric.Config("crypto", "SigVal_per_sec").withDescription("number of valid signatures per second").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_INVALID_PER_SEC_CONFIG = new SpeedometerMetric.Config("crypto", "SigInval_per_sec").withDescription("number of invalid signatures per second").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_INTAKE_QUEUE_DEPTH_CONFIG = new RunningAverageMetric.Config("crypto", "SigIntakeQueueDepth").withDescription("depth of the signature intake queue").withFormat("%,11.3f");
    private static final SpeedometerMetric.Config SIG_INTAKE_PULSE_PER_SECOND_CONFIG = new SpeedometerMetric.Config("crypto", "SigIntakePulse_per_sec").withDescription("number of times the signature intake worker thread is executed per second").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_INTAKE_PULSE_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "SigIntakePulseTime").withDescription("average time spent (in millis) of each signature intake execution").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_INTAKE_ENQUEUE_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "SigIntakeEnqueueTime").withDescription("average time spent (in millis) of each intake enqueue call").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_SIG_INTAKE_LIST_SIZE_CONFIG = new RunningAverageMetric.Config("crypto", "SigIntakeListSize").withDescription("average size of each list sent to the intake worker").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_PLATFORM_ENQUEUE_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "PlatSigEnqueueTime").withDescription("average time spent (in millis) by the platform enqueuing signatures").withFormat("%,11.3f");
    private static final RunningAverageMetric.Config AVG_PLATFORM_EXPAND_TIME_CONFIG = new RunningAverageMetric.Config("crypto", "PlatSigExpandTime").withDescription("average time spent (in millis) by the platform calling the expandSignatures method").withFormat("%,11.3f");
    private static final Counter.Config TOTAL_DIGESTS_CONFIG = new Counter.Config("crypto", "TtlDig").withDescription("running total: digests computed");
    private static final Counter.Config TOTAL_SIG_CONFIG = new Counter.Config("crypto", "TtlSig").withDescription("running total: Signatures Verified");
    private static final Counter.Config TOTAL_SIG_VALID_CONFIG = new Counter.Config("crypto", "TtlSigVal").withDescription("running total: valid signatures verified");
    private static final Counter.Config TOTAL_SIG_INVALID_CONFIG = new Counter.Config("crypto", "TtlSigInval").withDescription("running total: invalid signatures verified");
    private final RunningAverageMetric avgDigestQueueDepth;
    private final RunningAverageMetric avgDigestBatchSize;
    private final SpeedometerMetric digWorkPulsePerSecond;
    private final RunningAverageMetric avgDigestTime;
    private final RunningAverageMetric avgDigestWorkItemSubmitTime;
    private final SpeedometerMetric digLockUpgradesPerSecond;
    private final SpeedometerMetric digSpansPerSecond;
    private final SpeedometerMetric digBatchesPerSecond;
    private final RunningAverageMetric avgDigestSliceSize;
    private final SpeedometerMetric digPerSec;
    private final Counter totalDigests;
    private final LongAccumulator minDigestBatchSize;
    private final LongAccumulator maxDigestBatchSize;
    private final RunningAverageMetric avgSigQueueDepth;
    private final RunningAverageMetric avgSigBatchSize;
    private final SpeedometerMetric sigWorkPulsePerSecond;
    private final RunningAverageMetric avgSigTime;
    private final RunningAverageMetric avgSigWorkItemSubmitTime;
    private final SpeedometerMetric sigLockUpgradesPerSecond;
    private final SpeedometerMetric sigSpansPerSecond;
    private final SpeedometerMetric sigBatchesPerSecond;
    private final RunningAverageMetric avgSigSliceSize;
    private final SpeedometerMetric sigPerSec;
    private final SpeedometerMetric sigValidPerSec;
    private final SpeedometerMetric sigInvalidPerSec;
    private final RunningAverageMetric avgSigIntakeQueueDepth;
    private final SpeedometerMetric sigIntakePulsePerSecond;
    private final RunningAverageMetric avgSigIntakePulseTime;
    private final RunningAverageMetric avgSigIntakeEnqueueTime;
    private final RunningAverageMetric avgSigIntakeListSize;
    private final RunningAverageMetric avgPlatformEnqueueTime;
    private final RunningAverageMetric avgPlatformExpandTime;
    private final Counter totalSig;
    private final Counter totalSigValid;
    private final Counter totalSigInvalid;
    private final LongAccumulator minSigBatchSize;
    private final LongAccumulator maxSigBatchSize;
    private static volatile CryptoMetrics instance;
    private static boolean isRecording;
    private static volatile Metrics metrics;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static CryptoMetrics getInstance() {
        if (instance != null) return instance;
        Class<CryptoMetrics> clazz = CryptoMetrics.class;
        synchronized (CryptoMetrics.class) {
            if (instance != null) return instance;
            instance = new CryptoMetrics();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public static void registerMetrics(Metrics metrics) {
        CryptoMetrics.metrics = metrics;
        CryptoMetrics.getInstance();
    }

    private CryptoMetrics() {
        if (metrics == null) {
            throw new IllegalStateException("Metrics has not been set");
        }
        this.avgDigestQueueDepth = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DIGEST_QUEUE_DEPTH_CONFIG);
        this.avgSigQueueDepth = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_QUEUE_DEPTH_CONFIG);
        this.avgDigestBatchSize = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DIGEST_BATCH_SIZE_CONFIG);
        this.minDigestBatchSize = (LongAccumulator)metrics.getOrCreate((MetricConfig)MIN_DIGEST_BATCH_SIZE_CONFIG);
        this.maxDigestBatchSize = (LongAccumulator)metrics.getOrCreate((MetricConfig)MAX_DIGEST_BATCH_SIZE_CONFIG);
        this.avgSigBatchSize = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_BATCH_SIZE_CONFIG);
        this.minSigBatchSize = (LongAccumulator)metrics.getOrCreate((MetricConfig)MIN_SIG_BATCH_SIZE_CONFIG);
        this.maxSigBatchSize = (LongAccumulator)metrics.getOrCreate((MetricConfig)MAX_SIG_BATCH_SIZE_CONFIG);
        this.digWorkPulsePerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)DIG_WORK_PULSE_PER_SECOND_CONFIG);
        this.digLockUpgradesPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)DIG_LOCK_UPGRADES_PER_SECOND_CONFIG);
        this.digSpansPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)DIG_SPANS_PER_SECOND_CONFIG);
        this.digBatchesPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)DIG_BATCHES_PER_SECOND_CONFIG);
        this.digPerSec = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)DIG_PER_SEC_CONFIG);
        this.sigWorkPulsePerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_WORK_PULSE_PER_SECOND_CONFIG);
        this.avgDigestTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DIGEST_TIME_CONFIG);
        this.avgSigTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_TIME_CONFIG);
        this.avgDigestWorkItemSubmitTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DIGEST_WORK_ITEM_SUBMIT_TIME_CONFIG);
        this.avgSigWorkItemSubmitTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_WORK_ITEM_SUBMIT_TIME_CONFIG);
        this.sigLockUpgradesPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_LOCK_UPGRADES_PER_SECOND_CONFIG);
        this.sigSpansPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_SPANS_PER_SECOND_CONFIG);
        this.sigBatchesPerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_BATCHES_PER_SECOND_CONFIG);
        this.avgDigestSliceSize = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_DIGEST_SLICE_SIZE_CONFIG);
        this.avgSigSliceSize = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_SLICE_SIZE_CONFIG);
        this.sigPerSec = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_PER_SEC_CONFIG);
        this.sigValidPerSec = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_VALID_PER_SEC_CONFIG);
        this.sigInvalidPerSec = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_INVALID_PER_SEC_CONFIG);
        this.avgSigIntakeQueueDepth = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_INTAKE_QUEUE_DEPTH_CONFIG);
        this.sigIntakePulsePerSecond = (SpeedometerMetric)metrics.getOrCreate((MetricConfig)SIG_INTAKE_PULSE_PER_SECOND_CONFIG);
        this.avgSigIntakePulseTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_INTAKE_PULSE_TIME_CONFIG);
        this.avgSigIntakeEnqueueTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_INTAKE_ENQUEUE_TIME_CONFIG);
        this.avgSigIntakeListSize = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_SIG_INTAKE_LIST_SIZE_CONFIG);
        this.avgPlatformEnqueueTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_PLATFORM_ENQUEUE_TIME_CONFIG);
        this.avgPlatformExpandTime = (RunningAverageMetric)metrics.getOrCreate((MetricConfig)AVG_PLATFORM_EXPAND_TIME_CONFIG);
        this.totalDigests = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_DIGESTS_CONFIG);
        this.totalSig = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_SIG_CONFIG);
        this.totalSigValid = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_SIG_VALID_CONFIG);
        this.totalSigInvalid = (Counter)metrics.getOrCreate((MetricConfig)TOTAL_SIG_INVALID_CONFIG);
    }

    static void startRecording() {
        if (!isRecording) {
            isRecording = true;
        }
    }

    public static boolean recordingStatus() {
        return isRecording;
    }

    public void setSigIntakeWorkerValues(int queueDepth, double workerTime, int listSize) {
        this.sigIntakePulsePerSecond.cycle();
        this.avgSigIntakeQueueDepth.update((double)queueDepth);
        this.avgSigIntakePulseTime.update(workerTime);
        this.avgSigIntakeListSize.update((double)listSize);
    }

    public void setSigIntakeEnqueueValues(double enqueueTime) {
        this.avgSigIntakeEnqueueTime.update(enqueueTime);
    }

    public void setPlatformSigIntakeValues(double enqueueTime, double expandTime) {
        this.avgPlatformEnqueueTime.update(enqueueTime);
        this.avgPlatformExpandTime.update(expandTime);
    }

    private void setDigestWorkerValues(long digestQueueDepth, long digestBatchSize, double time) {
        this.avgDigestQueueDepth.update((double)digestQueueDepth);
        this.avgDigestBatchSize.update((double)digestBatchSize);
        this.digWorkPulsePerSecond.cycle();
        this.avgDigestTime.update(time);
        this.minDigestBatchSize.update(digestBatchSize);
        this.maxDigestBatchSize.update(digestBatchSize);
    }

    private void setSigWorkerValues(long sigQueueDepth, long sigBatchSize, double time) {
        this.avgSigQueueDepth.update((double)sigQueueDepth);
        this.avgSigBatchSize.update((double)sigBatchSize);
        this.sigWorkPulsePerSecond.cycle();
        this.avgSigTime.update(time);
        this.minSigBatchSize.update(sigBatchSize);
        this.maxSigBatchSize.update(sigBatchSize);
    }

    private void setSigSubmitWorkItem(double time, boolean lockUpgraded) {
        this.avgSigWorkItemSubmitTime.update(time);
        if (lockUpgraded) {
            this.sigLockUpgradesPerSecond.cycle();
        }
    }

    private void setDigestSubmitWorkItem(double time, boolean lockUpgraded) {
        this.avgDigestWorkItemSubmitTime.update(time);
        if (lockUpgraded) {
            this.digLockUpgradesPerSecond.cycle();
        }
    }

    public void setDigestHandleExecution(double sliceSize) {
        this.avgDigestSliceSize.update(sliceSize);
        this.digPerSec.cycle();
        this.totalDigests.increment();
    }

    public void setSigHandleExecution(double sliceSize, boolean isValid) {
        this.avgSigSliceSize.update(sliceSize);
        this.sigPerSec.cycle();
        this.totalSig.increment();
        if (isValid) {
            this.sigValidPerSec.cycle();
            this.totalSigValid.increment();
        } else {
            this.sigInvalidPerSec.cycle();
            this.totalSigInvalid.increment();
        }
    }

    static {
        isRecording = false;
    }
}

