/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.platform.cli;

import com.swirlds.cli.PlatformCli;
import com.swirlds.cli.utility.AbstractCommand;
import com.swirlds.cli.utility.SubcommandOf;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.stream.IntStream;
import picocli.CommandLine;

@CommandLine.Command(name="stats-to-prometheus", mixinStandardHelpOptions=true, description={"Converts list of stat CSV files to prometheus format"})
@SubcommandOf(value=PlatformCli.class)
public class StatsToPrometheusCommand
extends AbstractCommand {
    private List<Path> csvFiles;
    private BufferedReader lineReader;
    private String currentLine;
    private String[] firstHeaders;
    private String[] secondHeaders;
    private int timeIndex;
    private String sampleName;
    private Path output;
    private BufferedWriter outputFile;

    @CommandLine.Parameters(description={"The csv stat files to read"})
    private void setTestData(@NonNull List<Path> csvFiles) {
        this.csvFiles = csvFiles;
    }

    @CommandLine.Option(names={"-o", "--output-file"}, description={"Path to output file for resulting metrics"})
    private void setFile(@NonNull Path file) {
        this.output = file;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Integer call() throws Exception {
        this.outputFile = new BufferedWriter(new FileWriter(this.output.toFile(), StandardCharsets.UTF_8));
        try {
            for (Path csvFile : this.csvFiles) {
                System.out.println("Processing stat file: " + String.valueOf(csvFile));
                this.openFile(csvFile);
                try {
                    this.skipUselessHeaders();
                    this.readRealHeaders();
                    this.processDataLines();
                }
                finally {
                    this.lineReader.close();
                }
            }
            this.outputFile.write("# EOF\n");
        }
        finally {
            this.outputFile.close();
        }
        return 0;
    }

    private void openFile(Path csvFile) throws IOException {
        this.lineReader = new BufferedReader(new FileReader(csvFile.toFile(), StandardCharsets.UTF_8));
        this.sampleName = csvFile.getFileName().toString();
        this.sampleName = this.sampleName.substring(0, this.sampleName.lastIndexOf("."));
    }

    private void processDataLines() throws IOException {
        DateTimeFormatter dateFormat = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss 'UTC'");
        while (this.readLine() != null) {
            String[] values = this.currentLine.split(",");
            long epochSeconds = LocalDateTime.from(dateFormat.parse(values[this.timeIndex])).toEpochSecond(ZoneOffset.UTC);
            for (int i = 0; i < this.firstHeaders.length; ++i) {
                if (this.firstHeaders[i].isBlank() || i == this.timeIndex) continue;
                values[i] = this.replaceValue(values[i]);
                this.outputFile.write(this.escapeMetricName(this.firstHeaders[i] + "_" + this.secondHeaders[i]) + "{node=\"" + this.escapeMetricName(this.sampleName) + "\"} " + values[i] + " " + epochSeconds + "\n");
            }
        }
    }

    private String escapeMetricName(String metricName) {
        StringBuilder escapedMetricName = new StringBuilder(metricName.length());
        for (int i = 0; i < metricName.length(); ++i) {
            char c = metricName.charAt(i);
            if (c > '\u007f' || !Character.isAlphabetic(c) && !Character.isDigit(c)) {
                escapedMetricName.append("_");
                continue;
            }
            escapedMetricName.append(c);
        }
        return escapedMetricName.toString();
    }

    private String replaceValue(String value) {
        if ("true".equalsIgnoreCase(value)) {
            return "1";
        }
        if ("false".equalsIgnoreCase(value)) {
            return "0";
        }
        if (value == null) {
            return "0";
        }
        return value.trim();
    }

    private void readRealHeaders() throws IOException {
        this.firstHeaders = this.currentLine.split(",");
        this.secondHeaders = this.readLine().split(",");
        this.timeIndex = IntStream.range(0, this.secondHeaders.length).filter(i -> "time".equalsIgnoreCase(this.secondHeaders[i].trim())).findFirst().orElseThrow(() -> new IllegalArgumentException("No 'time' column found in second header line"));
    }

    private void skipUselessHeaders() throws IOException {
        do {
            this.readLine();
            if (this.currentLine != null) continue;
            throw new RuntimeException("File does not seem to be a stats file, missing a line starting with double comma (,,)");
        } while (!this.currentLine.startsWith(",,") || this.currentLine.isBlank());
    }

    private String readLine() throws IOException {
        this.currentLine = this.lineReader.readLine();
        return this.currentLine;
    }
}

