/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.deleteschedule;

import com.esaulpaugh.headlong.abi.Address;
import com.esaulpaugh.headlong.abi.Tuple;
import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.scheduled.ScheduleDeleteTransactionBody;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.service.contract.impl.exec.gas.DispatchType;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.scope.EitherOrVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.scope.SpecificCryptoVerificationStrategy;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCallTranslator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.DispatchForResponseCodeHssCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.hss.HssCallAttempt;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethod;
import com.hedera.node.app.service.contract.impl.exec.utils.SystemContractMethodRegistry;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import com.hedera.node.config.data.ContractsConfig;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
public class DeleteScheduleTranslator
extends AbstractCallTranslator<HssCallAttempt> {
    public static final SystemContractMethod DELETE_SCHEDULE = SystemContractMethod.declare("deleteSchedule(address)", "(int64)").withCategories(SystemContractMethod.Category.SCHEDULE);
    private static final int SCHEDULE_ADDRESS_INDEX = 0;
    public static final SystemContractMethod DELETE_SCHEDULE_PROXY = SystemContractMethod.declare("deleteSchedule()", "(int64)").withVia(SystemContractMethod.CallVia.PROXY).withCategories(SystemContractMethod.Category.SCHEDULE);

    @Inject
    public DeleteScheduleTranslator(@NonNull SystemContractMethodRegistry systemContractMethodRegistry, @NonNull ContractMetrics contractMetrics) {
        super(SystemContractMethod.SystemContract.HSS, systemContractMethodRegistry, contractMetrics);
        this.registerMethods(DELETE_SCHEDULE, DELETE_SCHEDULE_PROXY);
    }

    @Override
    @NonNull
    public Optional<SystemContractMethod> identifyMethod(@NonNull HssCallAttempt attempt) {
        if (((ContractsConfig)attempt.configuration().getConfigData(ContractsConfig.class)).systemContractScheduleCallEnabled()) {
            return attempt.isMethod(DELETE_SCHEDULE, DELETE_SCHEDULE_PROXY);
        }
        return Optional.empty();
    }

    @Override
    public Call callFrom(@NonNull HssCallAttempt attempt) {
        if (DeleteScheduleTranslator.isRedirectWithNonContractAdminKey(attempt)) {
            return new DispatchForResponseCodeHssCall(attempt, this.transactionBodyFor(this.scheduleIdFor(attempt)), DeleteScheduleTranslator.getCustomVerificationStrat(attempt), DeleteScheduleTranslator::gasRequirement, attempt.keySetFor());
        }
        return new DispatchForResponseCodeHssCall(attempt, this.transactionBodyFor(this.scheduleIdFor(attempt)), DeleteScheduleTranslator::gasRequirement, attempt.keySetFor());
    }

    @VisibleForTesting
    public TransactionBody transactionBodyFor(@NonNull ScheduleID scheduleId) {
        return TransactionBody.newBuilder().scheduleDelete(ScheduleDeleteTransactionBody.newBuilder().scheduleID(scheduleId).build()).build();
    }

    @VisibleForTesting
    public ScheduleID scheduleIdFor(@NonNull HssCallAttempt attempt) {
        Objects.requireNonNull(attempt);
        if (attempt.isSelector(DELETE_SCHEDULE)) {
            Tuple call = DELETE_SCHEDULE.decodeCall(attempt.inputBytes());
            Address scheduleAddress = (Address)call.get(0);
            return ConversionUtils.addressToScheduleID(attempt.nativeOperations().entityIdFactory(), scheduleAddress);
        }
        if (attempt.isSelector(DELETE_SCHEDULE_PROXY)) {
            return attempt.redirectScheduleId();
        }
        throw new IllegalStateException("Unexpected function selector");
    }

    public static long gasRequirement(@NonNull TransactionBody body, @NonNull SystemContractGasCalculator systemContractGasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @NonNull AccountID payerId) {
        return systemContractGasCalculator.gasRequirement(body, DispatchType.SCHEDULE_DELETE, payerId);
    }

    private static boolean isRedirectWithNonContractAdminKey(@NonNull HssCallAttempt attempt) {
        return attempt.isSelector(DELETE_SCHEDULE_PROXY) && attempt.isRedirect() && attempt.redirectScheduleTxn() != null && attempt.redirectScheduleTxn().adminKey() != null && !attempt.redirectScheduleTxn().adminKey().hasContractID();
    }

    @NonNull
    private static EitherOrVerificationStrategy getCustomVerificationStrat(@NonNull HssCallAttempt attempt) {
        return new EitherOrVerificationStrategy(attempt.defaultVerificationStrategy(), new SpecificCryptoVerificationStrategy(attempt.redirectScheduleTxn().adminKeyOrElse(Key.DEFAULT)));
    }
}

