/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.v065;

import com.hedera.node.app.service.contract.impl.annotations.CustomOps;
import com.hedera.node.app.service.contract.impl.annotations.ServicesV065;
import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.FrameRunner;
import com.hedera.node.app.service.contract.impl.exec.TransactionProcessor;
import com.hedera.node.app.service.contract.impl.exec.gas.CustomGasCharging;
import com.hedera.node.app.service.contract.impl.exec.metrics.ContractMetrics;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomBalanceOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCallCodeOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCallOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomChainIdOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCreate2Operation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomCreateOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomDelegateCallOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeCopyOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeHashOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomExtCodeSizeOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomLogOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomPrevRandaoOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSLoadOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSStoreOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomSelfDestructOperation;
import com.hedera.node.app.service.contract.impl.exec.operations.CustomStaticCallOperation;
import com.hedera.node.app.service.contract.impl.exec.processors.CustomContractCreationProcessor;
import com.hedera.node.app.service.contract.impl.exec.processors.CustomMessageCallProcessor;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HederaSystemContract;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameBuilder;
import com.hedera.node.app.service.contract.impl.exec.v038.Version038AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.v065.Version065FeatureFlags;
import com.hedera.node.app.service.contract.impl.hevm.HederaEVM;
import dagger.Binds;
import dagger.Module;
import dagger.Provides;
import dagger.multibindings.IntoSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.math.BigInteger;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Singleton;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.EvmSpecVersion;
import org.hyperledger.besu.evm.MainnetEVMs;
import org.hyperledger.besu.evm.code.CodeFactory;
import org.hyperledger.besu.evm.contractvalidation.ContractValidationRule;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.EvmConfiguration;
import org.hyperledger.besu.evm.operation.Operation;
import org.hyperledger.besu.evm.operation.OperationRegistry;
import org.hyperledger.besu.evm.operation.SLoadOperation;
import org.hyperledger.besu.evm.operation.SStoreOperation;
import org.hyperledger.besu.evm.precompile.KZGPointEvalPrecompiledContract;
import org.hyperledger.besu.evm.precompile.MainnetPrecompiledContracts;
import org.hyperledger.besu.evm.precompile.PrecompileContractRegistry;
import org.hyperledger.besu.evm.processor.ContractCreationProcessor;

@Module
public interface V065Module {
    private static void oneTimeEVMModuleInitialization() {
        KZGPointEvalPrecompiledContract.init();
    }

    @Provides
    @Singleton
    @ServicesV065
    public static TransactionProcessor provideTransactionProcessor(@NonNull FrameBuilder frameBuilder, @NonNull FrameRunner frameRunner, @ServicesV065 @NonNull CustomMessageCallProcessor messageCallProcessor, @ServicesV065 @NonNull ContractCreationProcessor contractCreationProcessor, @NonNull CustomGasCharging gasCharging, @ServicesV065 @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        return new TransactionProcessor(frameBuilder, frameRunner, gasCharging, messageCallProcessor, contractCreationProcessor, featureFlags, codeFactory);
    }

    @Provides
    @Singleton
    @ServicesV065
    public static ContractCreationProcessor provideContractCreationProcessor(@ServicesV065 @NonNull EVM evm, @NonNull Set<ContractValidationRule> validationRules) {
        return new CustomContractCreationProcessor(evm, true, List.copyOf(validationRules), 1L);
    }

    @Provides
    @Singleton
    @ServicesV065
    public static CustomMessageCallProcessor provideMessageCallProcessor(@ServicesV065 @NonNull EVM evm, @ServicesV065 @NonNull FeatureFlags featureFlags, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull PrecompileContractRegistry registry, @NonNull Map<Address, HederaSystemContract> systemContracts, @NonNull ContractMetrics contractMetrics) {
        return new CustomMessageCallProcessor(evm, featureFlags, registry, addressChecks, systemContracts, contractMetrics);
    }

    @Provides
    @Singleton
    @ServicesV065
    public static EVM provideEVM(@ServicesV065 @NonNull Set<Operation> customOperations, @NonNull EvmConfiguration evmConfiguration, @NonNull GasCalculator gasCalculator, @CustomOps @NonNull Set<Operation> customOps) {
        V065Module.oneTimeEVMModuleInitialization();
        OperationRegistry operationRegistry = new OperationRegistry();
        MainnetEVMs.registerCancunOperations((OperationRegistry)operationRegistry, (GasCalculator)gasCalculator, (BigInteger)BigInteger.ZERO);
        customOperations.forEach(arg_0 -> ((OperationRegistry)operationRegistry).put(arg_0));
        customOps.forEach(arg_0 -> ((OperationRegistry)operationRegistry).put(arg_0));
        return new HederaEVM(operationRegistry, gasCalculator, evmConfiguration, EvmSpecVersion.CANCUN);
    }

    @Provides
    @Singleton
    @ServicesV065
    public static PrecompileContractRegistry providePrecompileContractRegistry(@NonNull GasCalculator gasCalculator) {
        PrecompileContractRegistry precompileContractRegistry = new PrecompileContractRegistry();
        MainnetPrecompiledContracts.populateForCancun((PrecompileContractRegistry)precompileContractRegistry, (GasCalculator)gasCalculator);
        return precompileContractRegistry;
    }

    @Binds
    @ServicesV065
    public FeatureFlags bindFeatureFlags(Version065FeatureFlags var1);

    @Binds
    @ServicesV065
    public AddressChecks bindAddressChecks(Version038AddressChecks var1);

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideBalanceOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomBalanceOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideDelegateCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomDelegateCallOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideCallCodeOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomCallCodeOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideStaticCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomStaticCallOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideCallOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull FeatureFlags featureFlags, @ServicesV065 @NonNull AddressChecks addressChecks) {
        return new CustomCallOperation(featureFlags, gasCalculator, addressChecks);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideChainIdOperation(@NonNull GasCalculator gasCalculator) {
        return new CustomChainIdOperation(gasCalculator);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideCreateOperation(@NonNull GasCalculator gasCalculator, @NonNull CodeFactory codeFactory) {
        return new CustomCreateOperation(gasCalculator, codeFactory);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideCreate2Operation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull FeatureFlags featureFlags, @NonNull CodeFactory codeFactory) {
        return new CustomCreate2Operation(gasCalculator, featureFlags, codeFactory);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideLog0Operation(@NonNull GasCalculator gasCalculator) {
        return new CustomLogOperation(0, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideLog1Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(1, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideLog2Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(2, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideLog3Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(3, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideLog4Operation(GasCalculator gasCalculator) {
        return new CustomLogOperation(4, gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideExtCodeHashOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeHashOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideExtCodeSizeOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeSizeOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideExtCodeCopyOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomExtCodeCopyOperation(gasCalculator, addressChecks, featureFlags);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation providePrevRandaoOperation(@NonNull GasCalculator gasCalculator) {
        return new CustomPrevRandaoOperation(gasCalculator);
    }

    @Provides
    @Singleton
    @IntoSet
    @ServicesV065
    public static Operation provideSelfDestructOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull AddressChecks addressChecks) {
        return new CustomSelfDestructOperation(gasCalculator, addressChecks, CustomSelfDestructOperation.UseEIP6780Semantics.YES);
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideSLoadOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomSLoadOperation(featureFlags, new SLoadOperation(gasCalculator));
    }

    @Provides
    @IntoSet
    @ServicesV065
    public static Operation provideSStoreOperation(@NonNull GasCalculator gasCalculator, @ServicesV065 @NonNull FeatureFlags featureFlags) {
        return new CustomSStoreOperation(featureFlags, new SStoreOperation(gasCalculator, 0L));
    }
}

