/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.throttles;

public class DiscreteLeakyBucket {
    private long used;
    private final long nominalCapacity;
    private final long brimfulCapacity;

    public static DiscreteLeakyBucket ofFixedCapacity(long capacity) {
        return new DiscreteLeakyBucket(capacity, capacity);
    }

    public static DiscreteLeakyBucket ofNominalAndBrimfulCapacity(long nominalCapacity, long brimfulCapacity) {
        return new DiscreteLeakyBucket(nominalCapacity, brimfulCapacity);
    }

    private DiscreteLeakyBucket(long nominalCapacity, long brimfulCapacity) {
        DiscreteLeakyBucket.assertArgument(nominalCapacity >= 0L, "nominalCapacity must be >= 0");
        DiscreteLeakyBucket.assertArgument(brimfulCapacity >= 0L, "brimfulCapacity must be >= 0");
        DiscreteLeakyBucket.assertArgument(brimfulCapacity >= nominalCapacity, "brimfulCapacity must be >= nominalCapacity");
        this.used = 0L;
        this.nominalCapacity = nominalCapacity;
        this.brimfulCapacity = brimfulCapacity;
    }

    public long nominalCapacityFree() {
        return Math.max(0L, this.nominalCapacity - this.used);
    }

    public long brimfulCapacityFree() {
        return this.brimfulCapacity - this.used;
    }

    public long capacityUsed() {
        return this.used;
    }

    public long nominalCapacity() {
        return this.nominalCapacity;
    }

    public long brimfulCapacity() {
        return this.brimfulCapacity;
    }

    public void useCapacity(long units) {
        DiscreteLeakyBucket.assertArgument(units >= 0L, "units to leak must be >= 0");
        long newUsed = this.used + units;
        this.assertValidNewUsed(units, newUsed);
        this.used = newUsed;
    }

    void assertValidNewUsed(long units, long newUsed) {
        if (newUsed < 0L || newUsed > this.brimfulCapacity) {
            throw new IllegalArgumentException(String.format("Can't use %d units. New value of %d would overflow the capacity of %d.", units, newUsed, this.brimfulCapacity));
        }
    }

    public void leak(long units) {
        DiscreteLeakyBucket.assertArgument(units >= 0L, "units to leak must be >= 0");
        this.used -= Math.min(this.used, units);
    }

    public void resetUsed(long newUsed) {
        if (newUsed < 0L || newUsed > this.brimfulCapacity) {
            throw new IllegalArgumentException(String.format("Can't set used to %d units - it overflows the capacity of %d.", newUsed, this.brimfulCapacity));
        }
        this.used = newUsed;
    }

    private static void assertArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }
}

