/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.keys;

import com.hedera.hapi.node.base.ContractID;
import com.hedera.node.app.hapi.utils.keys.KeyUtils;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.hederahashgraph.api.proto.java.Key;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.KeyFactory;
import java.security.interfaces.ECPrivateKey;
import java.security.spec.KeySpec;
import java.util.Objects;
import org.bouncycastle.jce.ECNamedCurveTable;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECParameterSpec;
import org.bouncycastle.jce.spec.ECPrivateKeySpec;
import org.bouncycastle.math.ec.ECPoint;

public class Secp256k1Utils {
    public static final int ECDSA_SECP256K1_COMPRESSED_KEY_LENGTH = 33;
    private static final int EVM_ADDRESS_BYTE_LENGTH = 20;
    private static final byte ODD_PARITY = 3;
    private static final byte EVEN_PARITY = 2;

    static boolean isValidEvmAddress(@NonNull ContractID contractId) {
        return contractId.contractNumOrElse(Long.valueOf(0L)) > 0L || contractId.evmAddressOrElse(Bytes.EMPTY).length() == 20L;
    }

    public static byte[] extractEcdsaPublicKey(ECPrivateKey key) {
        ECPoint pointQ = ECNamedCurveTable.getParameterSpec((String)"secp256k1").getG().multiply(key.getS());
        return pointQ.getEncoded(true);
    }

    public static byte[] getEvmAddressFromString(Key key) {
        return Secp256k1Utils.extractEcdsaPublicKey(key);
    }

    public static byte[] extractEcdsaPublicKey(Key key) {
        return key.getECDSASecp256K1().toByteArray();
    }

    public static ECPrivateKey readECKeyFrom(File pem, String passphrase) {
        return (ECPrivateKey)KeyUtils.readKeyFrom(pem, passphrase, KeyUtils.BC_PROVIDER);
    }

    public static ECPrivateKey readECKeyFrom(@NonNull InputStream in, @NonNull String passphrase) {
        Objects.requireNonNull(in);
        Objects.requireNonNull(passphrase);
        return (ECPrivateKey)KeyUtils.readKeyFrom(in, passphrase, KeyUtils.BC_PROVIDER);
    }

    static boolean isValidEcdsaSecp256k1Key(@NonNull Bytes key) {
        return key.length() == 33L && (key.getByte(0L) == 2 || key.getByte(0L) == 3);
    }

    public static ECPrivateKey readECKeyFrom(byte[] keyBytes) {
        BigInteger s = new BigInteger(1, keyBytes);
        ECNamedCurveParameterSpec ecSpec = ECNamedCurveTable.getParameterSpec((String)"secp256k1");
        ECPrivateKeySpec keySpec = new ECPrivateKeySpec(s, (ECParameterSpec)ecSpec);
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("EC", KeyUtils.BC_PROVIDER);
            return (ECPrivateKey)keyFactory.generatePrivate((KeySpec)keySpec);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

