/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.webserver.http;

import io.helidon.common.GenericType;
import io.helidon.common.uri.UriQuery;
import io.helidon.http.Header;
import io.helidon.http.HeaderName;
import io.helidon.http.HeaderNames;
import io.helidon.http.HeaderValues;
import io.helidon.http.NotFoundException;
import io.helidon.http.ServerResponseHeaders;
import io.helidon.http.ServerResponseTrailers;
import io.helidon.http.Status;
import io.helidon.service.registry.Service;
import io.helidon.webserver.http.spi.Sink;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;

@Service.Describe(value=Service.PerRequest.class)
public interface ServerResponse {
    public ServerResponse status(Status var1);

    default public ServerResponse status(int status) {
        return this.status(Status.create((int)status));
    }

    public Status status();

    default public ServerResponse header(HeaderName name, String ... values) {
        return this.header(HeaderValues.create((HeaderName)name, (String[])values));
    }

    default public ServerResponse header(String name, String ... values) {
        return this.header(HeaderValues.create((String)name, (String[])values));
    }

    public ServerResponse header(Header var1);

    public void send();

    public void send(byte[] var1);

    default public void send(byte[] bytes, int position, int length) {
        this.send(Arrays.copyOfRange(bytes, position, length));
    }

    public void send(Object var1);

    default public void send(Optional<?> entity) {
        this.send(entity.orElseThrow(() -> new NotFoundException("")));
    }

    public boolean isSent();

    public OutputStream outputStream();

    public long bytesWritten();

    default public ServerResponse beforeSend(Runnable listener) {
        return this;
    }

    public ServerResponse whenSent(Runnable var1);

    public ServerResponse reroute(String var1);

    public ServerResponse reroute(String var1, UriQuery var2);

    public ServerResponse next();

    public ServerResponseHeaders headers();

    public ServerResponseTrailers trailers();

    default public ServerResponse beforeTrailers(Consumer<ServerResponseTrailers> beforeTrailers) {
        return this;
    }

    public void streamResult(String var1);

    default public void contentLength(long length) {
        this.header(HeaderValues.create((HeaderName)HeaderNames.CONTENT_LENGTH, (boolean)true, (boolean)false, (String[])new String[]{String.valueOf(length)}));
    }

    default public <T extends Sink<?>> T sink(GenericType<T> sinkType) {
        throw new UnsupportedOperationException("No sink available for type " + String.valueOf(sinkType));
    }

    public void streamFilter(UnaryOperator<OutputStream> var1);
}

