/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.pcli.utility;

import edu.umd.cs.findbugs.annotations.NonNull;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import picocli.CommandLine;

public class ParameterizedClass {
    @CommandLine.Spec
    private CommandLine.Model.CommandSpec spec;

    public CommandLine.Model.CommandSpec getSpec() {
        return this.spec;
    }

    @NonNull
    protected CommandLine.ParameterException buildParameterException(@NonNull String message) {
        throw new CommandLine.ParameterException(this.spec.commandLine(), message);
    }

    @NonNull
    protected Path pathMustExist(@NonNull Path path) {
        if (!Files.exists(path, new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Path " + String.valueOf(path) + " does not exist");
        }
        if (!Files.isReadable(path)) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "No read permission for " + String.valueOf(path));
        }
        return path;
    }

    @NonNull
    protected Path dirMustExist(@NonNull Path path) {
        this.pathMustExist(path);
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Path " + String.valueOf(path) + " is not a directory");
        }
        return path;
    }

    @NonNull
    protected Path pathMustNotExist(@NonNull Path path) {
        if (Files.exists(path, new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Path " + String.valueOf(path) + " already exists");
        }
        return path;
    }

    @NonNull
    protected File fileMustExist(@NonNull Path path) {
        if (!Files.isRegularFile(this.pathMustExist(path), new LinkOption[0])) {
            throw new CommandLine.ParameterException(this.spec.commandLine(), "Path " + String.valueOf(path) + " is not a file.");
        }
        return path.toFile();
    }
}

