/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.spi.fees;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.node.app.hapi.fees.calc.OverflowCheckingCalc;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.spi.authorization.Authorizer;
import com.hedera.node.app.spi.fees.FeeCalculatorFactory;
import com.hedera.node.app.spi.fees.Fees;
import com.hedera.node.app.spi.fees.SimpleFeeCalculator;
import com.hedera.node.app.spi.store.ReadableStoreFactory;
import com.hederahashgraph.api.proto.java.ExchangeRate;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public interface FeeContext {
    @NonNull
    public AccountID payer();

    @NonNull
    public TransactionBody body();

    @NonNull
    public FeeCalculatorFactory feeCalculatorFactory();

    public SimpleFeeCalculator getSimpleFeeCalculator();

    @NonNull
    public ReadableStoreFactory readableStoreFactory();

    @NonNull
    public <T> T readableStore(@NonNull Class<T> var1);

    @NonNull
    public Configuration configuration();

    @Nullable
    public Authorizer authorizer();

    public int numTxnSignatures();

    public int numTxnBytes();

    public Fees dispatchComputeFees(@NonNull TransactionBody var1, @NonNull AccountID var2);

    public com.hedera.hapi.node.transaction.ExchangeRate activeRate();

    public long getGasPriceInTinycents();

    public HederaFunctionality functionality();

    default public long tinybarsFromTinycents(long amount) {
        return OverflowCheckingCalc.tinycentsToTinybars((long)amount, (ExchangeRate)CommonPbjConverters.fromPbj((com.hedera.hapi.node.transaction.ExchangeRate)this.activeRate()));
    }
}

