/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.collections.impl.map.immutable.primitive;

import java.io.IOException;
import java.io.Serializable;
import org.eclipse.collections.api.IntIterable;
import org.eclipse.collections.api.LazyIntIterable;
import org.eclipse.collections.api.LazyLongIterable;
import org.eclipse.collections.api.LongIterable;
import org.eclipse.collections.api.RichIterable;
import org.eclipse.collections.api.bag.ImmutableBag;
import org.eclipse.collections.api.bag.primitive.ImmutableIntBag;
import org.eclipse.collections.api.bag.primitive.MutableIntBag;
import org.eclipse.collections.api.block.function.primitive.IntToObjectFunction;
import org.eclipse.collections.api.block.function.primitive.ObjectIntToObjectFunction;
import org.eclipse.collections.api.block.predicate.primitive.IntPredicate;
import org.eclipse.collections.api.block.predicate.primitive.LongIntPredicate;
import org.eclipse.collections.api.block.procedure.primitive.IntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongIntProcedure;
import org.eclipse.collections.api.block.procedure.primitive.LongProcedure;
import org.eclipse.collections.api.collection.primitive.MutableIntCollection;
import org.eclipse.collections.api.iterator.IntIterator;
import org.eclipse.collections.api.list.primitive.MutableIntList;
import org.eclipse.collections.api.map.primitive.ImmutableIntLongMap;
import org.eclipse.collections.api.map.primitive.ImmutableLongIntMap;
import org.eclipse.collections.api.map.primitive.LongIntMap;
import org.eclipse.collections.api.set.primitive.MutableIntSet;
import org.eclipse.collections.api.set.primitive.MutableLongSet;
import org.eclipse.collections.api.tuple.primitive.LongIntPair;
import org.eclipse.collections.impl.bag.mutable.primitive.IntHashBag;
import org.eclipse.collections.impl.collection.mutable.primitive.UnmodifiableIntCollection;
import org.eclipse.collections.impl.factory.Bags;
import org.eclipse.collections.impl.factory.Lists;
import org.eclipse.collections.impl.factory.primitive.IntBags;
import org.eclipse.collections.impl.factory.primitive.IntLongMaps;
import org.eclipse.collections.impl.factory.primitive.LongIntMaps;
import org.eclipse.collections.impl.factory.primitive.LongLists;
import org.eclipse.collections.impl.iterator.UnmodifiableIntIterator;
import org.eclipse.collections.impl.lazy.primitive.LazyIntIterableAdapter;
import org.eclipse.collections.impl.list.mutable.primitive.IntArrayList;
import org.eclipse.collections.impl.map.mutable.primitive.LongIntHashMap;
import org.eclipse.collections.impl.set.mutable.primitive.IntHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.LongHashSet;
import org.eclipse.collections.impl.set.mutable.primitive.UnmodifiableLongSet;
import org.eclipse.collections.impl.tuple.primitive.PrimitiveTuples;

final class ImmutableLongIntSingletonMap
implements ImmutableLongIntMap,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final int EMPTY_VALUE = 0;
    private final long key1;
    private final int value1;

    ImmutableLongIntSingletonMap(long key1, int value1) {
        this.key1 = key1;
        this.value1 = value1;
    }

    public int get(long key) {
        return this.getIfAbsent(key, 0);
    }

    public int getIfAbsent(long key, int ifAbsent) {
        return this.key1 == key ? this.value1 : ifAbsent;
    }

    public int getOrThrow(long key) {
        if (this.key1 == key) {
            return this.value1;
        }
        throw new IllegalStateException("Key " + key + " not present.");
    }

    public boolean containsKey(long key) {
        return this.key1 == key;
    }

    public boolean containsValue(int value) {
        return this.value1 == value;
    }

    public void forEachValue(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public void forEachKey(LongProcedure procedure) {
        procedure.value(this.key1);
    }

    public void forEachKeyValue(LongIntProcedure procedure) {
        procedure.value(this.key1, this.value1);
    }

    public boolean allSatisfyKeyValue(LongIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1);
    }

    public LazyLongIterable keysView() {
        return LongLists.immutable.of(this.key1).asLazy();
    }

    public RichIterable<LongIntPair> keyValuesView() {
        return Lists.immutable.of((Object)PrimitiveTuples.pair(this.key1, this.value1)).asLazy();
    }

    public ImmutableIntLongMap flipUniqueValues() {
        return IntLongMaps.immutable.with(this.value1, this.key1);
    }

    public ImmutableLongIntMap select(LongIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? LongIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable() : new LongIntHashMap().toImmutable();
    }

    public ImmutableLongIntMap reject(LongIntPredicate predicate) {
        return predicate.accept(this.key1, this.value1) ? new LongIntHashMap().toImmutable() : LongIntHashMap.newWithKeysValues(this.key1, this.value1).toImmutable();
    }

    public <T> T injectInto(T injectedValue, ObjectIntToObjectFunction<? super T, ? extends T> function) {
        return (T)function.valueOf(injectedValue, this.value1);
    }

    public RichIterable<IntIterable> chunk(int size) {
        if (size <= 0) {
            throw new IllegalArgumentException("Size for groups must be positive but was: " + size);
        }
        return Lists.mutable.with((Object[])new IntIterable[]{IntBags.immutable.with(this.value1)});
    }

    public ImmutableLongIntMap toImmutable() {
        return this;
    }

    public IntIterator intIterator() {
        return new UnmodifiableIntIterator((IntIterator)LongIntHashMap.newWithKeysValues(this.key1, this.value1).intIterator());
    }

    public void each(IntProcedure procedure) {
        procedure.value(this.value1);
    }

    public int count(IntPredicate predicate) {
        return predicate.accept(this.value1) ? 1 : 0;
    }

    public long sum() {
        return this.value1;
    }

    public int min() {
        return this.value1;
    }

    public int max() {
        return this.value1;
    }

    public int maxIfEmpty(int defaultValue) {
        return this.value1;
    }

    public int minIfEmpty(int defaultValue) {
        return this.value1;
    }

    public double average() {
        return this.value1;
    }

    public double median() {
        return this.value1;
    }

    public int[] toSortedArray() {
        return new int[]{this.value1};
    }

    public MutableIntList toSortedList() {
        return IntArrayList.newListWith(this.value1);
    }

    public boolean anySatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean allSatisfy(IntPredicate predicate) {
        return predicate.accept(this.value1);
    }

    public boolean noneSatisfy(IntPredicate predicate) {
        return !predicate.accept(this.value1);
    }

    public ImmutableIntBag select(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntHashBag.newBagWith(this.value1).toImmutable() : IntBags.immutable.empty();
    }

    public ImmutableIntBag reject(IntPredicate predicate) {
        return predicate.accept(this.value1) ? IntBags.immutable.empty() : IntHashBag.newBagWith(this.value1).toImmutable();
    }

    public <V> ImmutableBag<V> collect(IntToObjectFunction<? extends V> function) {
        return Bags.immutable.of(function.valueOf(this.value1));
    }

    public int detectIfNone(IntPredicate predicate, int ifNone) {
        return predicate.accept(this.value1) ? this.value1 : ifNone;
    }

    public int[] toArray() {
        return new int[]{this.value1};
    }

    public int[] toArray(int[] target) {
        if (target.length < 1) {
            target = new int[]{this.value1};
        } else {
            target[0] = this.value1;
        }
        return target;
    }

    public boolean contains(int value) {
        return this.value1 == value;
    }

    public boolean containsAll(int ... source) {
        for (int value : source) {
            if (this.value1 == value) continue;
            return false;
        }
        return true;
    }

    public boolean containsAll(IntIterable source) {
        IntIterator iterator = source.intIterator();
        while (iterator.hasNext()) {
            if (this.value1 == iterator.next()) continue;
            return false;
        }
        return true;
    }

    public MutableIntList toList() {
        return IntArrayList.newListWith(this.value1);
    }

    public MutableIntSet toSet() {
        return IntHashSet.newSetWith(this.value1);
    }

    public MutableIntBag toBag() {
        return IntHashBag.newBagWith(this.value1);
    }

    public LazyIntIterable asLazy() {
        return new LazyIntIterableAdapter((IntIterable)this);
    }

    public ImmutableLongIntMap newWithKeyValue(long key, int value) {
        return LongIntMaps.immutable.withAll((LongIntMap)LongIntHashMap.newWithKeysValues(this.key1, this.value1, key, value));
    }

    public ImmutableLongIntMap newWithoutKey(long key) {
        return this.key1 == key ? LongIntMaps.immutable.with() : this;
    }

    public ImmutableLongIntMap newWithoutAllKeys(LongIterable keys) {
        return keys.contains(this.key1) ? LongIntMaps.immutable.with() : this;
    }

    public int size() {
        return 1;
    }

    public boolean isEmpty() {
        return false;
    }

    public boolean notEmpty() {
        return true;
    }

    public MutableLongSet keySet() {
        return UnmodifiableLongSet.of(LongHashSet.newSetWith(this.key1));
    }

    public MutableIntCollection values() {
        return UnmodifiableIntCollection.of((MutableIntCollection)IntArrayList.newListWith(this.value1));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof LongIntMap)) {
            return false;
        }
        LongIntMap map = (LongIntMap)obj;
        if (map.size() != 1) {
            return false;
        }
        return map.containsKey(this.key1) && this.value1 == map.getOrThrow(this.key1);
    }

    public int hashCode() {
        return (int)(this.key1 ^ this.key1 >>> 32) ^ this.value1;
    }

    public String toString() {
        return "{" + this.key1 + "=" + this.value1 + "}";
    }

    public String makeString() {
        return this.makeString(", ");
    }

    public String makeString(String separator) {
        return this.makeString("", separator, "");
    }

    public String makeString(String start, String separator, String end) {
        StringBuilder stringBuilder = new StringBuilder();
        this.appendString(stringBuilder, start, separator, end);
        return ((Object)stringBuilder).toString();
    }

    public void appendString(Appendable appendable) {
        this.appendString(appendable, ", ");
    }

    public void appendString(Appendable appendable, String separator) {
        this.appendString(appendable, "", separator, "");
    }

    public void appendString(Appendable appendable, String start, String separator, String end) {
        try {
            appendable.append(start);
            appendable.append(String.valueOf(this.value1));
            appendable.append(end);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

