/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.communication.handshake;

import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.util.HapiUtils;
import com.swirlds.logging.legacy.LogMarker;
import java.io.IOException;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.gossip.impl.network.Connection;
import org.hiero.consensus.gossip.impl.network.NetworkProtocolException;
import org.hiero.consensus.gossip.impl.network.communication.handshake.HandshakeException;
import org.hiero.consensus.gossip.impl.network.protocol.ProtocolRunnable;

public class VersionCompareHandshake
implements ProtocolRunnable {
    private static final Logger logger = LogManager.getLogger(VersionCompareHandshake.class);
    private final SemanticVersion version;
    private final boolean throwOnMismatch;

    public VersionCompareHandshake(SemanticVersion version) {
        this(version, true);
    }

    public VersionCompareHandshake(SemanticVersion version, boolean throwOnMismatch) {
        Objects.requireNonNull(version, "version must not be null");
        this.version = version;
        this.throwOnMismatch = throwOnMismatch;
    }

    @Override
    public void runProtocol(Connection connection) throws NetworkProtocolException, IOException, InterruptedException {
        connection.getDos().writePbjRecord(this.version, SemanticVersion.PROTOBUF);
        connection.getDos().flush();
        SemanticVersion peerVersion = (SemanticVersion)connection.getDis().readPbjRecord(SemanticVersion.PROTOBUF);
        if (HapiUtils.SEMANTIC_VERSION_COMPARATOR.compare(this.version, peerVersion) != 0) {
            String message = String.format("Incompatible versions. Self version is '%s', peer version is '%s'", this.version, peerVersion);
            if (this.throwOnMismatch) {
                throw new HandshakeException(message);
            }
            logger.error(LogMarker.EXCEPTION.getMarker(), message);
        }
    }
}

