/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.operations;

import com.hedera.node.app.service.contract.impl.exec.AddressChecks;
import com.hedera.node.app.service.contract.impl.exec.FeatureFlags;
import com.hedera.node.app.service.contract.impl.exec.failure.CustomExceptionalHaltReason;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.HtsSystemContract;
import com.hedera.node.app.service.contract.impl.exec.utils.FrameUtils;
import com.hedera.node.app.service.contract.impl.exec.utils.InvalidAddressContext;
import com.hedera.node.app.service.contract.impl.utils.ConversionUtils;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;
import org.apache.tuweni.units.bigints.UInt256Value;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.datatypes.Wei;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.UnderflowException;
import org.hyperledger.besu.evm.operation.CallOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class CustomCallOperation
extends CallOperation {
    private static final Operation.OperationResult UNDERFLOW_RESPONSE = new Operation.OperationResult(0L, ExceptionalHaltReason.INSUFFICIENT_STACK_ITEMS);
    private final FeatureFlags featureFlags;
    private final AddressChecks addressChecks;

    public CustomCallOperation(@NonNull FeatureFlags featureFlags, @NonNull GasCalculator gasCalculator, @NonNull AddressChecks addressChecks) {
        super(gasCalculator);
        this.featureFlags = Objects.requireNonNull(featureFlags);
        this.addressChecks = Objects.requireNonNull(addressChecks);
    }

    public Operation.OperationResult execute(@NonNull MessageFrame frame, @NonNull EVM evm) {
        try {
            boolean isMissing;
            long cost = this.cost(frame, false);
            if (frame.getRemainingGas() < cost) {
                return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
            }
            Address toAddress = this.to(frame);
            boolean bl = isMissing = this.mustBePresent(frame, toAddress) && !this.addressChecks.isPresent(toAddress, frame);
            if (isMissing) {
                FrameUtils.invalidAddressContext(frame).set(toAddress, InvalidAddressContext.InvalidAddressType.InvalidCallTarget);
                return new Operation.OperationResult(cost, (ExceptionalHaltReason)CustomExceptionalHaltReason.INVALID_SOLIDITY_ADDRESS);
            }
            return super.execute(frame, evm);
        }
        catch (UnderflowException ignore) {
            return UNDERFLOW_RESPONSE;
        }
    }

    public Address sender(MessageFrame frame) {
        if (frame.getRecipientAddress().equals((Object)HtsSystemContract.HTS_HOOKS_CONTRACT_ADDRESS)) {
            return FrameUtils.hookOwnerAddress(frame);
        }
        return super.sender(frame);
    }

    private boolean mustBePresent(@NonNull MessageFrame frame, @NonNull Address toAddress) {
        if (this.impliesLazyCreation(frame, toAddress) && this.featureFlags.isImplicitCreationEnabled()) {
            return false;
        }
        return !this.addressChecks.isSystemAccount(toAddress) && FrameUtils.contractRequired(frame, toAddress, this.featureFlags);
    }

    private boolean impliesLazyCreation(@NonNull MessageFrame frame, @NonNull Address toAddress) {
        return !ConversionUtils.isLongZero(toAddress) && this.value(frame).greaterThan((UInt256Value)Wei.ZERO) && !this.addressChecks.isPresent(toAddress, frame);
    }
}

