/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.evm.operation;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.tuweni.bytes.Bytes;
import org.apache.tuweni.bytes.Bytes32;
import org.hyperledger.besu.datatypes.Address;
import org.hyperledger.besu.evm.EVM;
import org.hyperledger.besu.evm.frame.ExceptionalHaltReason;
import org.hyperledger.besu.evm.frame.MessageFrame;
import org.hyperledger.besu.evm.gascalculator.GasCalculator;
import org.hyperledger.besu.evm.internal.Words;
import org.hyperledger.besu.evm.log.Log;
import org.hyperledger.besu.evm.log.LogTopic;
import org.hyperledger.besu.evm.operation.AbstractOperation;
import org.hyperledger.besu.evm.operation.Operation;

public class LogOperation
extends AbstractOperation {
    private final int numTopics;

    public LogOperation(int numTopics, GasCalculator gasCalculator) {
        super(160 + numTopics, "LOG" + numTopics, numTopics + 2, 0, gasCalculator);
        this.numTopics = numTopics;
    }

    @Override
    public Operation.OperationResult execute(MessageFrame frame, EVM evm) {
        long dataLocation = Words.clampedToLong(frame.popStackItem());
        long numBytes = Words.clampedToLong(frame.popStackItem());
        long cost = this.gasCalculator().logOperationGasCost(frame, dataLocation, numBytes, this.numTopics);
        if (frame.isStatic()) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.ILLEGAL_STATE_CHANGE);
        }
        if (frame.getRemainingGas() < cost) {
            return new Operation.OperationResult(cost, ExceptionalHaltReason.INSUFFICIENT_GAS);
        }
        Address address = frame.getRecipientAddress();
        Bytes data = frame.readMemory(dataLocation, numBytes);
        ImmutableList.Builder builder = ImmutableList.builderWithExpectedSize((int)this.numTopics);
        for (int i = 0; i < this.numTopics; ++i) {
            builder.add((Object)LogTopic.create((Bytes)Bytes32.leftPad((Bytes)frame.popStackItem())));
        }
        frame.addLog(new Log(address, data, (List<LogTopic>)builder.build()));
        return new Operation.OperationResult(cost, null);
    }
}

