/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.hapi.utils.forensics;

import com.hedera.node.app.hapi.utils.forensics.RecordStreamEntry;
import com.hederahashgraph.api.proto.java.HederaFunctionality;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;

public record DifferingEntries(@Nullable RecordStreamEntry firstEntry, @Nullable RecordStreamEntry secondEntry, @Nullable String summary) {
    public FirstEncounteredDifference firstEncounteredDifference() {
        if (this.firstEntry == null) {
            return FirstEncounteredDifference.FIRST_IS_MISSING;
        }
        if (this.secondEntry == null) {
            return FirstEncounteredDifference.SECOND_IS_MISSING;
        }
        if (!this.firstEntry.consensusTime().equals(this.secondEntry.consensusTime())) {
            return FirstEncounteredDifference.CONSENSUS_TIME_MISMATCH;
        }
        if (!this.firstEntry.parts().wrapper().equals((Object)this.secondEntry.parts().wrapper())) {
            return FirstEncounteredDifference.TRANSACTION_MISMATCH;
        }
        return FirstEncounteredDifference.TRANSACTION_RECORD_MISMATCH;
    }

    public String involvedFunctions() {
        HederaFunctionality secondFunction;
        if (this.firstEntry == null) {
            return Objects.requireNonNull(this.secondEntry).parts().function().name();
        }
        if (this.secondEntry == null) {
            return Objects.requireNonNull(this.firstEntry).parts().function().name();
        }
        HederaFunctionality firstFunction = this.firstEntry.parts().function();
        return firstFunction == (secondFunction = this.secondEntry.parts().function()) ? firstFunction.name() : String.format("%s \u2260 %s", firstFunction, secondFunction);
    }

    public static enum FirstEncounteredDifference {
        FIRST_IS_MISSING,
        SECOND_IS_MISSING,
        CONSENSUS_TIME_MISMATCH,
        TRANSACTION_MISMATCH,
        TRANSACTION_RECORD_MISMATCH;

    }
}

