/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.pbj.runtime;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.FieldType;
import com.hedera.pbj.runtime.ProtoConstants;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.Utf8Tools;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteOrder;
import java.util.List;

public final class ProtoArrayWriterTools {
    private static final int[] VAR_INT_LENGTHS = new int[65];
    private static final VarHandle INTEGER_LITTLE_ENDIAN;
    private static final VarHandle LONG_LITTLE_ENDIAN;

    public static int writeUnsignedVarInt(@NonNull byte[] output, int offset, long value) {
        int length = VAR_INT_LENGTHS[Long.numberOfLeadingZeros(value)];
        output[offset + length] = (byte)(value >>> length * 7);
        switch (length - 1) {
            case 8: {
                output[offset + 8] = (byte)(value >>> 56 | 0x80L);
            }
            case 7: {
                output[offset + 7] = (byte)(value >>> 49 | 0x80L);
            }
            case 6: {
                output[offset + 6] = (byte)(value >>> 42 | 0x80L);
            }
            case 5: {
                output[offset + 5] = (byte)(value >>> 35 | 0x80L);
            }
            case 4: {
                output[offset + 4] = (byte)(value >>> 28 | 0x80L);
            }
            case 3: {
                output[offset + 3] = (byte)(value >>> 21 | 0x80L);
            }
            case 2: {
                output[offset + 2] = (byte)(value >>> 14 | 0x80L);
            }
            case 1: {
                output[offset + 1] = (byte)(value >>> 7 | 0x80L);
            }
            case 0: {
                output[offset] = (byte)(value | 0x80L);
            }
        }
        return length + 1;
    }

    public static int writeSignedVarInt32(@NonNull byte[] output, int offset, int value) {
        int zigZag = value << 1 ^ value >> 31;
        return ProtoArrayWriterTools.writeUnsignedVarInt(output, offset, Integer.toUnsignedLong(zigZag));
    }

    public static int writeSignedVarInt64(@NonNull byte[] output, int offset, long value) {
        long zigZag = value << 1 ^ value >> 63;
        return ProtoArrayWriterTools.writeUnsignedVarInt(output, offset, zigZag);
    }

    public static int writeTag(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, @NonNull ProtoConstants wireType) {
        return ProtoArrayWriterTools.writeUnsignedVarInt(output, offset, (long)field.number() << 3 | (long)wireType.ordinal());
    }

    public static int writeString(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, String value, boolean skipDefault) {
        assert (field.type() == FieldType.STRING) : "Not a string type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeStringList with repeated types";
        return ProtoArrayWriterTools.writeStringNoChecks(output, offset, field, value, skipDefault);
    }

    private static int writeStringNoChecks(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, String value, boolean skipDefault) {
        int bytesWritten = 0;
        if (skipDefault && !field.oneOf() && (value == null || value.isEmpty())) {
            return 0;
        }
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfStringNoTag(value));
        bytesWritten += Utf8Tools.encodeUtf8(output, offset + bytesWritten, value);
        return bytesWritten;
    }

    public static int writeOptionalString(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, @Nullable String value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfString(newField, value));
            if (!value.isEmpty()) {
                bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, newField, ProtoConstants.WIRE_TYPE_DELIMITED);
                bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfStringNoTag(value));
                bytesWritten += Utf8Tools.encodeUtf8(output, offset + bytesWritten, value);
            }
        }
        return bytesWritten;
    }

    public static int writeBoolean(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, boolean value, boolean skipDefault) {
        assert (field.type() == FieldType.BOOL) : "Not a boolean type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeBooleanList with repeated types";
        int bytesWritten = 0;
        if (value || field.oneOf() || !skipDefault) {
            output[offset + (bytesWritten += ProtoArrayWriterTools.writeTag((byte[])output, (int)offset, (FieldDefinition)field, (ProtoConstants)ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG))] = value ? (byte)1 : 0;
            ++bytesWritten;
        }
        return bytesWritten;
    }

    public static int writeOptionalBoolean(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, @Nullable Boolean value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfBoolean(newField, value));
            bytesWritten += ProtoArrayWriterTools.writeBoolean(output, offset + bytesWritten, newField, value, true);
        }
        return bytesWritten;
    }

    public static int writeInt32(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, int value, boolean skipDefault) {
        assert (field.type() == FieldType.INT32) : "Not an Int32 type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeIntegerList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value);
        return bytesWritten;
    }

    public static int writeUInt32(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, int value, boolean skipDefault) {
        assert (field.type() == FieldType.UINT32) : "Not a UInt32 type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeIntegerList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, Integer.toUnsignedLong(value));
        return bytesWritten;
    }

    public static int writSInt32(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, int value, boolean skipDefault) {
        assert (field.type() == FieldType.SINT32) : "Not a SInt32 type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeIntegerList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeSignedVarInt32(output, offset + bytesWritten, value);
        return bytesWritten;
    }

    public static int writeFixed32(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, int value, boolean skipDefault) {
        assert (field.type() == FieldType.FIXED32 || field.type() == FieldType.SFIXED32 || field.type() == FieldType.FLOAT) : "Not a Fixed32 or SFixed32 or Float type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeIntegerList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0) {
            return 0;
        }
        int bytesWritten = 0;
        INTEGER_LITTLE_ENDIAN.set(output, offset + (bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_FIXED_32_BIT)), value);
        return bytesWritten += 4;
    }

    public static int writeOptionalInt32Value(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Integer value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value == 0 ? 0L : (long)(ProtoWriterTools.sizeOfTag(newField, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfVarInt32(value)));
            bytesWritten += ProtoArrayWriterTools.writeInt32(output, offset + bytesWritten, newField, value, true);
        }
        return bytesWritten;
    }

    public static int writeOptionalUInt32Value(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Integer value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value == 0 ? 0L : (long)(ProtoWriterTools.sizeOfTag(newField, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfVarInt32(value)));
            bytesWritten += ProtoArrayWriterTools.writeUInt32(output, offset + bytesWritten, newField, value, true);
        }
        return bytesWritten;
    }

    public static int writeInt64(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, long value, boolean skipDefault) {
        assert (field.type() == FieldType.INT64 || field.type() == FieldType.UINT64) : "Not an Int64 or UInt64 type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeLongList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0L) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value);
        return bytesWritten;
    }

    public static int writeSInt64(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, long value, boolean skipDefault) {
        assert (field.type() == FieldType.SINT64) : "Not a SInt64 type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeLongList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0L) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeSignedVarInt64(output, offset + bytesWritten, value);
        return bytesWritten;
    }

    public static int writeFixed64(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, long value, boolean skipDefault) {
        assert (field.type() == FieldType.FIXED64 || field.type() == FieldType.SFIXED64 || field.type() == FieldType.DOUBLE) : "Not a Fixed64 or SFixed64 or Double type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeLongList with repeated types";
        if (skipDefault && !field.oneOf() && value == 0L) {
            return 0;
        }
        int bytesWritten = 0;
        LONG_LITTLE_ENDIAN.set(output, offset + (bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_FIXED_64_BIT)), value);
        return bytesWritten += 8;
    }

    public static int writeOptionalInt64Value(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Long value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value == 0L ? 0L : (long)(ProtoWriterTools.sizeOfTag(newField, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG) + ProtoWriterTools.sizeOfUnsignedVarInt64(value)));
            bytesWritten += ProtoArrayWriterTools.writeInt64(output, offset + bytesWritten, newField, value, true);
        }
        return bytesWritten;
    }

    public static int writeFloat(@NonNull byte[] output, int offset, FieldDefinition field, float value) {
        assert (field.type() == FieldType.FLOAT) : "Not a float type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeFloatList with repeated types";
        if (!field.oneOf() && value == 0.0f) {
            return 0;
        }
        int bytesWritten = 0;
        INTEGER_LITTLE_ENDIAN.set(output, offset + (bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_FIXED_32_BIT)), Float.floatToIntBits(value));
        return bytesWritten += 4;
    }

    public static int writeDouble(@NonNull byte[] output, int offset, FieldDefinition field, double value) {
        assert (field.type() == FieldType.DOUBLE) : "Not a double type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeDoubleList with repeated types";
        if (!field.oneOf() && value == 0.0) {
            return 0;
        }
        int bytesWritten = 0;
        LONG_LITTLE_ENDIAN.set(output, offset + (bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_FIXED_64_BIT)), Double.doubleToLongBits(value));
        return bytesWritten += 8;
    }

    public static int writeOptionalFloat(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Float value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfFloat(newField, value.floatValue()));
            bytesWritten += ProtoArrayWriterTools.writeFixed32(output, offset + bytesWritten, newField, Float.floatToIntBits(value.floatValue()), true);
        }
        return bytesWritten;
    }

    public static int writeOptionalDouble(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Double value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, ProtoWriterTools.sizeOfDouble(newField, value));
            bytesWritten += ProtoArrayWriterTools.writeFixed64(output, offset + bytesWritten, newField, Double.doubleToLongBits(value), true);
        }
        return bytesWritten;
    }

    public static int writeOptionalBytes(@NonNull byte[] output, int offset, FieldDefinition field, @Nullable Bytes value) {
        int bytesWritten = 0;
        if (value != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            FieldDefinition newField = field.type().optionalFieldDefinition;
            int size = ProtoWriterTools.sizeOfBytes(newField, value);
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
            if (size > 0) {
                bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, newField, ProtoConstants.WIRE_TYPE_DELIMITED);
                bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value.length());
                bytesWritten += value.writeTo(output, offset + bytesWritten);
            }
        }
        return bytesWritten;
    }

    public static int writeEnum(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, @Nullable EnumWithProtoMetadata enumValue) {
        assert (field.type() == FieldType.ENUM) : "Not an enum type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeEnumList with repeated types";
        if (!(field.oneOf() || enumValue != null && enumValue.protoOrdinal() != 0)) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, enumValue == null ? 0L : (long)enumValue.protoOrdinal());
        return bytesWritten;
    }

    public static int writeEnumProtoOrdinal(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, int protoOrdinal) {
        assert (field.type() == FieldType.ENUM) : "Not an enum type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeEnumList with repeated types";
        if (!field.oneOf() && protoOrdinal == 0) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_VARINT_OR_ZIGZAG);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, protoOrdinal);
        return bytesWritten;
    }

    public static <T> int writeMessage(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, T message, Codec<T> codec) {
        assert (field.type() == FieldType.MESSAGE) : "Not a message type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeMessageList with repeated types";
        return ProtoArrayWriterTools.writeMessageNoChecks(output, offset, field, message, codec);
    }

    private static <T> int writeMessageNoChecks(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, T message, Codec<T> codec) {
        int bytesWritten = 0;
        if (field.oneOf() && message == null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, 0L);
        } else if (message != null) {
            bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            int size = codec.measureRecord(message);
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
            if (size > 0) {
                bytesWritten += codec.write(message, output, offset + bytesWritten);
            }
        }
        return bytesWritten;
    }

    public static int writeBytes(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, Bytes value, boolean skipDefault) {
        assert (field.type() == FieldType.BYTES) : "Not a byte[] type " + String.valueOf(field);
        assert (!field.repeated()) : "Use writeBytesList with repeated types";
        return ProtoArrayWriterTools.writeBytesNoChecks(output, offset, field, value, skipDefault);
    }

    private static int writeBytesNoChecks(@NonNull byte[] output, int offset, @NonNull FieldDefinition field, Bytes value, boolean skipZeroLength) {
        if (!field.oneOf() && skipZeroLength && value.length() == 0L) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, value.length());
        bytesWritten += value.writeTo(output, offset + bytesWritten);
        return bytesWritten;
    }

    public static int writeInt32List(@NonNull byte[] output, int offset, FieldDefinition field, List<Integer> list) {
        assert (field.type() == FieldType.INT32) : "Not a int32 type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeInteger with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            int val = list.get(i);
            size += ProtoWriterTools.sizeOfVarInt32(val);
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, list.get(i).intValue());
        }
        return bytesWritten;
    }

    public static int writeUInt32List(@NonNull byte[] output, int offset, FieldDefinition field, List<Integer> list) {
        assert (field.type() == FieldType.UINT32) : "Not a UINT32 type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeInteger with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            int val = list.get(i);
            size += ProtoWriterTools.sizeOfUnsignedVarInt64(Integer.toUnsignedLong(val));
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, Integer.toUnsignedLong(list.get(i)));
        }
        return bytesWritten;
    }

    public static int writeSInt32List(@NonNull byte[] output, int offset, FieldDefinition field, List<Integer> list) {
        assert (field.type() == FieldType.SINT32) : "Not a SINT32 type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeInteger with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            int val = list.get(i);
            size += ProtoWriterTools.sizeOfUnsignedVarInt32(val << 1 ^ val >> 31);
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeSignedVarInt32(output, offset + bytesWritten, list.get(i));
        }
        return bytesWritten;
    }

    public static int writeFixed32List(@NonNull byte[] output, int offset, FieldDefinition field, List<Integer> list) {
        assert (field.type() == FieldType.FIXED32 || field.type() == FieldType.SFIXED32) : "Not a long type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeInteger with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, (long)list.size() * 4L);
        for (int i = 0; i < listSize; ++i) {
            INTEGER_LITTLE_ENDIAN.set(output, offset + bytesWritten, list.get(i));
            bytesWritten += 4;
        }
        return bytesWritten;
    }

    public static int writeInt64List(@NonNull byte[] output, int offset, FieldDefinition field, List<Long> list) {
        assert (field.type() == FieldType.INT64 || field.type() == FieldType.UINT64) : "Not a long type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeLong with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            long val = list.get(i);
            size += ProtoWriterTools.sizeOfUnsignedVarInt64(val);
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, list.get(i));
        }
        return bytesWritten;
    }

    public static int writeSInt64List(@NonNull byte[] output, int offset, FieldDefinition field, List<Long> list) {
        assert (field.type() == FieldType.SINT64) : "Not a SINT64 type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeLong with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            long val = list.get(i);
            size += ProtoWriterTools.sizeOfUnsignedVarInt64(val << 1 ^ val >> 63);
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeSignedVarInt64(output, offset + bytesWritten, list.get(i));
        }
        return bytesWritten;
    }

    public static int writeFixed64List(@NonNull byte[] output, int offset, FieldDefinition field, List<Long> list) {
        assert (field.type() == FieldType.FIXED64 || field.type() == FieldType.SFIXED64) : "Not a fixed long type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeLong with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, (long)list.size() * 8L);
        for (int i = 0; i < listSize; ++i) {
            LONG_LITTLE_ENDIAN.set(output, offset + bytesWritten, list.get(i));
            bytesWritten += 8;
        }
        return bytesWritten;
    }

    public static int writeFloatList(@NonNull byte[] output, int offset, FieldDefinition field, List<Float> list) {
        assert (field.type() == FieldType.FLOAT) : "Not a float type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeFloat with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = list.size() * 4;
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            INTEGER_LITTLE_ENDIAN.set(output, offset + bytesWritten, Float.floatToRawIntBits(list.get(i).floatValue()));
            bytesWritten += 4;
        }
        return bytesWritten;
    }

    public static int writeDoubleList(@NonNull byte[] output, int offset, FieldDefinition field, List<Double> list) {
        assert (field.type() == FieldType.DOUBLE) : "Not a double type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeDouble with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int size = list.size() * 8;
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            LONG_LITTLE_ENDIAN.set(output, offset + bytesWritten, Double.doubleToLongBits(list.get(i)));
            bytesWritten += 8;
        }
        return bytesWritten;
    }

    public static int writeBooleanList(@NonNull byte[] output, int offset, FieldDefinition field, List<Boolean> list) {
        assert (field.type() == FieldType.BOOL) : "Not a boolean type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeBoolean with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, list.size());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            boolean b = list.get(i);
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, b ? 1L : 0L);
        }
        return bytesWritten;
    }

    public static int writeEnumListProtoOrdinals(@NonNull byte[] output, int offset, FieldDefinition field, List<Integer> list) {
        assert (field.type() == FieldType.ENUM) : "Not an enum type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeEnum with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int size = 0;
        for (int i = 0; i < listSize; ++i) {
            size += ProtoWriterTools.sizeOfUnsignedVarInt32(list.get(i));
        }
        int bytesWritten = 0;
        bytesWritten += ProtoArrayWriterTools.writeTag(output, offset + bytesWritten, field, ProtoConstants.WIRE_TYPE_DELIMITED);
        bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, size);
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeUnsignedVarInt(output, offset + bytesWritten, list.get(i).intValue());
        }
        return bytesWritten;
    }

    public static int writeStringList(@NonNull byte[] output, int offset, FieldDefinition field, List<String> list) {
        assert (field.type() == FieldType.STRING) : "Not a string type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeString with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int curOffset = offset;
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            String value = list.get(i);
            curOffset += ProtoArrayWriterTools.writeTag(output, curOffset, field, ProtoConstants.WIRE_TYPE_DELIMITED);
            curOffset += ProtoArrayWriterTools.writeUnsignedVarInt(output, curOffset, ProtoWriterTools.sizeOfStringNoTag(value));
            curOffset += Utf8Tools.encodeUtf8(output, curOffset, value);
        }
        return curOffset - offset;
    }

    public static <T> int writeMessageList(@NonNull byte[] output, int offset, FieldDefinition field, List<T> list, Codec<T> codec) {
        assert (field.type() == FieldType.MESSAGE) : "Not a message type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeMessage with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int bytesWritten = 0;
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeMessageNoChecks(output, offset + bytesWritten, field, list.get(i), codec);
        }
        return bytesWritten;
    }

    public static int writeBytesList(@NonNull byte[] output, int offset, FieldDefinition field, List<? extends Bytes> list) {
        assert (field.type() == FieldType.BYTES) : "Not a message type " + String.valueOf(field);
        assert (field.repeated()) : "Use writeBytes with non-repeated types";
        if (!field.oneOf() && list.isEmpty()) {
            return 0;
        }
        int listSize = list.size();
        int bytesWritten = 0;
        for (int i = 0; i < listSize; ++i) {
            bytesWritten += ProtoArrayWriterTools.writeBytesNoChecks(output, offset + bytesWritten, field, list.get(i), false);
        }
        return bytesWritten;
    }

    static {
        for (int i = 0; i <= 64; ++i) {
            ProtoArrayWriterTools.VAR_INT_LENGTHS[i] = (63 - i) / 7;
        }
        INTEGER_LITTLE_ENDIAN = MethodHandles.byteArrayViewVarHandle(int[].class, ByteOrder.LITTLE_ENDIAN);
        LONG_LITTLE_ENDIAN = MethodHandles.byteArrayViewVarHandle(long[].class, ByteOrder.LITTLE_ENDIAN);
    }
}

