/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.throttle;

import com.google.common.annotations.VisibleForTesting;
import com.hedera.hapi.node.base.AccountAmount;
import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.EvmHookCall;
import com.hedera.hapi.node.base.HederaFunctionality;
import com.hedera.hapi.node.base.HookCall;
import com.hedera.hapi.node.base.NftTransfer;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TokenTransferList;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.base.TransferList;
import com.hedera.hapi.node.contract.ContractCallLocalQuery;
import com.hedera.hapi.node.hooks.HookExecution;
import com.hedera.hapi.node.scheduled.SchedulableTransactionBody;
import com.hedera.hapi.node.scheduled.ScheduleCreateTransactionBody;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.hapi.node.token.TokenMintTransactionBody;
import com.hedera.hapi.node.transaction.Query;
import com.hedera.hapi.node.transaction.ThrottleDefinitions;
import com.hedera.hapi.node.transaction.ThrottleGroup;
import com.hedera.hapi.node.transaction.TransactionBody;
import com.hedera.hapi.util.HapiUtils;
import com.hedera.hapi.util.UnknownHederaFunctionality;
import com.hedera.node.app.hapi.utils.CommonPbjConverters;
import com.hedera.node.app.hapi.utils.ethereum.EthTxData;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ScaleFactor;
import com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleBucket;
import com.hedera.node.app.hapi.utils.throttles.DeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.LeakyBucketDeterministicThrottle;
import com.hedera.node.app.hapi.utils.throttles.OpsDurationDeterministicThrottle;
import com.hedera.node.app.service.entityid.ReadableEntityCounters;
import com.hedera.node.app.service.entityid.impl.ReadableEntityIdStoreImpl;
import com.hedera.node.app.service.schedule.impl.ReadableScheduleStoreImpl;
import com.hedera.node.app.service.schedule.impl.handlers.HandlerUtility;
import com.hedera.node.app.service.token.AliasUtils;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.spi.workflows.HandleException;
import com.hedera.node.app.store.ReadableStoreFactoryImpl;
import com.hedera.node.app.throttle.BucketThrottleUsage;
import com.hedera.node.app.throttle.ThrottleMetrics;
import com.hedera.node.app.throttle.ThrottleReqsManager;
import com.hedera.node.app.throttle.ThrottleUsage;
import com.hedera.node.app.workflows.TransactionInfo;
import com.hedera.node.config.data.AccountsConfig;
import com.hedera.node.config.data.ContractsConfig;
import com.hedera.node.config.data.EntitiesConfig;
import com.hedera.node.config.data.HederaConfig;
import com.hedera.node.config.data.JumboTransactionsConfig;
import com.hedera.node.config.data.LedgerConfig;
import com.hedera.node.config.data.SchedulingConfig;
import com.hedera.node.config.data.TokensConfig;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import com.swirlds.state.State;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.math.BigInteger;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ThrottleAccumulator {
    private static final Logger log = LogManager.getLogger(ThrottleAccumulator.class);
    private static final Set<HederaFunctionality> CONTRACT_FUNCTIONS = EnumSet.of(HederaFunctionality.CONTRACT_CALL_LOCAL, HederaFunctionality.CONTRACT_CALL, HederaFunctionality.CONTRACT_CREATE, HederaFunctionality.ETHEREUM_TRANSACTION, HederaFunctionality.HOOK_DISPATCH);
    private static final Set<HederaFunctionality> AUTO_CREATE_FUNCTIONS = EnumSet.of(HederaFunctionality.CRYPTO_TRANSFER, HederaFunctionality.ETHEREUM_TRANSACTION);
    private static final int UNKNOWN_NUM_IMPLICIT_CREATIONS = -1;
    private EnumMap<HederaFunctionality, ThrottleReqsManager> functionReqs = new EnumMap(HederaFunctionality.class);
    private EnumMap<HederaFunctionality, ThrottleReqsManager> highVolumeFunctionReqs = new EnumMap(HederaFunctionality.class);
    private boolean lastTxnWasGasThrottled;
    private LeakyBucketDeterministicThrottle bytesThrottle;
    private LeakyBucketDeterministicThrottle gasThrottle;
    private OpsDurationDeterministicThrottle contractOpsDurationThrottle;
    private List<DeterministicThrottle> activeThrottles = Collections.emptyList();
    private List<DeterministicThrottle> highVolumeActiveThrottles = Collections.emptyList();
    @Nullable
    private final ThrottleMetrics throttleMetrics;
    private final Supplier<Configuration> configSupplier;
    private final IntSupplier capacitySplitSource;
    private final ThrottleType throttleType;
    private final Verbose verbose;

    public ThrottleAccumulator(@NonNull Supplier<Configuration> configSupplier, @NonNull IntSupplier capacitySplitSource, @NonNull ThrottleType throttleType) {
        this(capacitySplitSource, configSupplier, throttleType, null, Verbose.NO);
    }

    public ThrottleAccumulator(@NonNull IntSupplier capacitySplitSource, @NonNull Supplier<Configuration> configSupplier, @NonNull ThrottleType throttleType, @Nullable ThrottleMetrics throttleMetrics, @NonNull Verbose verbose) {
        this.configSupplier = Objects.requireNonNull(configSupplier, "configProvider must not be null");
        this.capacitySplitSource = Objects.requireNonNull(capacitySplitSource, "capacitySplitSource must not be null");
        this.throttleType = Objects.requireNonNull(throttleType, "throttleType must not be null");
        this.verbose = Objects.requireNonNull(verbose);
        this.throttleMetrics = throttleMetrics;
    }

    @VisibleForTesting
    public ThrottleAccumulator(@NonNull IntSupplier capacitySplitSource, @NonNull Supplier<Configuration> configSupplier, @NonNull ThrottleType throttleType, @NonNull ThrottleMetrics throttleMetrics, @NonNull LeakyBucketDeterministicThrottle gasThrottle, @NonNull LeakyBucketDeterministicThrottle bytesThrottle, @NonNull OpsDurationDeterministicThrottle contractOsDurationThrottle) {
        this.configSupplier = Objects.requireNonNull(configSupplier, "configProvider must not be null");
        this.capacitySplitSource = Objects.requireNonNull(capacitySplitSource, "capacitySplitSource must not be null");
        this.throttleType = Objects.requireNonNull(throttleType, "throttleType must not be null");
        this.gasThrottle = Objects.requireNonNull(gasThrottle, "gasThrottle must not be null");
        this.bytesThrottle = Objects.requireNonNull(bytesThrottle, "bytesThrottle must not be null");
        this.contractOpsDurationThrottle = Objects.requireNonNull(contractOsDurationThrottle, "contractOsDurationThrottle must not be null");
        this.throttleMetrics = throttleMetrics;
        this.throttleMetrics.setupGasThrottleMetric(gasThrottle, configSupplier.get());
        this.verbose = Verbose.YES;
    }

    public boolean checkAndEnforceThrottle(@NonNull TransactionInfo txnInfo, @NonNull Instant now, @NonNull State state, @Nullable List<ThrottleUsage> throttleUsages, boolean gasThrottleAlwaysEnabled) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return false;
        }
        int initialThrottleUsagesSize = throttleUsages == null ? 0 : throttleUsages.size();
        this.resetLastAllowedUse();
        this.lastTxnWasGasThrottled = false;
        if (this.shouldThrottleTxn(txnInfo, now, state, throttleUsages, gasThrottleAlwaysEnabled)) {
            int currentSize;
            this.reclaimLastAllowedUse();
            if (throttleUsages != null && (currentSize = throttleUsages.size()) > initialThrottleUsagesSize) {
                throttleUsages.subList(initialThrottleUsagesSize, currentSize).clear();
            }
            return true;
        }
        return false;
    }

    public long availableOpsDurationCapacity(@NonNull Instant now) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return Long.MAX_VALUE;
        }
        return this.contractOpsDurationThrottle.capacityFree(now);
    }

    public void consumeOpsDurationThrottleCapacity(long opsDurationUnitsToConsume, @NonNull Instant now) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return;
        }
        this.contractOpsDurationThrottle.useCapacity(now, opsDurationUnitsToConsume);
    }

    public boolean checkAndEnforceThrottle(@NonNull HederaFunctionality queryFunction, @NonNull Instant now, @NonNull Query query, @NonNull State state, @Nullable AccountID queryPayerId) {
        boolean allReqMet;
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return false;
        }
        Configuration configuration = this.configSupplier.get();
        if (ThrottleAccumulator.throttleExempt(queryPayerId, configuration)) {
            return false;
        }
        if (ThrottleAccumulator.isGasThrottled(queryFunction)) {
            boolean enforceGasThrottle = ((ContractsConfig)configuration.getConfigData(ContractsConfig.class)).throttleThrottleByGas();
            return enforceGasThrottle && !this.gasThrottle.allow(now, query.contractCallLocalOrElse(ContractCallLocalQuery.DEFAULT).gas());
        }
        this.resetLastAllowedUse();
        ThrottleReqsManager manager = this.functionReqs.get(queryFunction);
        if (manager == null) {
            return true;
        }
        if (queryFunction == HederaFunctionality.CRYPTO_GET_ACCOUNT_BALANCE && ((TokensConfig)configuration.getConfigData(TokensConfig.class)).countingGetBalanceThrottleEnabled()) {
            ReadableAccountStore accountStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableAccountStore.class);
            TokensConfig tokenConfig = (TokensConfig)configuration.getConfigData(TokensConfig.class);
            int associationCount = Math.clamp((long)this.getAssociationCount(query, accountStore), 1, tokenConfig.maxRelsPerInfoQuery());
            allReqMet = manager.allReqsMetAt(now, associationCount, ScaleFactor.ONE_TO_ONE, null);
        } else {
            allReqMet = manager.allReqsMetAt(now, null);
        }
        if (!allReqMet) {
            this.reclaimLastAllowedUse();
            return true;
        }
        return false;
    }

    private int getAssociationCount(@NonNull Query query, @NonNull ReadableAccountStore accountStore) {
        Account account;
        AccountID accountID = query.cryptogetAccountBalanceOrThrow().accountID();
        if (accountID != null && (account = accountStore.getAliasedAccountById(accountID)) != null) {
            return account.numberAssociations();
        }
        return 0;
    }

    public boolean shouldThrottleNOfUnscaled(int n, @NonNull HederaFunctionality function, @NonNull Instant consensusTime) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return false;
        }
        this.resetLastAllowedUse();
        ThrottleReqsManager manager = this.functionReqs.get(function);
        if (manager == null) {
            return true;
        }
        if (!manager.allReqsMetAt(consensusTime, n, ScaleFactor.ONE_TO_ONE, null)) {
            this.reclaimLastAllowedUse();
            return true;
        }
        return false;
    }

    public void leakCapacityForNOfUnscaled(int n, @NonNull HederaFunctionality function) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return;
        }
        ThrottleReqsManager manager = Objects.requireNonNull(this.functionReqs.get(function));
        manager.undoClaimedReqsFor(n);
    }

    public void leakUnusedGasPreviouslyReserved(@NonNull TransactionInfo txnInfo, long value) {
        if (this.throttleType == ThrottleType.NOOP_THROTTLE) {
            return;
        }
        Configuration configuration = this.configSupplier.get();
        if (ThrottleAccumulator.throttleExempt(txnInfo.payerID(), configuration)) {
            return;
        }
        this.gasThrottle.leakUnusedGasPreviouslyReserved(value);
    }

    @NonNull
    public List<DeterministicThrottle> allActiveThrottles() {
        return this.activeThrottles;
    }

    @NonNull
    public List<DeterministicThrottle> activeThrottlesFor(@NonNull HederaFunctionality function) {
        ThrottleReqsManager manager = this.functionReqs.get(function);
        if (manager == null) {
            return Collections.emptyList();
        }
        return manager.managedThrottles();
    }

    public boolean wasLastTxnGasThrottled() {
        return this.lastTxnWasGasThrottled;
    }

    public static boolean isGasThrottled(@NonNull HederaFunctionality functionality) {
        return CONTRACT_FUNCTIONS.contains(functionality);
    }

    public static boolean canAutoCreate(@NonNull HederaFunctionality function) {
        return AUTO_CREATE_FUNCTIONS.contains(function);
    }

    public static boolean canAutoAssociate(@NonNull HederaFunctionality function) {
        return function == HederaFunctionality.CRYPTO_TRANSFER;
    }

    public void updateAllMetrics() {
        if (this.throttleMetrics != null) {
            this.throttleMetrics.updateAllMetrics();
        }
    }

    private boolean shouldThrottleTxn(@NonNull TransactionInfo txnInfo, @NonNull Instant now, @NonNull State state, @Nullable List<ThrottleUsage> throttleUsages, boolean gasThrottleAlwaysEnabled) {
        ThrottleReqsManager effectiveManager;
        boolean isHighVolumeTxn;
        Set allowedHederaFunctionalities;
        boolean shouldThrottleByGas;
        HederaFunctionality function = txnInfo.functionality();
        TransactionBody txBody = txnInfo.txBody();
        Configuration configuration = this.configSupplier.get();
        boolean isJumboTransactionsEnabled = ((JumboTransactionsConfig)configuration.getConfigData(JumboTransactionsConfig.class)).isEnabled();
        boolean isPayerThrottleExempt = ThrottleAccumulator.throttleExempt(txnInfo.payerID(), configuration);
        if (isPayerThrottleExempt) {
            return false;
        }
        boolean throttleByGasFlag = ((ContractsConfig)configuration.getConfigData(ContractsConfig.class)).throttleThrottleByGas();
        boolean bl = shouldThrottleByGas = throttleByGasFlag || gasThrottleAlwaysEnabled;
        if (shouldThrottleByGas && this.isGasExhausted(txnInfo, now, throttleUsages)) {
            this.lastTxnWasGasThrottled = true;
            return true;
        }
        if (isJumboTransactionsEnabled && (allowedHederaFunctionalities = ((JumboTransactionsConfig)configuration.getConfigData(JumboTransactionsConfig.class)).allowedHederaFunctionalities()).contains(CommonPbjConverters.fromPbj((HederaFunctionality)txnInfo.functionality()))) {
            int maxRegularTxnSize;
            int excessBytes;
            int bytesUsage = txnInfo.signedTx().protobufSize();
            int n = excessBytes = bytesUsage > (maxRegularTxnSize = ((HederaConfig)configuration.getConfigData(HederaConfig.class)).transactionMaxBytes()) ? bytesUsage - maxRegularTxnSize : 0;
            if (this.shouldThrottleBasedExcessBytes(excessBytes, now, throttleUsages)) {
                return true;
            }
        }
        EnumMap<HederaFunctionality, ThrottleReqsManager> targetFunctionReqs = (isHighVolumeTxn = txBody.highVolume()) ? this.highVolumeFunctionReqs : this.functionReqs;
        ThrottleReqsManager manager = targetFunctionReqs.get(function);
        ThrottleReqsManager throttleReqsManager = effectiveManager = manager == null && isHighVolumeTxn ? this.functionReqs.get(function) : manager;
        if (effectiveManager == null) {
            return true;
        }
        return switch (function) {
            case HederaFunctionality.SCHEDULE_CREATE -> this.shouldThrottleScheduleCreate(effectiveManager, txnInfo, now, state, throttleUsages);
            case HederaFunctionality.TOKEN_MINT -> this.shouldThrottleMint(effectiveManager, txBody.tokenMintOrThrow(), now, configuration, throttleUsages);
            case HederaFunctionality.CRYPTO_TRANSFER -> {
                ReadableAccountStore accountStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableAccountStore.class);
                ReadableTokenRelationStore relationStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableTokenRelationStore.class);
                yield this.shouldThrottleCryptoTransfer(effectiveManager, now, configuration, this.getImplicitCreationsCount(txBody, accountStore), this.getAutoAssociationsCount(txBody, relationStore), throttleUsages);
            }
            case HederaFunctionality.ETHEREUM_TRANSACTION -> {
                ReadableAccountStore accountStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableAccountStore.class);
                yield this.shouldThrottleEthTxn(effectiveManager, now, this.getImplicitCreationsCount(txBody, accountStore), throttleUsages);
            }
            default -> !effectiveManager.allReqsMetAt(now, throttleUsages);
        };
    }

    private boolean shouldThrottleScheduleCreate(ThrottleReqsManager manager, TransactionInfo txnInfo, Instant now, State state, List<ThrottleUsage> throttleUsages) {
        HederaFunctionality scheduledFunction;
        TransactionBody txnBody = txnInfo.txBody();
        ScheduleCreateTransactionBody op = txnBody.scheduleCreateOrThrow();
        if (!op.hasScheduledTransactionBody()) {
            return true;
        }
        SchedulableTransactionBody scheduled = op.scheduledTransactionBodyOrThrow();
        Schedule schedule = Schedule.newBuilder().originalCreateTransaction(txnBody).payerAccountId(txnInfo.payerID()).scheduledTransaction(scheduled).build();
        try {
            TransactionBody innerTxn = HandlerUtility.childAsOrdinary((Schedule)schedule);
            scheduledFunction = HapiUtils.functionOf((TransactionBody)innerTxn);
        }
        catch (UnknownHederaFunctionality | HandleException ex) {
            log.debug("ScheduleCreate was associated with an invalid txn.", ex);
            return true;
        }
        Configuration config = this.configSupplier.get();
        SchedulingConfig schedulingConfig = (SchedulingConfig)config.getConfigData(SchedulingConfig.class);
        if (!schedulingConfig.longTermEnabled()) {
            CryptoTransferTransactionBody transfer;
            if (scheduledFunction == HederaFunctionality.CRYPTO_TRANSFER && this.usesAliases(transfer = scheduled.cryptoTransferOrThrow())) {
                ReadableAccountStore accountStore = new ReadableStoreFactoryImpl(state).readableStore(ReadableAccountStore.class);
                TransactionBody transferTxnBody = TransactionBody.newBuilder().cryptoTransfer(transfer).build();
                int implicitCreationsCount = this.getImplicitCreationsCount(transferTxnBody, accountStore);
                if (implicitCreationsCount > 0) {
                    return this.shouldThrottleImplicitCreations(implicitCreationsCount, now, throttleUsages);
                }
            }
            return !manager.allReqsMetAt(now, throttleUsages);
        }
        if (!manager.allReqsMetAt(now, throttleUsages)) {
            return true;
        }
        if (this.throttleType == ThrottleType.FRONTEND_THROTTLE) {
            long expiry;
            if (op.waitForExpiry()) {
                expiry = op.expirationTimeOrElse(Timestamp.DEFAULT).seconds();
            } else {
                LedgerConfig ledgerConfig = (LedgerConfig)config.getConfigData(LedgerConfig.class);
                expiry = Optional.ofNullable(txnInfo.transactionID()).orElse(TransactionID.DEFAULT).transactionValidStartOrElse(Timestamp.DEFAULT).seconds() + (long)ledgerConfig.scheduleTxExpiryTimeSecs();
            }
            ReadableEntityIdStoreImpl entityIdStore = new ReadableEntityIdStoreImpl(state.getReadableStates("EntityIdService"));
            ReadableScheduleStoreImpl scheduleStore = new ReadableScheduleStoreImpl(state.getReadableStates("ScheduleService"), (ReadableEntityCounters)entityIdStore);
            int numScheduled = scheduleStore.numTransactionsScheduledAt(expiry);
            return numScheduled >= schedulingConfig.maxTxnPerSec();
        }
        return false;
    }

    private static boolean throttleExempt(@Nullable AccountID accountID, @NonNull Configuration configuration) {
        long maxThrottleExemptNum = ((AccountsConfig)configuration.getConfigData(AccountsConfig.class)).lastThrottleExempt();
        if (accountID != null) {
            Long accountNum = accountID.accountNumOrElse(Long.valueOf(0L));
            return 1L <= accountNum && accountNum <= maxThrottleExemptNum;
        }
        return false;
    }

    private void reclaimLastAllowedUse() {
        this.activeThrottles.forEach(DeterministicThrottle::reclaimLastAllowedUse);
        this.gasThrottle.reclaimLastAllowedUse();
    }

    private void resetLastAllowedUse() {
        this.activeThrottles.forEach(DeterministicThrottle::resetLastAllowedUse);
        this.gasThrottle.resetLastAllowedUse();
    }

    private long getGasLimitForContractTx(@NonNull TransactionBody txnBody, @NonNull HederaFunctionality function) {
        long nominalGas = switch (function) {
            case HederaFunctionality.CONTRACT_CREATE -> txnBody.contractCreateInstanceOrThrow().gas();
            case HederaFunctionality.CONTRACT_CALL -> txnBody.contractCallOrThrow().gas();
            case HederaFunctionality.ETHEREUM_TRANSACTION -> Optional.of(txnBody.ethereumTransactionOrThrow().ethereumData().toByteArray()).map(EthTxData::populateEthTxData).map(EthTxData::gasLimit).orElse(0L);
            case HederaFunctionality.HOOK_DISPATCH -> txnBody.hookDispatchOrThrow().executionOrElse(HookExecution.DEFAULT).callOrElse(HookCall.DEFAULT).evmHookCallOrElse(EvmHookCall.DEFAULT).gasLimit();
            default -> 0L;
        };
        return nominalGas < 0L ? Long.MAX_VALUE : nominalGas;
    }

    private boolean isGasExhausted(@NonNull TransactionInfo txnInfo, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        if (ThrottleAccumulator.isGasThrottled(txnInfo.functionality())) {
            boolean answer;
            long amount = this.getGasLimitForContractTx(txnInfo.txBody(), txnInfo.functionality());
            boolean bl = answer = !this.gasThrottle.allow(now, amount);
            if (!answer && throttleUsages != null) {
                throttleUsages.add(new BucketThrottleUsage(this.gasThrottle, amount));
            }
            return answer;
        }
        this.gasThrottle.leakUntil(now);
        return false;
    }

    private boolean shouldThrottleMint(@NonNull ThrottleReqsManager manager, @NonNull TokenMintTransactionBody op, @NonNull Instant now, @NonNull Configuration configuration, List<ThrottleUsage> throttleUsages) {
        int numNfts = op.metadata().size();
        if (numNfts == 0) {
            return !manager.allReqsMetAt(now, throttleUsages);
        }
        ScaleFactor nftsMintThrottleScaleFactor = ((TokensConfig)configuration.getConfigData(TokensConfig.class)).nftsMintThrottleScaleFactor();
        return !manager.allReqsMetAt(now, numNfts, nftsMintThrottleScaleFactor, throttleUsages);
    }

    private boolean shouldThrottleCryptoTransfer(@NonNull ThrottleReqsManager manager, @NonNull Instant now, @NonNull Configuration configuration, int implicitCreationsCount, int autoAssociationsCount, List<ThrottleUsage> throttleUsages) {
        boolean unlimitedAutoAssociations = ((EntitiesConfig)configuration.getConfigData(EntitiesConfig.class)).unlimitedAutoAssociationsEnabled();
        if (implicitCreationsCount > 0) {
            return this.shouldThrottleBasedOnImplicitCreations(manager, implicitCreationsCount, now, throttleUsages);
        }
        if (unlimitedAutoAssociations && autoAssociationsCount > 0) {
            return this.shouldThrottleBasedOnAutoAssociations(manager, autoAssociationsCount, now, throttleUsages);
        }
        return !manager.allReqsMetAt(now, throttleUsages);
    }

    private boolean shouldThrottleEthTxn(@NonNull ThrottleReqsManager manager, @NonNull Instant now, int implicitCreationsCount, @Nullable List<ThrottleUsage> throttleUsages) {
        return this.shouldThrottleBasedOnImplicitCreations(manager, implicitCreationsCount, now, throttleUsages);
    }

    public int getImplicitCreationsCount(@NonNull TransactionBody txnBody, @NonNull ReadableAccountStore accountStore) {
        int implicitCreationsCount = 0;
        if (txnBody.hasEthereumTransaction()) {
            boolean doesNotExist;
            EthTxData ethTxData = EthTxData.populateEthTxData((byte[])txnBody.ethereumTransaction().ethereumData().toByteArray());
            if (ethTxData == null) {
                return -1;
            }
            HederaConfig config = (HederaConfig)this.configSupplier.get().getConfigData(HederaConfig.class);
            boolean bl = doesNotExist = !accountStore.containsAlias(config.shard(), config.realm(), Bytes.wrap((byte[])ethTxData.to()));
            if (doesNotExist && ethTxData.value().compareTo(BigInteger.ZERO) > 0) {
                ++implicitCreationsCount;
            }
        } else {
            CryptoTransferTransactionBody cryptoTransferBody = txnBody.cryptoTransfer();
            if (cryptoTransferBody == null) {
                return 0;
            }
            implicitCreationsCount += this.hbarAdjustsImplicitCreationsCount(accountStore, cryptoTransferBody);
            implicitCreationsCount += this.tokenAdjustsImplicitCreationsCount(accountStore, cryptoTransferBody);
        }
        return implicitCreationsCount;
    }

    public int getAutoAssociationsCount(@NonNull TransactionBody txnBody, @NonNull ReadableTokenRelationStore relationStore) {
        int autoAssociationsCount = 0;
        CryptoTransferTransactionBody cryptoTransferBody = txnBody.cryptoTransfer();
        if (cryptoTransferBody == null || cryptoTransferBody.tokenTransfers().isEmpty()) {
            return 0;
        }
        for (TokenTransferList transfer : cryptoTransferBody.tokenTransfers()) {
            TokenID tokenID = transfer.token();
            autoAssociationsCount += (int)transfer.transfers().stream().filter(accountAmount -> accountAmount.amount() > 0L).map(AccountAmount::accountID).filter(accountID -> this.hasNoRelation(relationStore, (AccountID)accountID, tokenID)).count();
            autoAssociationsCount += (int)transfer.nftTransfers().stream().map(NftTransfer::receiverAccountID).filter(receiverID -> this.hasNoRelation(relationStore, (AccountID)receiverID, tokenID)).count();
        }
        return autoAssociationsCount;
    }

    private boolean hasNoRelation(@NonNull ReadableTokenRelationStore relationStore, @NonNull AccountID accountID, @NonNull TokenID tokenID) {
        return relationStore.get(accountID, tokenID) == null;
    }

    private int hbarAdjustsImplicitCreationsCount(@NonNull ReadableAccountStore accountStore, @NonNull CryptoTransferTransactionBody cryptoTransferBody) {
        if (cryptoTransferBody.transfers() == null) {
            return 0;
        }
        int implicitCreationsCount = 0;
        for (AccountAmount adjust : cryptoTransferBody.transfers().accountAmounts()) {
            if (!this.referencesAliasNotInUse(adjust.accountIDOrElse(AccountID.DEFAULT), accountStore) || !this.isPlausibleAutoCreate(adjust)) continue;
            ++implicitCreationsCount;
        }
        return implicitCreationsCount;
    }

    private int tokenAdjustsImplicitCreationsCount(@NonNull ReadableAccountStore accountStore, @NonNull CryptoTransferTransactionBody cryptoTransferBody) {
        if (cryptoTransferBody.tokenTransfers().isEmpty()) {
            return 0;
        }
        int implicitCreationsCount = 0;
        for (TokenTransferList tokenAdjust : cryptoTransferBody.tokenTransfers()) {
            for (AccountAmount adjust : tokenAdjust.transfers()) {
                if (!adjust.hasAccountID() || !this.referencesAliasNotInUse(adjust.accountIDOrThrow(), accountStore) || !this.isPlausibleAutoCreate(adjust)) continue;
                ++implicitCreationsCount;
            }
            for (NftTransfer change : tokenAdjust.nftTransfers()) {
                if (!change.hasReceiverAccountID() || !this.referencesAliasNotInUse(change.receiverAccountIDOrThrow(), accountStore) || !this.isPlausibleAutoCreate(change)) continue;
                ++implicitCreationsCount;
            }
        }
        return implicitCreationsCount;
    }

    private boolean usesAliases(CryptoTransferTransactionBody transferBody) {
        for (AccountAmount adjust : transferBody.transfersOrElse(TransferList.DEFAULT).accountAmounts()) {
            if (!AliasUtils.isAlias((AccountID)adjust.accountIDOrElse(AccountID.DEFAULT))) continue;
            return true;
        }
        for (TokenTransferList tokenAdjusts : transferBody.tokenTransfers()) {
            for (NftTransfer ownershipChange : tokenAdjusts.nftTransfers()) {
                if (!AliasUtils.isAlias((AccountID)ownershipChange.senderAccountIDOrElse(AccountID.DEFAULT)) && !AliasUtils.isAlias((AccountID)ownershipChange.receiverAccountIDOrElse(AccountID.DEFAULT))) continue;
                return true;
            }
            for (AccountAmount tokenAdjust : tokenAdjusts.transfers()) {
                if (!AliasUtils.isAlias((AccountID)tokenAdjust.accountIDOrElse(AccountID.DEFAULT))) continue;
                return true;
            }
        }
        return false;
    }

    private boolean referencesAliasNotInUse(@NonNull AccountID idOrAlias, @NonNull ReadableAccountStore accountStore) {
        if (AliasUtils.isAlias((AccountID)idOrAlias)) {
            Bytes alias = idOrAlias.aliasOrElse(Bytes.EMPTY);
            if (AliasUtils.isOfEvmAddressSize((Bytes)alias) && AliasUtils.isEntityNumAlias((Bytes)alias)) {
                return false;
            }
            return accountStore.getAccountIDByAlias(idOrAlias.shardNum(), idOrAlias.realmNum(), alias) == null;
        }
        return false;
    }

    private boolean isPlausibleAutoCreate(@NonNull AccountAmount adjust) {
        return this.isPlausibleAutoCreate(adjust.amount(), adjust.accountIDOrElse(AccountID.DEFAULT).aliasOrElse(Bytes.EMPTY));
    }

    private boolean isPlausibleAutoCreate(@NonNull NftTransfer change) {
        return this.isPlausibleAutoCreate(change.serialNumber(), change.receiverAccountIDOrElse(AccountID.DEFAULT).aliasOrElse(Bytes.EMPTY));
    }

    private boolean isPlausibleAutoCreate(long assetChange, @NonNull Bytes alias) {
        if (assetChange > 0L) {
            if (AliasUtils.isSerializedProtoKey((Bytes)alias)) {
                return true;
            }
            return AliasUtils.isOfEvmAddressSize((Bytes)alias);
        }
        return false;
    }

    private boolean shouldThrottleBasedOnImplicitCreations(@NonNull ThrottleReqsManager manager, int implicitCreationsCount, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        return implicitCreationsCount == 0 ? !manager.allReqsMetAt(now, throttleUsages) : this.shouldThrottleImplicitCreations(implicitCreationsCount, now, throttleUsages);
    }

    private boolean shouldThrottleBasedExcessBytes(long bytesUsed, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        boolean shouldThrottle;
        boolean bl = shouldThrottle = this.bytesThrottle != null && !this.bytesThrottle.allow(now, bytesUsed);
        if (!shouldThrottle && throttleUsages != null) {
            throttleUsages.add(new BucketThrottleUsage(this.bytesThrottle, bytesUsed));
        }
        return shouldThrottle;
    }

    private boolean shouldThrottleBasedOnAutoAssociations(@NonNull ThrottleReqsManager manager, int autoAssociations, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        return autoAssociations == 0 ? !manager.allReqsMetAt(now, throttleUsages) : this.shouldThrottleAutoAssociations(autoAssociations, now, throttleUsages);
    }

    private boolean shouldThrottleImplicitCreations(int n, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        ThrottleReqsManager manager = this.functionReqs.get(HederaFunctionality.CRYPTO_CREATE);
        return manager == null || !manager.allReqsMetAt(now, n, ScaleFactor.ONE_TO_ONE, throttleUsages);
    }

    private boolean shouldThrottleAutoAssociations(int n, @NonNull Instant now, @Nullable List<ThrottleUsage> throttleUsages) {
        ThrottleReqsManager manager = this.functionReqs.get(HederaFunctionality.TOKEN_ASSOCIATE_TO_ACCOUNT);
        return manager == null || !manager.allReqsMetAt(now, n, ScaleFactor.ONE_TO_ONE, throttleUsages);
    }

    public void rebuildFor(@NonNull ThrottleDefinitions defs) {
        ArrayList<DeterministicThrottle> newActiveThrottles = new ArrayList<DeterministicThrottle>();
        ArrayList<DeterministicThrottle> newHighVolumeActiveThrottles = new ArrayList<DeterministicThrottle>();
        EnumMap<HederaFunctionality, List> reqLists = new EnumMap<HederaFunctionality, List>(HederaFunctionality.class);
        EnumMap<HederaFunctionality, List> highVolumeReqLists = new EnumMap<HederaFunctionality, List>(HederaFunctionality.class);
        for (com.hedera.hapi.node.transaction.ThrottleBucket bucket : defs.throttleBuckets()) {
            try {
                boolean isHighVolume = bucket.highVolume();
                ThrottleBucket utilThrottleBucket = new ThrottleBucket(bucket.burstPeriodMs(), bucket.name(), bucket.throttleGroups().stream().map(this::hapiGroupFromPbj).toList(), isHighVolume);
                Pair mapping = utilThrottleBucket.asThrottleMapping((long)this.capacitySplitSource.getAsInt());
                DeterministicThrottle throttle = (DeterministicThrottle)mapping.getLeft();
                List reqs2 = (List)mapping.getRight();
                EnumMap<HederaFunctionality, List> targetReqLists = isHighVolume ? highVolumeReqLists : reqLists;
                ArrayList<DeterministicThrottle> targetThrottles = isHighVolume ? newHighVolumeActiveThrottles : newActiveThrottles;
                for (Pair req : reqs2) {
                    targetReqLists.computeIfAbsent((HederaFunctionality)req.getLeft(), ignore -> new ArrayList()).add(Pair.of((Object)throttle, (Object)((Integer)req.getRight())));
                }
                targetThrottles.add(throttle);
            }
            catch (IllegalStateException badBucket) {
                log.error("When constructing bucket '{}' from state: {}", (Object)bucket.name(), (Object)badBucket.getMessage());
            }
        }
        EnumMap newFunctionReqs = new EnumMap(HederaFunctionality.class);
        reqLists.forEach((function, reqs) -> newFunctionReqs.put((HederaFunctionality)function, new ThrottleReqsManager((List<Pair<DeterministicThrottle, Integer>>)reqs)));
        EnumMap newHighVolumeFunctionReqs = new EnumMap(HederaFunctionality.class);
        highVolumeReqLists.forEach((function, reqs) -> newHighVolumeFunctionReqs.put((HederaFunctionality)function, new ThrottleReqsManager((List<Pair<DeterministicThrottle, Integer>>)reqs)));
        this.functionReqs = newFunctionReqs;
        this.highVolumeFunctionReqs = newHighVolumeFunctionReqs;
        this.activeThrottles = newActiveThrottles;
        this.highVolumeActiveThrottles = newHighVolumeActiveThrottles;
        if (this.throttleMetrics != null) {
            Configuration configuration = this.configSupplier.get();
            this.throttleMetrics.setupThrottleMetrics(this.activeThrottles, configuration);
            this.throttleMetrics.setupThrottleMetrics(this.highVolumeActiveThrottles, configuration);
        }
        this.logResolvedDefinitions(this.capacitySplitSource.getAsInt());
    }

    public void applyGasConfig() {
        Configuration configuration = this.configSupplier.get();
        ContractsConfig contractsConfig = (ContractsConfig)configuration.getConfigData(ContractsConfig.class);
        long maxGasPerSec = this.maxGasPerSecOf(contractsConfig);
        if (contractsConfig.throttleThrottleByGas() && maxGasPerSec == 0L) {
            log.warn("{} gas throttling enabled, but limited to 0 gas/sec", (Object)this.throttleType.name());
        }
        this.gasThrottle = new LeakyBucketDeterministicThrottle(maxGasPerSec, "Gas", 1);
        if (this.throttleMetrics != null) {
            this.throttleMetrics.setupGasThrottleMetric(this.gasThrottle, configuration);
        }
        if (this.verbose == Verbose.YES) {
            log.info("Resolved {} gas throttle -\n {} gas/sec (throttling {})", (Object)this.throttleType.name(), (Object)this.gasThrottle.capacity(), (Object)(contractsConfig.throttleThrottleByGas() ? "ON" : "OFF"));
        }
    }

    private long maxGasPerSecOf(@NonNull ContractsConfig contractsConfig) {
        return this.throttleType.equals((Object)ThrottleType.BACKEND_THROTTLE) ? contractsConfig.maxGasPerSecBackend() : contractsConfig.maxGasPerSec();
    }

    public void applyBytesConfig() {
        Configuration configuration = this.configSupplier.get();
        JumboTransactionsConfig jumboConfig = (JumboTransactionsConfig)configuration.getConfigData(JumboTransactionsConfig.class);
        long bytesPerSec = jumboConfig.maxBytesPerSec();
        if (jumboConfig.isEnabled() && bytesPerSec == 0L) {
            log.warn("{} jumbo transactions are enabled, but limited to 0 bytes/sec", (Object)this.throttleType.name());
        }
        this.bytesThrottle = new LeakyBucketDeterministicThrottle(bytesPerSec, "Bytes", 1);
        if (this.throttleMetrics != null) {
            this.throttleMetrics.setupBytesThrottleMetric(this.bytesThrottle, configuration);
        }
        if (this.verbose == Verbose.YES) {
            log.info("Resolved {} bytes throttle -\n {} bytes/sec (throttling {})", (Object)this.throttleType.name(), (Object)this.bytesThrottle.capacity(), (Object)(jumboConfig.isEnabled() ? "ON" : "OFF"));
        }
    }

    public void applyDurationConfig() {
        Configuration configuration = this.configSupplier.get();
        ContractsConfig contractConfig = (ContractsConfig)configuration.getConfigData(ContractsConfig.class);
        long opsDurationThrottleCapacity = contractConfig.opsDurationThrottleCapacity();
        long opsDurationThrottleUnitsFreedPerSecond = contractConfig.opsDurationThrottleUnitsFreedPerSecond();
        if (contractConfig.throttleThrottleByOpsDuration() && (opsDurationThrottleCapacity == 0L || opsDurationThrottleUnitsFreedPerSecond == 0L)) {
            log.info("{} ops duration throttles are enabled, but either capacity or leak rate is 0", (Object)this.throttleType.name());
        }
        this.contractOpsDurationThrottle = new OpsDurationDeterministicThrottle("OpsDuration", opsDurationThrottleCapacity, opsDurationThrottleUnitsFreedPerSecond);
        if (this.throttleMetrics != null) {
            this.throttleMetrics.setupOpsDurationMetric(this.contractOpsDurationThrottle, configuration);
        }
        if (this.verbose == Verbose.YES) {
            log.info("Resolved {} ops duration throttle -\n {} ops duration/sec (throttling {})", (Object)this.throttleType.name(), (Object)this.contractOpsDurationThrottle.capacity(), (Object)(contractConfig.throttleThrottleByOpsDuration() ? "ON" : "OFF"));
        }
    }

    @NonNull
    private com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleGroup<HederaFunctionality> hapiGroupFromPbj(@NonNull ThrottleGroup pbjThrottleGroup) {
        return new com.hedera.node.app.hapi.utils.sysfiles.domain.throttling.ThrottleGroup(pbjThrottleGroup.milliOpsPerSec(), pbjThrottleGroup.operations());
    }

    private void logResolvedDefinitions(int capacitySplit) {
        if (this.verbose != Verbose.YES) {
            return;
        }
        StringBuilder sb = new StringBuilder("Resolved ").append(this.throttleType.name()).append(" ").append("(after splitting capacity ").append(capacitySplit).append(" ways) - \n");
        this.functionReqs.entrySet().stream().sorted(Comparator.comparing(entry -> ((HederaFunctionality)entry.getKey()).toString())).forEach(entry -> {
            HederaFunctionality function = (HederaFunctionality)entry.getKey();
            ThrottleReqsManager manager = (ThrottleReqsManager)entry.getValue();
            sb.append("  ").append(function).append(": ").append(manager.asReadableRequirements()).append("\n");
        });
        if (!this.highVolumeFunctionReqs.isEmpty()) {
            sb.append("\nHigh-Volume Throttles:\n");
            this.highVolumeFunctionReqs.entrySet().stream().sorted(Comparator.comparing(entry -> ((HederaFunctionality)entry.getKey()).toString())).forEach(entry -> {
                HederaFunctionality function = (HederaFunctionality)entry.getKey();
                ThrottleReqsManager manager = (ThrottleReqsManager)entry.getValue();
                sb.append("  ").append(function).append(" (high-volume): ").append(manager.asReadableRequirements()).append("\n");
            });
        }
        log.info("{}", new org.apache.logging.log4j.util.Supplier[]{() -> sb.toString().trim()});
    }

    @NonNull
    public LeakyBucketDeterministicThrottle gasLimitThrottle() {
        return Objects.requireNonNull(this.gasThrottle, "");
    }

    @NonNull
    public LeakyBucketDeterministicThrottle bytesLimitThrottle() {
        return Objects.requireNonNull(this.bytesThrottle, "");
    }

    @NonNull
    public OpsDurationDeterministicThrottle opsDurationThrottle() {
        return Objects.requireNonNull(this.contractOpsDurationThrottle, "");
    }

    @VisibleForTesting
    public List<DeterministicThrottle> activeThrottles() {
        return this.activeThrottles;
    }

    @VisibleForTesting
    public List<DeterministicThrottle> highVolumeActiveThrottles() {
        return this.highVolumeActiveThrottles;
    }

    @VisibleForTesting
    public boolean hasHighVolumeThrottleFor(@NonNull HederaFunctionality function) {
        return this.highVolumeFunctionReqs.containsKey(function);
    }

    public static enum Verbose {
        YES,
        NO;

    }

    public static enum ThrottleType {
        FRONTEND_THROTTLE,
        BACKEND_THROTTLE,
        NOOP_THROTTLE;

    }
}

