/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.state.signed;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import org.hiero.base.concurrent.locks.AutoClosableLock;
import org.hiero.base.concurrent.locks.Locks;
import org.hiero.base.concurrent.locks.locked.Locked;
import org.hiero.consensus.state.signed.ReservedSignedState;
import org.hiero.consensus.state.signed.SignedState;

public class SignedStateReference {
    private ReservedSignedState reservedSignedState = ReservedSignedState.createNullReservation();
    private final AutoClosableLock lock = Locks.createAutoLock();

    public SignedStateReference() {
    }

    public SignedStateReference(@NonNull SignedState signedState, @NonNull String reason) {
        this.set(signedState, reason);
    }

    public void set(@Nullable SignedState signedState, @NonNull String reason) {
        try (Locked l = this.lock.lock();){
            if (signedState == this.reservedSignedState.getNullable()) {
                return;
            }
            this.reservedSignedState.close();
            this.reservedSignedState = signedState == null ? ReservedSignedState.createNullReservation() : ReservedSignedState.createAndReserve(signedState, reason);
        }
    }

    public void clear() {
        this.set(null, "");
    }

    public boolean isNull() {
        try (Locked l = this.lock.lock();){
            boolean bl = this.reservedSignedState.isNull();
            return bl;
        }
    }

    public long getRound() {
        try (Locked l = this.lock.lock();){
            long l2 = this.reservedSignedState.isNull() ? -1L : this.reservedSignedState.get().getRound();
            return l2;
        }
    }

    public ReservedSignedState getAndReserve(@NonNull String reason) {
        try (Locked l = this.lock.lock();){
            ReservedSignedState reservedSignedState = this.reservedSignedState.getAndReserve(reason);
            return reservedSignedState;
        }
    }
}

