/*
 * Decompiled with CFR 0.152.
 */
package org.hiero.consensus.gossip.impl.network.protocol.rpc;

import com.hedera.hapi.platform.event.GossipEvent;
import com.swirlds.base.time.Time;
import com.swirlds.config.api.Configuration;
import com.swirlds.logging.legacy.LogMarker;
import com.swirlds.metrics.api.Metrics;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.time.Duration;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.hiero.consensus.concurrent.pool.CachedPoolParallelExecutor;
import org.hiero.consensus.concurrent.pool.ParallelExecutor;
import org.hiero.consensus.event.IntakeEventCounter;
import org.hiero.consensus.gossip.config.BroadcastConfig;
import org.hiero.consensus.gossip.config.SyncConfig;
import org.hiero.consensus.gossip.impl.gossip.GossipController;
import org.hiero.consensus.gossip.impl.gossip.permits.SyncGuard;
import org.hiero.consensus.gossip.impl.gossip.permits.SyncGuardFactory;
import org.hiero.consensus.gossip.impl.gossip.permits.SyncPermitProvider;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.RpcPeerHandler;
import org.hiero.consensus.gossip.impl.gossip.shadowgraph.ShadowgraphSynchronizer;
import org.hiero.consensus.gossip.impl.gossip.sync.SyncMetrics;
import org.hiero.consensus.gossip.impl.network.NetworkMetrics;
import org.hiero.consensus.gossip.impl.network.NetworkUtils;
import org.hiero.consensus.gossip.impl.network.protocol.PeerProtocol;
import org.hiero.consensus.gossip.impl.network.protocol.Protocol;
import org.hiero.consensus.gossip.impl.network.protocol.rpc.RpcPeerProtocol;
import org.hiero.consensus.model.event.PlatformEvent;
import org.hiero.consensus.model.node.NodeId;
import org.hiero.consensus.model.status.PlatformStatus;
import org.hiero.consensus.monitoring.FallenBehindMonitor;

public class RpcProtocol
implements Protocol,
GossipController {
    private static final Logger logger = LogManager.getLogger(RpcProtocol.class);
    private final CachedPoolParallelExecutor executor;
    private final AtomicReference<PlatformStatus> platformStatus = new AtomicReference<PlatformStatus>(PlatformStatus.STARTING_UP);
    private final NetworkMetrics networkMetrics;
    private final Time time;
    private final SyncMetrics syncMetrics;
    private final SyncConfig syncConfig;
    private final BroadcastConfig broadcastConfig;
    private final ShadowgraphSynchronizer synchronizer;
    private final SyncPermitProvider permitProvider;
    private final AtomicBoolean gossipHalted = new AtomicBoolean(false);
    private final IntakeEventCounter intakeEventCounter;
    private final NodeId selfId;
    private final SyncGuard syncGuard;
    private final FallenBehindMonitor fallenBehindMonitor;
    private final Consumer<PlatformEvent> receivedEventHandler;
    private volatile boolean started;
    private final List<RpcPeerHandler> allRpcPeers = new CopyOnWriteArrayList<RpcPeerHandler>();

    public RpcProtocol(@NonNull Configuration configuration, @NonNull Metrics metrics, @NonNull Time time, @NonNull ShadowgraphSynchronizer synchronizer, @NonNull CachedPoolParallelExecutor executor, @NonNull IntakeEventCounter intakeEventCounter, int rosterSize, @NonNull NetworkMetrics networkMetrics, @NonNull SyncMetrics syncMetrics, @NonNull NodeId selfId, @NonNull FallenBehindMonitor fallenBehindMonitor, @NonNull Consumer<PlatformEvent> receivedEventHandler) {
        this.synchronizer = synchronizer;
        this.intakeEventCounter = Objects.requireNonNull(intakeEventCounter);
        this.syncConfig = (SyncConfig)configuration.getConfigData(SyncConfig.class);
        this.broadcastConfig = (BroadcastConfig)configuration.getConfigData(BroadcastConfig.class);
        int permitCount = this.syncConfig.onePermitPerPeer() ? rosterSize - 1 : this.syncConfig.syncProtocolPermitCount();
        this.permitProvider = new SyncPermitProvider(configuration, metrics, time, permitCount);
        this.executor = Objects.requireNonNull(executor);
        this.networkMetrics = Objects.requireNonNull(networkMetrics);
        this.time = Objects.requireNonNull(time);
        this.syncMetrics = Objects.requireNonNull(syncMetrics);
        this.selfId = selfId;
        this.syncGuard = SyncGuardFactory.create(this.syncConfig.fairMaxConcurrentSyncs(), this.syncConfig.fairMinimalRoundRobinSize(), rosterSize);
        this.fallenBehindMonitor = fallenBehindMonitor;
        this.receivedEventHandler = receivedEventHandler;
    }

    @Override
    public PeerProtocol createPeerInstance(@NonNull NodeId peerId) {
        RpcPeerProtocol peerProtocol = new RpcPeerProtocol(peerId, (ParallelExecutor)this.executor, this.gossipHalted::get, this.platformStatus::get, this.permitProvider, this.networkMetrics, this.time, this.syncMetrics, this.syncConfig, this.broadcastConfig, NetworkUtils::handleNetworkException);
        RpcPeerHandler handler = new RpcPeerHandler(this.synchronizer, peerProtocol, this.selfId, peerId, this.syncMetrics, this.time, this.intakeEventCounter, this.receivedEventHandler, this.syncGuard, this.fallenBehindMonitor, this.syncConfig, this.broadcastConfig);
        peerProtocol.setRpcPeerHandler(handler);
        this.allRpcPeers.add(handler);
        return peerProtocol;
    }

    @Override
    public void updatePlatformStatus(@NonNull PlatformStatus status) {
        this.platformStatus.set(status);
    }

    public void addEvent(@NonNull PlatformEvent platformEvent) {
        if (this.broadcastConfig.enableBroadcast() && this.selfId.equals((Object)platformEvent.getCreatorId())) {
            GossipEvent gossipEvent = platformEvent.getGossipEvent();
            this.allRpcPeers.forEach(rpcPeer -> rpcPeer.broadcastEvent(gossipEvent));
            this.syncMetrics.broadcastEventSent();
        }
    }

    public void start() {
        if (this.started) {
            throw new IllegalStateException("Gossip already started");
        }
        this.started = true;
        this.synchronizer.start();
        this.executor.start();
    }

    public void stop() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        logger.info(LogMarker.FREEZE.getMarker(), "Gossip frozen, reason: stopping gossip");
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
        this.synchronizer.stop();
        this.executor.stop();
    }

    public void adjustTotalPermits(int permitsDifference) {
        this.permitProvider.adjustTotalPermits(permitsDifference);
    }

    @Override
    public void pause() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.gossipHalted.set(true);
        this.permitProvider.waitForAllPermitsToBeReleased();
    }

    @Override
    public void resume() {
        if (!this.started) {
            throw new IllegalStateException("Gossip not started");
        }
        this.intakeEventCounter.reset();
        this.gossipHalted.set(false);
        this.permitProvider.revokeAll();
    }

    public void reportUnhealthyDuration(@NonNull Duration duration) {
        this.permitProvider.reportUnhealthyDuration(duration);
    }

    public void clear() {
        this.synchronizer.clear();
    }
}

