/*
 * Decompiled with CFR 0.152.
 */
package com.swirlds.state.merkle.vm;

import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.state.merkle.StateUtils;
import com.swirlds.state.merkle.StateValue;
import com.swirlds.state.spi.ReadableSingletonStateBase;
import com.swirlds.virtualmap.VirtualMap;
import edu.umd.cs.findbugs.annotations.NonNull;
import java.util.Objects;

public class VirtualMapReadableSingletonState<V>
extends ReadableSingletonStateBase<V> {
    @NonNull
    private final VirtualMap virtualMap;
    @NonNull
    private final Codec<StateValue<V>> stateValueCodec;

    public VirtualMapReadableSingletonState(int stateId, @NonNull String label, @NonNull Codec<V> valueCodec, @NonNull VirtualMap virtualMap) {
        super(stateId, label);
        this.stateValueCodec = new StateValue.StateValueCodec<V>(stateId, Objects.requireNonNull(valueCodec));
        this.virtualMap = Objects.requireNonNull(virtualMap);
    }

    protected V readFromDataSource() {
        Bytes key = StateUtils.getStateKeyForSingleton(this.stateId);
        StateValue stateValue = (StateValue)this.virtualMap.get(key, this.stateValueCodec);
        return stateValue != null ? (V)stateValue.value() : null;
    }
}

