/*
 * Decompiled with CFR 0.152.
 */
package org.hyperledger.besu.datatypes;

public enum RequestType {
    DEPOSIT(0),
    WITHDRAWAL(1),
    CONSOLIDATION(2);

    private final int typeValue;

    private RequestType(int typeValue) {
        this.typeValue = typeValue;
    }

    public byte getSerializedType() {
        return (byte)this.typeValue;
    }

    public static RequestType of(int serializedTypeValue) {
        return switch (serializedTypeValue) {
            case 0 -> DEPOSIT;
            case 1 -> WITHDRAWAL;
            case 2 -> CONSOLIDATION;
            default -> throw new InvalidRequestTypeException(String.format("Unsupported request type: 0x%02X", serializedTypeValue));
        };
    }

    public static class InvalidRequestTypeException
    extends IllegalArgumentException {
        public InvalidRequestTypeException(String message) {
            super(message);
        }
    }
}

