/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.types;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.types.TypeName;
import io.helidon.common.types.TypeNameSupport;
import io.helidon.common.types.TypeNames;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

@Prototype.Blueprint(decorator=TypeNameSupport.Decorator.class)
@Prototype.CustomMethods(value=TypeNameSupport.class)
@Prototype.Implement(value={"java.lang.Comparable<TypeName>"})
interface TypeNameBlueprint {
    @Option.Default(value={""})
    public String packageName();

    @Option.Required
    public String className();

    default public String classNameWithEnclosingNames() {
        ArrayList<String> allNames = new ArrayList<String>(this.enclosingNames());
        allNames.add(this.className());
        return String.join((CharSequence)".", allNames);
    }

    @Option.Singular
    public List<String> enclosingNames();

    @Option.DefaultBoolean(value={false})
    public boolean primitive();

    @Option.DefaultBoolean(value={false})
    public boolean array();

    @Option.DefaultBoolean(value={false})
    @Option.Redundant
    public boolean vararg();

    @Option.Redundant
    @Option.DefaultBoolean(value={false})
    public boolean generic();

    @Option.Redundant
    @Option.DefaultBoolean(value={false})
    public boolean wildcard();

    @Option.Singular
    @Option.Redundant
    public List<TypeName> typeArguments();

    @Deprecated(forRemoval=true, since="4.2.0")
    @Option.Singular
    @Option.Redundant
    public List<String> typeParameters();

    @Option.Singular
    @Option.Redundant
    public List<TypeName> lowerBounds();

    @Option.Singular
    @Option.Redundant
    public List<TypeName> upperBounds();

    public Optional<TypeName> componentType();

    default public boolean isList() {
        return TypeNames.LIST.name().equals(this.name());
    }

    default public boolean isSet() {
        return TypeNames.SET.name().equals(this.name());
    }

    default public boolean isMap() {
        return TypeNames.MAP.name().equals(this.name());
    }

    default public boolean isOptional() {
        return TypeNames.OPTIONAL.name().equals(this.name());
    }

    default public boolean isSupplier() {
        return TypeNames.SUPPLIER.fqName().equals(this.fqName());
    }

    default public String classNameWithTypes() {
        return this.className() + this.typeArgumentsDeclaration();
    }

    default public String name() {
        return this.className();
    }

    default public String declaredName() {
        return this.className();
    }

    default public String fqName() {
        return this.className();
    }

    default public String resolvedName() {
        return this.className();
    }

    private String typeArgumentsDeclaration() {
        if (this.typeArguments().isEmpty()) {
            return "";
        }
        String types = this.typeArguments().stream().map(TypeNameBlueprint::classNameWithTypes).collect(Collectors.joining(", "));
        return "<" + types + ">";
    }
}

