/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.hapi.block.stream.output;

import com.hedera.hapi.block.stream.output.codec.BlockHeaderJsonCodec;
import com.hedera.hapi.block.stream.output.codec.BlockHeaderProtoCodec;
import com.hedera.hapi.block.stream.output.schema.BlockHeaderSchema;
import com.hedera.hapi.node.base.BlockHashAlgorithm;
import com.hedera.hapi.node.base.SemanticVersion;
import com.hedera.hapi.node.base.Timestamp;
import com.hedera.pbj.runtime.Codec;
import com.hedera.pbj.runtime.EnumWithProtoMetadata;
import com.hedera.pbj.runtime.FieldDefinition;
import com.hedera.pbj.runtime.JsonCodec;
import com.hedera.pbj.runtime.ProtoWriterTools;
import com.hedera.pbj.runtime.UnknownField;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

public final class BlockHeader {
    public static final Codec<BlockHeader> PROTOBUF = new BlockHeaderProtoCodec();
    public static final JsonCodec<BlockHeader> JSON = new BlockHeaderJsonCodec();
    public static final BlockHeader DEFAULT = BlockHeader.newBuilder().build();
    @Nullable
    private final SemanticVersion hapiProtoVersion;
    @Nullable
    private final SemanticVersion softwareVersion;
    private final long number;
    @Nullable
    private final Timestamp blockTimestamp;
    private final Object hashAlgorithm;
    private int $hashCode = -1;
    private int $protobufEncodedSize = -1;
    private final List<UnknownField> $unknownFields;

    public BlockHeader(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, BlockHashAlgorithm hashAlgorithm) {
        this.$unknownFields = null;
        this.hapiProtoVersion = hapiProtoVersion;
        this.softwareVersion = softwareVersion;
        this.number = number;
        this.blockTimestamp = blockTimestamp;
        this.hashAlgorithm = hashAlgorithm;
    }

    public BlockHeader(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, Object hashAlgorithm) {
        this.$unknownFields = null;
        this.hapiProtoVersion = hapiProtoVersion;
        this.softwareVersion = softwareVersion;
        this.number = number;
        this.blockTimestamp = blockTimestamp;
        this.hashAlgorithm = hashAlgorithm;
    }

    public BlockHeader(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, BlockHashAlgorithm hashAlgorithm, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.hapiProtoVersion = hapiProtoVersion;
        this.softwareVersion = softwareVersion;
        this.number = number;
        this.blockTimestamp = blockTimestamp;
        this.hashAlgorithm = hashAlgorithm;
    }

    public BlockHeader(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, Object hashAlgorithm, List<UnknownField> $unknownFields) {
        this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
        this.hapiProtoVersion = hapiProtoVersion;
        this.softwareVersion = softwareVersion;
        this.number = number;
        this.blockTimestamp = blockTimestamp;
        this.hashAlgorithm = hashAlgorithm;
    }

    public SemanticVersion hapiProtoVersion() {
        return this.hapiProtoVersion;
    }

    public SemanticVersion softwareVersion() {
        return this.softwareVersion;
    }

    public long number() {
        return this.number;
    }

    public Timestamp blockTimestamp() {
        return this.blockTimestamp;
    }

    public BlockHashAlgorithm hashAlgorithm() {
        return BlockHashAlgorithm.fromObject(this.hashAlgorithm);
    }

    public int hashAlgorithmProtoOrdinal() {
        return BlockHashAlgorithm.toProtoOrdinal(this.hashAlgorithm);
    }

    @NonNull
    public List<UnknownField> getUnknownFields() {
        return this.$unknownFields == null ? Collections.EMPTY_LIST : this.$unknownFields;
    }

    public int protobufSize() {
        if (this.$protobufEncodedSize == -1) {
            int _size = 0;
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockHeaderSchema.HAPI_PROTO_VERSION, (Object)this.hapiProtoVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockHeaderSchema.SOFTWARE_VERSION, (Object)this.softwareVersion, SemanticVersion.PROTOBUF);
            _size += ProtoWriterTools.sizeOfLong((FieldDefinition)BlockHeaderSchema.NUMBER, (long)this.number, (boolean)true);
            _size += ProtoWriterTools.sizeOfMessage((FieldDefinition)BlockHeaderSchema.BLOCK_TIMESTAMP, (Object)this.blockTimestamp, Timestamp.PROTOBUF);
            _size += ProtoWriterTools.sizeOfEnum((FieldDefinition)BlockHeaderSchema.HASH_ALGORITHM, (Object)this.hashAlgorithm);
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    UnknownField uf = this.$unknownFields.get(i);
                    _size += ProtoWriterTools.sizeOfVarInt32((int)(uf.field() << 3 | uf.wireType().ordinal()));
                    _size += Math.toIntExact(uf.bytes().length());
                }
            }
            this.$protobufEncodedSize = _size;
        }
        return this.$protobufEncodedSize;
    }

    public int hashCode() {
        if (this.$hashCode == -1) {
            int result = 1;
            if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(BlockHeader.DEFAULT.hapiProtoVersion)) {
                result = 31 * result + this.hapiProtoVersion.hashCode();
            }
            if (this.softwareVersion != null && !this.softwareVersion.equals(BlockHeader.DEFAULT.softwareVersion)) {
                result = 31 * result + this.softwareVersion.hashCode();
            }
            if (this.number != BlockHeader.DEFAULT.number) {
                result = 31 * result + Long.hashCode(this.number);
            }
            if (this.blockTimestamp != null && !this.blockTimestamp.equals(BlockHeader.DEFAULT.blockTimestamp)) {
                result = 31 * result + this.blockTimestamp.hashCode();
            }
            if (this.hashAlgorithm != null && !this.hashAlgorithm.equals(BlockHeader.DEFAULT.hashAlgorithm)) {
                result = 31 * result + Integer.hashCode(EnumWithProtoMetadata.protoOrdinal((Object)this.hashAlgorithm));
            }
            if (this.$unknownFields != null) {
                for (int i = 0; i < this.$unknownFields.size(); ++i) {
                    result = 31 * result + this.$unknownFields.get(i).hashCode();
                }
            }
            long hashCode = result;
            hashCode += hashCode << 30;
            hashCode ^= hashCode >>> 27;
            hashCode += hashCode << 16;
            hashCode ^= hashCode >>> 20;
            hashCode += hashCode << 5;
            hashCode ^= hashCode >>> 18;
            hashCode += hashCode << 10;
            hashCode ^= hashCode >>> 24;
            hashCode += hashCode << 30;
            this.$hashCode = (int)hashCode;
        }
        return this.$hashCode;
    }

    public boolean equals(Object that) {
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        BlockHeader thatObj = (BlockHeader)that;
        if (this.$hashCode != -1 && thatObj.$hashCode != -1 && this.$hashCode != thatObj.$hashCode) {
            return false;
        }
        if (this.hapiProtoVersion == null && thatObj.hapiProtoVersion != null) {
            return false;
        }
        if (this.hapiProtoVersion != null && !this.hapiProtoVersion.equals(thatObj.hapiProtoVersion)) {
            return false;
        }
        if (this.softwareVersion == null && thatObj.softwareVersion != null) {
            return false;
        }
        if (this.softwareVersion != null && !this.softwareVersion.equals(thatObj.softwareVersion)) {
            return false;
        }
        if (this.number != thatObj.number) {
            return false;
        }
        if (this.blockTimestamp == null && thatObj.blockTimestamp != null) {
            return false;
        }
        if (this.blockTimestamp != null && !this.blockTimestamp.equals(thatObj.blockTimestamp)) {
            return false;
        }
        if (this.hashAlgorithm == null && thatObj.hashAlgorithm != null) {
            return false;
        }
        if (this.hashAlgorithm != null && !this.hashAlgorithm.equals(thatObj.hashAlgorithm)) {
            return false;
        }
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            if (thatObj.$unknownFields == null || this.$unknownFields.size() != thatObj.$unknownFields.size()) {
                return false;
            }
            if (!this.$unknownFields.equals(thatObj.$unknownFields)) {
                return false;
            }
        } else if (thatObj.$unknownFields != null && !thatObj.$unknownFields.isEmpty()) {
            return false;
        }
        return true;
    }

    public String toString() {
        String $ufstr = null;
        if (this.$unknownFields != null && !this.$unknownFields.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < this.$unknownFields.size(); ++i) {
                if (i > 0) {
                    sb.append(", ");
                }
                this.$unknownFields.get(i).printToString(sb);
            }
            $ufstr = sb.toString();
        }
        return "BlockHeader[hapiProtoVersion=" + String.valueOf(this.hapiProtoVersion) + ", softwareVersion=" + String.valueOf(this.softwareVersion) + ", number=" + this.number + ", blockTimestamp=" + String.valueOf(this.blockTimestamp) + ", hashAlgorithm=" + String.valueOf(this.hashAlgorithm) + (String)($ufstr == null ? "" : ", " + $ufstr) + "]";
    }

    public boolean hasHapiProtoVersion() {
        return this.hapiProtoVersion != null;
    }

    public SemanticVersion hapiProtoVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasHapiProtoVersion() ? this.hapiProtoVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion hapiProtoVersionOrThrow() {
        return Objects.requireNonNull(this.hapiProtoVersion, "Field hapiProtoVersion is null");
    }

    public void ifHapiProtoVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasHapiProtoVersion()) {
            ifPresent.accept(this.hapiProtoVersion);
        }
    }

    public boolean hasSoftwareVersion() {
        return this.softwareVersion != null;
    }

    public SemanticVersion softwareVersionOrElse(@NonNull SemanticVersion defaultValue) {
        return this.hasSoftwareVersion() ? this.softwareVersion : defaultValue;
    }

    @NonNull
    public SemanticVersion softwareVersionOrThrow() {
        return Objects.requireNonNull(this.softwareVersion, "Field softwareVersion is null");
    }

    public void ifSoftwareVersion(@NonNull Consumer<SemanticVersion> ifPresent) {
        if (this.hasSoftwareVersion()) {
            ifPresent.accept(this.softwareVersion);
        }
    }

    public boolean hasBlockTimestamp() {
        return this.blockTimestamp != null;
    }

    public Timestamp blockTimestampOrElse(@NonNull Timestamp defaultValue) {
        return this.hasBlockTimestamp() ? this.blockTimestamp : defaultValue;
    }

    @NonNull
    public Timestamp blockTimestampOrThrow() {
        return Objects.requireNonNull(this.blockTimestamp, "Field blockTimestamp is null");
    }

    public void ifBlockTimestamp(@NonNull Consumer<Timestamp> ifPresent) {
        if (this.hasBlockTimestamp()) {
            ifPresent.accept(this.blockTimestamp);
        }
    }

    public Builder copyBuilder() {
        return new Builder(this.hapiProtoVersion, this.softwareVersion, this.number, this.blockTimestamp, this.hashAlgorithm, this.$unknownFields);
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private SemanticVersion hapiProtoVersion = null;
        @Nullable
        private SemanticVersion softwareVersion = null;
        private long number = 0L;
        @Nullable
        private Timestamp blockTimestamp = null;
        private Object hashAlgorithm = BlockHashAlgorithm.fromProtobufOrdinal(0);
        private final List<UnknownField> $unknownFields;

        public Builder() {
            this.$unknownFields = null;
        }

        public Builder(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, BlockHashAlgorithm hashAlgorithm) {
            this.$unknownFields = null;
            this.hapiProtoVersion = hapiProtoVersion;
            this.softwareVersion = softwareVersion;
            this.number = number;
            this.blockTimestamp = blockTimestamp;
            this.hashAlgorithm = hashAlgorithm;
        }

        public Builder(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, Object hashAlgorithm) {
            this.$unknownFields = null;
            this.hapiProtoVersion = hapiProtoVersion;
            this.softwareVersion = softwareVersion;
            this.number = number;
            this.blockTimestamp = blockTimestamp;
            this.hashAlgorithm = hashAlgorithm;
        }

        public Builder(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, BlockHashAlgorithm hashAlgorithm, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.hapiProtoVersion = hapiProtoVersion;
            this.softwareVersion = softwareVersion;
            this.number = number;
            this.blockTimestamp = blockTimestamp;
            this.hashAlgorithm = hashAlgorithm;
        }

        public Builder(SemanticVersion hapiProtoVersion, SemanticVersion softwareVersion, long number, Timestamp blockTimestamp, Object hashAlgorithm, List<UnknownField> $unknownFields) {
            this.$unknownFields = $unknownFields == null ? null : Collections.unmodifiableList($unknownFields);
            this.hapiProtoVersion = hapiProtoVersion;
            this.softwareVersion = softwareVersion;
            this.number = number;
            this.blockTimestamp = blockTimestamp;
            this.hashAlgorithm = hashAlgorithm;
        }

        public BlockHeader build() {
            return new BlockHeader(this.hapiProtoVersion, this.softwareVersion, this.number, this.blockTimestamp, this.hashAlgorithm);
        }

        public Builder hapiProtoVersion(@Nullable SemanticVersion hapiProtoVersion) {
            this.hapiProtoVersion = hapiProtoVersion;
            return this;
        }

        public Builder hapiProtoVersion(SemanticVersion.Builder builder) {
            this.hapiProtoVersion = builder.build();
            return this;
        }

        public Builder softwareVersion(@Nullable SemanticVersion softwareVersion) {
            this.softwareVersion = softwareVersion;
            return this;
        }

        public Builder softwareVersion(SemanticVersion.Builder builder) {
            this.softwareVersion = builder.build();
            return this;
        }

        public Builder number(long number) {
            this.number = number;
            return this;
        }

        public Builder blockTimestamp(@Nullable Timestamp blockTimestamp) {
            this.blockTimestamp = blockTimestamp;
            return this;
        }

        public Builder blockTimestamp(Timestamp.Builder builder) {
            this.blockTimestamp = builder.build();
            return this;
        }

        public Builder hashAlgorithm(BlockHashAlgorithm hashAlgorithm) {
            this.hashAlgorithm = hashAlgorithm;
            return this;
        }

        public SemanticVersion hapiProtoVersion() {
            return this.hapiProtoVersion;
        }

        public SemanticVersion softwareVersion() {
            return this.softwareVersion;
        }

        public long number() {
            return this.number;
        }

        public Timestamp blockTimestamp() {
            return this.blockTimestamp;
        }

        public BlockHashAlgorithm hashAlgorithm() {
            return BlockHashAlgorithm.fromObject(this.hashAlgorithm);
        }

        public int hashAlgorithmProtoOrdinal() {
            return BlockHashAlgorithm.toProtoOrdinal(this.hashAlgorithm);
        }
    }
}

