/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.scope;

import com.hedera.hapi.node.base.AccountID;
import com.hedera.hapi.node.base.ContractID;
import com.hedera.hapi.node.base.Key;
import com.hedera.hapi.node.base.NftID;
import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.base.ScheduleID;
import com.hedera.hapi.node.base.TokenID;
import com.hedera.hapi.node.base.TransactionID;
import com.hedera.hapi.node.state.schedule.Schedule;
import com.hedera.hapi.node.state.token.Account;
import com.hedera.hapi.node.state.token.Nft;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.hapi.node.state.token.TokenRelation;
import com.hedera.hapi.node.token.CryptoTransferTransactionBody;
import com.hedera.node.app.service.contract.impl.exec.scope.VerificationStrategy;
import com.hedera.node.app.service.contract.impl.state.WritableEvmHookStore;
import com.hedera.node.app.service.entityid.EntityIdFactory;
import com.hedera.node.app.service.schedule.ReadableScheduleStore;
import com.hedera.node.app.service.token.ReadableAccountStore;
import com.hedera.node.app.service.token.ReadableNftStore;
import com.hedera.node.app.service.token.ReadableTokenRelationStore;
import com.hedera.node.app.service.token.ReadableTokenStore;
import com.hedera.node.app.spi.key.KeyVerifier;
import com.hedera.pbj.runtime.io.buffer.Bytes;
import com.swirlds.config.api.Configuration;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import java.util.Objects;
import java.util.SortedSet;
import org.hyperledger.besu.evm.frame.MessageFrame;

public interface HederaNativeOperations {
    public static final long MISSING_ENTITY_NUMBER = -1L;
    public static final long NON_CANONICAL_REFERENCE_NUMBER = -2L;

    @NonNull
    public ReadableNftStore readableNftStore();

    @NonNull
    public ReadableTokenRelationStore readableTokenRelationStore();

    @NonNull
    public ReadableTokenStore readableTokenStore();

    @NonNull
    public ReadableAccountStore readableAccountStore();

    @NonNull
    public ReadableScheduleStore readableScheduleStore();

    @NonNull
    public WritableEvmHookStore writableEvmHookStore();

    @Nullable
    default public Account getAccount(ContractID contractID) {
        return this.readableAccountStore().getContractById(contractID);
    }

    @Nullable
    default public Account getAccount(AccountID accountID) {
        return this.readableAccountStore().getAccountById(accountID);
    }

    @Nullable
    default public Key getAccountKey(@NonNull AccountID accountId) {
        Objects.requireNonNull(accountId);
        Account maybeAccount = this.getAccount(accountId);
        return maybeAccount == null ? null : maybeAccount.keyOrThrow();
    }

    @Nullable
    default public Token getToken(@NonNull TokenID tokenID) {
        return this.readableTokenStore().get(tokenID);
    }

    @Nullable
    default public TokenRelation getTokenRelation(@NonNull AccountID accountID, @NonNull TokenID tokenID) {
        return this.readableTokenRelationStore().get(accountID, tokenID);
    }

    @Nullable
    default public Nft getNft(@NonNull TokenID tokenID, long serialNo) {
        return this.readableNftStore().get(NftID.newBuilder().tokenId(tokenID).serialNumber(serialNo).build());
    }

    @Nullable
    default public Schedule getSchedule(@NonNull ScheduleID scheduleID) {
        return this.readableScheduleStore().get(scheduleID);
    }

    default public long resolveAlias(long shard, long realm, @NonNull Bytes evmAddress) {
        AccountID account = this.readableAccountStore().getAccountIDByAlias(shard, realm, evmAddress);
        return account == null ? -1L : account.accountNumOrThrow();
    }

    public void setNonce(long var1, long var3);

    public ResponseCodeEnum createHollowAccount(@NonNull Bytes var1);

    public void finalizeHollowAccountAsContract(@NonNull Bytes var1);

    public boolean canScheduleContractCall(long var1, long var3, @NonNull AccountID var5);

    public ResponseCodeEnum transferWithReceiverSigCheck(long var1, AccountID var3, AccountID var4, @NonNull VerificationStrategy var5);

    public void trackSelfDestructBeneficiary(AccountID var1, AccountID var2, @NonNull MessageFrame var3);

    public boolean checkForCustomFees(@NonNull CryptoTransferTransactionBody var1);

    default public SortedSet<Key> authorizingSimpleKeys() {
        return KeyVerifier.NO_AUTHORIZING_KEYS;
    }

    public TransactionID getTransactionID();

    public EntityIdFactory entityIdFactory();

    public Configuration configuration();
}

