/*
 * Decompiled with CFR 0.152.
 */
package com.hedera.node.app.service.contract.impl.exec.systemcontracts.hts;

import com.hedera.hapi.node.base.ResponseCodeEnum;
import com.hedera.hapi.node.state.token.Token;
import com.hedera.node.app.service.contract.impl.exec.gas.SystemContractGasCalculator;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.FullResult;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.AbstractCall;
import com.hedera.node.app.service.contract.impl.exec.systemcontracts.common.Call;
import com.hedera.node.app.service.contract.impl.hevm.HederaWorldUpdater;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;

public abstract class AbstractTokenViewCall
extends AbstractCall {
    protected final Token token;

    protected AbstractTokenViewCall(@NonNull SystemContractGasCalculator gasCalculator, @NonNull HederaWorldUpdater.Enhancement enhancement, @Nullable Token token) {
        super(gasCalculator, enhancement, true);
        this.token = token;
    }

    @Override
    @NonNull
    public Call.PricedResult execute() {
        if (this.token == null) {
            return this.failedViewResult(ResponseCodeEnum.INVALID_TOKEN_ID, this.gasCalculator.viewGasRequirement());
        }
        return this.resultOfViewingToken(this.token);
    }

    @Override
    public boolean allowsStaticFrame() {
        return true;
    }

    protected Call.PricedResult failedViewResult(ResponseCodeEnum responseCode, long gasRequirement) {
        return Call.PricedResult.gasOnly(this.viewCallResultWith(responseCode, gasRequirement), responseCode, true);
    }

    @NonNull
    protected abstract Call.PricedResult resultOfViewingToken(@NonNull Token var1);

    @NonNull
    protected abstract FullResult viewCallResultWith(@NonNull ResponseCodeEnum var1, long var2);
}

